/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.derby;

import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.derby.iapi.db.Factory;
import org.apache.derby.iapi.db.TriggerExecutionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.jumpmind.db.sql.SqlUtils;

public class DerbyFunctions {
    private static final String CURRENT_CONNECTION_URL = "jdbc:default:connection";
    private static final int MAX_STRING_LENGTH = 32672;
    private static final int MAX_BINARY_LENGTH = 23700;
    private static Hashtable<String, Boolean> syncDisabledTable = new Hashtable();
    private static Hashtable<String, String> syncNodeDisabledTable = new Hashtable();

    public static String getTransactionId() throws SQLException {
        return DerbyFunctions.getLanguageConnection().getTransactionExecute().getTransactionIdString();
    }

    public static String getSessionId() throws SQLException {
        return DerbyFunctions.getLanguageConnection().getDbname() + "-" + DerbyFunctions.getLanguageConnection().getInstanceNumber();
    }

    public static int isSyncDisabled() throws SQLException {
        return syncDisabledTable.get(DerbyFunctions.getSessionId()) != null ? 1 : 0;
    }

    public static String getSyncNodeDisabled() throws SQLException {
        return syncNodeDisabledTable.get(DerbyFunctions.getSessionId());
    }

    public static String setSyncNodeDisabled(String nodeId) throws SQLException {
        if (nodeId == null) {
            return syncNodeDisabledTable.remove(DerbyFunctions.getSessionId());
        }
        return syncNodeDisabledTable.put(DerbyFunctions.getSessionId(), nodeId);
    }

    public static int setSyncDisabled(int disabledIndicator) throws SQLException {
        if (disabledIndicator == 0) {
            syncDisabledTable.remove(DerbyFunctions.getSessionId());
            return 0;
        }
        syncDisabledTable.put(DerbyFunctions.getSessionId(), Boolean.TRUE);
        return 1;
    }

    protected static int findColumnIndex(ResultSetMetaData metaData, String columnName) throws SQLException {
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            if (!columnName.equals(metaData.getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    protected static void appendCsvString(String tableName, String[] columnNames, String[] pkColumnNames, ResultSet rs, StringBuilder builder) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        for (String columnName : columnNames) {
            if (StringUtils.isNotBlank((CharSequence)columnName)) {
                int index = DerbyFunctions.findColumnIndex(metaData, columnName);
                if (index >= 0) {
                    int type = metaData.getColumnType(index);
                    switch (type) {
                        case 2004: {
                            builder.append(DerbyFunctions.blobToString(columnName, tableName, DerbyFunctions.getPrimaryKeyWhereString(pkColumnNames, rs)));
                            builder.append(",");
                            break;
                        }
                        case 2005: {
                            builder.append(DerbyFunctions.clobToString(columnName, tableName, DerbyFunctions.getPrimaryKeyWhereString(pkColumnNames, rs)));
                            builder.append(",");
                            break;
                        }
                        default: {
                            builder.append(DerbyFunctions.escape(rs.getString(index)));
                            builder.append(",");
                            break;
                        }
                    }
                    continue;
                }
                builder.append(",");
                continue;
            }
            builder.append(",");
        }
    }

    public static void insertData(int enabled, String schemaName, String prefixName, String tableName, String channelName, String dmlType, int triggerHistId, String transactionId, String externalData, String columnNames, String pkColumnNames) throws SQLException {
        if (enabled == 1) {
            StringBuilder dataBuilder;
            TriggerExecutionContext context = Factory.getTriggerExecutionContext();
            String rowData = null;
            String pkData = null;
            String oldData = null;
            String[] parsedColumnNames = StringUtils.splitPreserveAllTokens((String)columnNames, (char)',');
            String[] parsedPkColumnNames = StringUtils.splitPreserveAllTokens((String)pkColumnNames, (char)',');
            if (dmlType.equals("I") || dmlType.equals("U")) {
                dataBuilder = new StringBuilder();
                DerbyFunctions.appendCsvString(tableName, parsedColumnNames, parsedPkColumnNames, context.getNewRow(), dataBuilder);
                rowData = dataBuilder.substring(0, dataBuilder.length() - 1);
            }
            if (dmlType.equals("U") || dmlType.equals("D")) {
                dataBuilder = new StringBuilder();
                DerbyFunctions.appendCsvString(tableName, parsedColumnNames, parsedPkColumnNames, context.getOldRow(), dataBuilder);
                oldData = dataBuilder.substring(0, dataBuilder.length() - 1);
                dataBuilder = new StringBuilder();
                DerbyFunctions.appendCsvString(tableName, parsedPkColumnNames, parsedPkColumnNames, context.getOldRow(), dataBuilder);
                pkData = dataBuilder.substring(0, dataBuilder.length() - 1);
            }
            Connection conn = DriverManager.getConnection(CURRENT_CONNECTION_URL);
            StringBuilder sql = new StringBuilder("insert into ");
            sql.append(schemaName);
            sql.append(prefixName);
            sql.append("_data (table_name, event_type, trigger_hist_id, pk_data, row_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time) ");
            sql.append(" values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, current_timestamp)");
            PreparedStatement ps = conn.prepareStatement(sql.toString());
            ps.setString(1, tableName);
            ps.setString(2, dmlType);
            ps.setLong(3, triggerHistId);
            ps.setString(4, pkData);
            ps.setString(5, rowData);
            ps.setString(6, oldData);
            ps.setString(7, channelName);
            ps.setString(8, transactionId);
            ps.setString(9, DerbyFunctions.getSyncNodeDisabled());
            ps.setString(10, externalData);
            ps.executeUpdate();
            ps.close();
            conn.close();
        }
    }

    @Deprecated
    public static void insertData(String schemaName, String prefixName, String tableName, String channelName, String dmlType, int triggerHistId, String transactionId, String externalData, String pkData, String rowData, String oldRowData) throws SQLException {
        if ((dmlType.equals("I") || dmlType.equals("U")) && rowData != null || dmlType.equals("D")) {
            Connection conn = DriverManager.getConnection(CURRENT_CONNECTION_URL);
            StringBuilder sql = new StringBuilder("insert into ");
            sql.append(schemaName);
            sql.append(prefixName);
            sql.append("_data (table_name, event_type, trigger_hist_id, pk_data, row_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time) ");
            sql.append(" values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, current_timestamp)");
            PreparedStatement ps = conn.prepareStatement(sql.toString());
            ps.setString(1, tableName);
            ps.setString(2, dmlType);
            ps.setLong(3, triggerHistId);
            ps.setString(4, pkData);
            ps.setString(5, rowData);
            ps.setString(6, oldRowData);
            ps.setString(7, channelName);
            ps.setString(8, transactionId);
            ps.setString(9, DerbyFunctions.getSyncNodeDisabled());
            ps.setString(10, externalData);
            ps.executeUpdate();
            ps.close();
            conn.close();
        }
    }

    public static String escape(String str) {
        if (str != null) {
            return "\"" + Strings.CS.replace(Strings.CS.replace(str, "\\", "\\\\"), "\"", "\\\"") + "\"";
        }
        return "";
    }

    public static String blobToString(String columnName, String tableName, String whereClause) throws SQLException {
        String str = null;
        if (StringUtils.isNotBlank((CharSequence)whereClause)) {
            String sql;
            Connection conn = DriverManager.getConnection(CURRENT_CONNECTION_URL);
            PreparedStatement ps = conn.prepareStatement(sql = "select " + SqlUtils.sanitizeIdentifier((String)columnName) + " from " + SqlUtils.sanitizeIdentifier((String)tableName) + " where " + whereClause);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                byte[] bytes = null;
                int type = rs.getMetaData().getColumnType(1);
                if (type == -2 || type == -3 || type == -4) {
                    bytes = rs.getBytes(1);
                } else {
                    Blob blob = rs.getBlob(1);
                    if (blob != null) {
                        bytes = blob.getBytes(1L, 23700);
                    }
                }
                if (bytes != null) {
                    str = new String(Base64.encodeBase64((byte[])bytes), Charset.defaultCharset());
                }
            }
            ps.close();
            conn.close();
        }
        return str == null ? "" : "\"" + str + "\"";
    }

    public static String clobToString(String columnName, String tableName, String whereClause) throws SQLException {
        String str = null;
        if (StringUtils.isNotBlank((CharSequence)whereClause)) {
            Clob clob;
            String sql;
            Connection conn = DriverManager.getConnection(CURRENT_CONNECTION_URL);
            PreparedStatement ps = conn.prepareStatement(sql = "select " + SqlUtils.sanitizeIdentifier((String)columnName) + " from " + SqlUtils.sanitizeIdentifier((String)tableName) + " where " + whereClause);
            ResultSet rs = ps.executeQuery();
            if (rs.next() && (clob = rs.getClob(1)) != null) {
                str = clob.getSubString(1L, 32672);
            }
            ps.close();
            conn.close();
        }
        return str == null ? "" : DerbyFunctions.escape(str);
    }

    public static String getPrimaryKeyWhereString(String[] pkColumnNames, ResultSet rs) throws SQLException {
        String AND = " and ";
        ResultSetMetaData metaData = rs.getMetaData();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < pkColumnNames.length; ++i) {
            String columnName = SqlUtils.sanitizeIdentifier((String)pkColumnNames[i]);
            int index = DerbyFunctions.findColumnIndex(metaData, columnName);
            int type = metaData.getColumnType(index);
            if (type == -2 || type == 2004 || type == -4 || type == -3) continue;
            b.append("\"").append(columnName).append("\"=");
            switch (type) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    b.append(rs.getObject(index));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    b.append("'").append(SqlUtils.escapeString((String)rs.getString(index))).append("'");
                    break;
                }
                case 91: {
                    b.append("{d '");
                    b.append(SqlUtils.escapeString((String)rs.getString(index)));
                    b.append("'}");
                    break;
                }
                case 93: {
                    b.append("{ts '");
                    b.append(SqlUtils.escapeString((String)rs.getString(index)));
                    b.append("'}");
                }
            }
            b.append(" and ");
        }
        b.replace(b.length() - " and ".length(), b.length(), "");
        return b.toString();
    }

    private static LanguageConnectionContext getLanguageConnection() throws SQLException {
        EmbedConnection conn = (EmbedConnection)DriverManager.getConnection(CURRENT_CONNECTION_URL);
        return conn.getLanguageConnection();
    }
}

