/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.firebird;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.db.firebird.Firebird20SymmetricDialect;
import org.jumpmind.symmetric.db.firebird.Firebird21TriggerTemplate;
import org.jumpmind.symmetric.service.IParameterService;

public class Firebird21SymmetricDialect
extends Firebird20SymmetricDialect {
    static final String SQL_DROP_FUNCTION = "DROP FUNCTION $(functionName)";

    public Firebird21SymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new Firebird21TriggerTemplate(this);
    }

    @Override
    public void createRequiredDatabaseObjectsImpl(StringBuilder ddl) {
        String hex = this.parameterService.getTablePrefix() + "_hex";
        if (!this.installed("select count(*) from rdb$functions where rdb$function_name = upper('$(functionName)')", hex)) {
            if (this.databaseMajorVersion >= 4) {
                String sql = "CREATE FUNCTION $(functionName)(b blob) RETURNS blob AS\nBEGIN\n    RETURN (SELECT HEX_ENCODE(:b) FROM rdb$database);\nEND";
                this.install(sql, hex, ddl);
            } else {
                String sql = "declare external function $(functionName) blob                                                                                                                                                           returns cstring(32660) free_it entry_point 'sym_hex' module_name 'sym_udf'                                                                                             ";
                this.install(sql, hex, ddl);
            }
        }
    }

    @Override
    public void dropRequiredDatabaseObjects() {
        String hex = this.parameterService.getTablePrefix() + "_hex";
        if (this.installed("select count(*) from rdb$functions where rdb$function_name = upper('$(functionName)')", hex)) {
            if (this.databaseMajorVersion >= 4) {
                this.uninstall(SQL_DROP_FUNCTION, hex);
            } else {
                this.uninstall("DROP EXTERNAL FUNCTION $(functionName)", hex);
            }
        }
    }
}

