/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.hsqldb;

import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractEmbeddedSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.hsqldb.HsqlDbTriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;

public class HsqlDbSymmetricDialect
extends AbstractEmbeddedSymmetricDialect
implements ISymmetricDialect {
    static final String SQL_DROP_FUNCTION = "DROP ALIAS $(functionName)";
    static final String SQL_FUNCTION_INSTALLED = "select count(*) from INFORMATION_SCHEMA.SYSTEM_ALIASES where ALIAS='$(functionName)'";
    static final String DUAL_TABLE = "DUAL";
    private boolean enforceStrictSize = true;

    public HsqlDbSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new HsqlDbTriggerTemplate(this);
        platform.getSqlTemplate().update("SET WRITE_DELAY 100 MILLIS", new Object[0]);
        platform.getSqlTemplate().update("SET PROPERTY \"hsqldb.default_table_type\" 'cached'", new Object[0]);
        platform.getSqlTemplate().update("SET PROPERTY \"sql.enforce_strict_size\" " + this.enforceStrictSize, new Object[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                HsqlDbSymmetricDialect.this.platform.getSqlTemplate().update("SHUTDOWN", new Object[0]);
            }
        });
        this.createDummyDualTable();
    }

    protected boolean doesTriggerExistOnPlatform(StringBuilder sqlBuffer, String catalogName, String schemaName, String tableName, String triggerName) {
        boolean exists = this.platform.getSqlTemplate().queryForInt("select count(*) from INFORMATION_SCHEMA.SYSTEM_TRIGGERS WHERE TRIGGER_NAME = ?", new Object[]{triggerName}) > 0 || this.platform.getSqlTemplate().queryForInt("select count(*) from INFORMATION_SCHEMA.SYSTEM_TABLES WHERE TABLE_NAME = ?", new Object[]{String.format("%s_CONFIG", triggerName)}) > 0;
        return exists;
    }

    public void createRequiredDatabaseObjectsImpl(StringBuilder ddl) {
        String getSession;
        String setSession;
        String encode = this.parameterService.getTablePrefix() + "_base_64_encode";
        if (!this.installed(SQL_FUNCTION_INSTALLED, encode)) {
            String sql = "CREATE ALIAS $(functionName) for \"org.jumpmind.symmetric.db.hsqldb.HsqlDbFunctions.encodeBase64\"; ";
            this.install(sql, encode, ddl);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, setSession = this.parameterService.getTablePrefix() + "_set_session")) {
            String sql = "CREATE ALIAS $(functionName) for \"org.jumpmind.symmetric.db.hsqldb.HsqlDbFunctions.setSession\"; ";
            this.install(sql, setSession, ddl);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, getSession = this.parameterService.getTablePrefix() + "_get_session")) {
            String sql = "CREATE ALIAS $(functionName) for \"org.jumpmind.symmetric.db.hsqldb.HsqlDbFunctions.getSession\"; ";
            this.install(sql, getSession, ddl);
        }
    }

    public void dropRequiredDatabaseObjects() {
        String getSession;
        String setSession;
        String encode = this.parameterService.getTablePrefix() + "_base_64_encode";
        if (this.installed(SQL_FUNCTION_INSTALLED, encode)) {
            this.uninstall(SQL_DROP_FUNCTION, encode);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, setSession = this.parameterService.getTablePrefix() + "_set_session")) {
            this.uninstall(SQL_DROP_FUNCTION, setSession);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, getSession = this.parameterService.getTablePrefix() + "_get_session")) {
            this.uninstall(SQL_DROP_FUNCTION, getSession);
        }
    }

    private void createDummyDualTable() {
        Table table = this.platform.getTableFromCache(null, null, DUAL_TABLE, true);
        if (table == null) {
            this.platform.getSqlTemplate().update("CREATE MEMORY TABLE DUAL(DUMMY VARCHAR(1))", new Object[0]);
            this.platform.getSqlTemplate().update("INSERT INTO DUAL VALUES(NULL)", new Object[0]);
            this.platform.getSqlTemplate().update("SET TABLE DUAL READONLY TRUE", new Object[0]);
        }
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, ISqlTransaction transaction) {
        String dropSql = String.format("DROP TRIGGER %s", triggerName);
        this.logSql(dropSql, sqlBuffer);
        String dropTable = String.format("DROP TABLE IF EXISTS %s_CONFIG", triggerName);
        this.logSql(dropTable, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers") && sqlBuffer == null) {
            int count = transaction.execute(dropSql);
            if (count > 0) {
                this.log.info("Just dropped trigger {}", (Object)triggerName);
            }
            if ((count = transaction.execute(dropTable)) > 0) {
                this.log.info("Just dropped table {}_CONFIG", (Object)triggerName);
            }
        }
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public boolean isClobSyncSupported() {
        return true;
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute("CALL " + this.parameterService.getTablePrefix() + "_set_session('sync_prevented','1')", new Object[0]);
        transaction.prepareAndExecute("CALL " + this.parameterService.getTablePrefix() + "_set_session('node_value','" + nodeId + "')", new Object[0]);
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("CALL " + this.parameterService.getTablePrefix() + "_set_session('sync_prevented',null)", new Object[0]);
        transaction.prepareAndExecute("CALL " + this.parameterService.getTablePrefix() + "_set_session('node_value',null)", new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return " " + this.parameterService.getTablePrefix() + "_get_session(''sync_prevented'') is null ";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "null";
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    public boolean isNonBlankCharColumnSpacePadded() {
        return this.enforceStrictSize;
    }

    public boolean isCharColumnSpaceTrimmed() {
        return false;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    public boolean supportsTransactionId() {
        return false;
    }

    public void truncateTable(String tableName) {
        this.platform.getSqlTemplate().update("delete from " + tableName, new Object[0]);
    }

    public boolean canGapsOccurInCapturedDataIds() {
        return false;
    }

    public String getDatabaseTimeSQL() {
        return "SELECT current_timestamp FROM INFORMATION_SCHEMA.SYSTEM_USERS";
    }
}

