/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.nuodb;

import java.util.List;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.nuodb.NuoDbTriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;

public class NuoDbSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    static final String SQL_DROP_FUNCTION = "drop function $(functionName)";
    static final String SQL_FUNCTION_INSTALLED = "select count(*) from system.functions where functionname='$(functionName)' and schema in (select current_schema from system.dual)";
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "sync_node_disabled";

    public NuoDbSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new NuoDbTriggerTemplate(this);
        this.parameterService = parameterService;
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "(select transid from system.connections where connid = getconnectionid())";
    }

    public void createRequiredDatabaseObjectsImpl(StringBuilder ddl) {
        String sql;
        String function = this.parameterService.getTablePrefix() + "_get_session_variable";
        if (!this.installed(SQL_FUNCTION_INSTALLED, function)) {
            sql = "create function $(functionName)(akey string) returns string as\nVAR l_out string = NULL;\ntry\nl_out = (SELECT context_value from " + this.parameterService.getTablePrefix() + "_session_cache where name = akey);\ncatch(error)\ncreate temp table if not exists " + this.parameterService.getTablePrefix() + "_session_cache\n(name string primary key, context_value string) on commit preserve rows;\nend_try;\nreturn l_out;\nEND_FUNCTION;";
            this.install(sql, function, ddl);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, function = this.parameterService.getTablePrefix() + "_set_session_variable")) {
            sql = "create function $(functionName)(akey string, avalue string) returns string as\nVAR l_new string = NULL;\ntry\nINSERT INTO " + this.parameterService.getTablePrefix() + "_session_cache (name, context_value) \nvalues (akey, avalue) ON DUPLICATE KEY UPDATE context_value = avalue;\ncatch(error)\ncreate temp table if not exists " + this.parameterService.getTablePrefix() + "_session_cache\n(name string primary key, context_value string) on commit preserve rows;\nINSERT INTO " + this.parameterService.getTablePrefix() + "_session_cache VALUES (akey, avalue);\nl_new = error;\nend_try;\nreturn l_new;\nEND_FUNCTION;";
            this.install(sql, function, ddl);
        }
    }

    public void dropRequiredDatabaseObjects() {
        String function = this.parameterService.getTablePrefix() + "_get_session_variable";
        if (this.installed(SQL_FUNCTION_INSTALLED, function)) {
            this.uninstall(SQL_DROP_FUNCTION, function);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, function = this.parameterService.getTablePrefix() + "_set_session_variable")) {
            this.uninstall(SQL_DROP_FUNCTION, function);
        }
    }

    protected boolean doesTriggerExistOnPlatform(StringBuilder sqlBuffer, String catalog, String schema, String tableName, String triggerName) {
        schema = schema == null ? (this.platform.getDefaultSchema() == null ? null : this.platform.getDefaultSchema()) : schema;
        String checkSchemaSql = schema != null && schema.length() > 0 ? " and schema='" + schema + "'" : "";
        return this.platform.getSqlTemplate().queryForInt("select count(*) from system.triggers where triggername = ? and tablename = ?" + checkSchemaSql, new Object[]{triggerName, tableName}) > 0;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, ISqlTransaction transaction) {
        String sql = "drop trigger " + triggerName;
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers") && sqlBuffer == null) {
            this.log.info("Dropping {} trigger for {}", (Object)triggerName, (Object)Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName));
            transaction.execute(sql);
        }
    }

    public void cleanupTriggers() {
        List names = this.platform.getSqlTemplate().query("select triggername from system.triggers where triggername like '" + this.parameterService.getTablePrefix().toUpperCase() + "_%'", (ISqlRowMapper)new StringMapper(), new Object[0]);
        int count = 0;
        for (String name : names) {
            count += this.platform.getSqlTemplate().update("drop trigger " + name + " if exists", new Object[0]);
        }
        if (count > 0) {
            this.log.info("Remove {} triggers", (Object)count);
        }
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute("select " + this.parameterService.getTablePrefix() + "_set_session_variable('sync_triggers_disabled', '1') from dual", new Object[0]);
        if (nodeId != null) {
            transaction.prepareAndExecute("select " + this.parameterService.getTablePrefix() + "_set_session_variable('sync_node_disabled','" + nodeId + "') from dual", new Object[0]);
        }
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("select " + this.parameterService.getTablePrefix() + "_set_session_variable('sync_triggers_disabled', null) from dual", new Object[0]);
        transaction.prepareAndExecute("select " + this.parameterService.getTablePrefix() + "_set_session_variable('sync_node_disabled', null) from dual", new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return "$(defaultSchema)" + this.parameterService.getTablePrefix() + "_get_session_variable('sync_triggers_disabled') is null";
    }

    public void cleanDatabase() {
    }

    public boolean isClobSyncSupported() {
        return false;
    }

    public boolean isBlobSyncSupported() {
        return false;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.NONE;
    }

    public PermissionType[] getSymTablePermissions() {
        PermissionType[] permissions = new PermissionType[]{PermissionType.CREATE_TABLE, PermissionType.DROP_TABLE, PermissionType.CREATE_TRIGGER, PermissionType.DROP_TRIGGER};
        return permissions;
    }

    public String getDatabaseTimeSQL() {
        return "select current_timestamp from dual";
    }
}

