/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.oracle;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.DataEventType;

public class OracleTriggerTemplate
extends AbstractTriggerTemplate {
    String delimiter;

    public OracleTriggerTemplate(ISymmetricDialect symmetricDialect) {
        super(symmetricDialect);
        this.delimiter = symmetricDialect.getParameterService().getString("trigger.capture.ddl.delimiter", "$");
        this.emptyColumnTemplate = "''";
        this.stringColumnTemplate = "nvl2($(tableAlias).\"$(columnName)\", '\"'||replace(replace($(oracleToClob)$(tableAlias).\"$(columnName)\",'\\','\\\\'),'\"','\\\"')||'\"', '')";
        this.geometryColumnTemplate = "nvl2($(tableAlias).\"$(columnName)\", '\"'||replace(replace(SDO_UTIL.TO_WKTGEOMETRY($(tableAlias).\"$(columnName)\"),'\\','\\\\'),'\"','\\\"')||'\"', '')";
        this.numberColumnTemplate = "nvl2($(tableAlias).\"$(columnName)\", $(oracleToClob)'\"'||" + this.getNumberConversionString() + "||'\"', '')";
        this.datetimeColumnTemplate = "nvl2($(tableAlias).\"$(columnName)\", $(oracleToClob)concat(concat('\"',to_char($(tableAlias).\"$(columnName)\", 'YYYY-MM-DD HH24:MI:SS.FF9')),'\"'), '')";
        this.dateTimeWithTimeZoneColumnTemplate = "nvl2($(tableAlias).\"$(columnName)\", $(oracleToClob)concat(concat('\"',to_char($(tableAlias).\"$(columnName)\", 'YYYY-MM-DD HH24:MI:SS.FF9 TZH:TZM')),'\"'), '')";
        this.dateTimeWithLocalTimeZoneColumnTemplate = "nvl2($(tableAlias).\"$(columnName)\", $(oracleToClob)concat(concat('\"',to_char(cast($(tableAlias).\"$(columnName)\" as timestamp), 'YYYY-MM-DD HH24:MI:SS.FF9')),'\"'), '')";
        this.timeColumnTemplate = "nvl2($(tableAlias).\"$(columnName)\", $(oracleToClob)concat(concat('\"',to_char($(tableAlias).\"$(columnName)\", 'YYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=''GREGORIAN''')),'\"'), '')";
        this.dateColumnTemplate = "nvl2($(tableAlias).\"$(columnName)\", $(oracleToClob)concat(concat('\"',to_char($(tableAlias).\"$(columnName)\", 'YYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=''GREGORIAN''')),'\"'), '')";
        this.clobColumnTemplate = "nvl2($(tableAlias).\"$(columnName)\", '\"'||replace(replace($(tableAlias).\"$(columnName)\",'\\','\\\\'),'\"','\\\"')||'\"', '')";
        this.blobColumnTemplate = "nvl2($(tableAlias).\"$(columnName)\", '\"'||$(prefixName)_blob2clob($(tableAlias).\"$(columnName)\")||'\"', '')";
        this.longColumnTemplate = "$(oracleToClob)'\"\\b\"'";
        this.booleanColumnTemplate = "nvl2($(tableAlias).\"$(columnName)\", '\"'||cast($(tableAlias).\"$(columnName)\" as number(" + symmetricDialect.getTemplateNumberPrecisionSpec() + "))||'\"', '')";
        this.xmlColumnTemplate = "nvl2(extract($(tableAlias).\"$(columnName)\", '/').getclobval(), '\"'||replace(replace(extract($(tableAlias).\"$(columnName)\", '/').getclobval(),'\\','\\\\'),'\"','\\\"')||'\"', '')";
        this.binaryColumnTemplate = this.blobColumnTemplate;
        this.triggerConcatCharacter = "||";
        this.newTriggerValue = ":new";
        this.oldTriggerValue = ":old";
        this.oldColumnPrefix = "";
        this.newColumnPrefix = "";
        this.sqlTemplates = new HashMap();
        this.sqlTemplates.put("insertTriggerTemplate", "create or replace trigger $(triggerName)\nafter insert on $(schemaName)$(tableName)\nfor each row\nbegin\n    $(custom_before_insert_text)\n    if $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition) then\n        begin\n            insert into $(defaultSchema)$(prefixName)_data\n            (table_name, event_type, trigger_hist_id, row_data, channel_id,\n            transaction_id, source_node_id, external_data, create_time)\n            values(\n            '$(targetTableName)',\n            'I',\n            $(triggerHistoryId),\n            $(oracleToClob)$(columns),\n            $(channelExpression),\n            $(txIdExpression),\n            $(prefixName)_pkg.disable_node_id,\n            $(externalSelect),\n            " + this.getCreateTimeExpression(symmetricDialect) + "\n            );\n        exception\n        when others then\n            insert into $(defaultSchema)$(prefixName)_data\n            (table_name, event_type, trigger_hist_id, row_data, channel_id,\n            transaction_id, source_node_id, external_data, create_time)\n            values(\n            '$(targetTableName)',\n            'I',\n            $(triggerHistoryId),\n            $(oracleToClobAlways)$(columnsClobAlways),\n            $(channelExpression),\n            $(txIdExpression),\n            $(prefixName)_pkg.disable_node_id,\n            $(externalSelect),\n            " + this.getCreateTimeExpression(symmetricDialect) + "\n            );\n        end;\n    end if;\n    $(custom_on_insert_text)\nend;\n");
        this.sqlTemplates.put("insertReloadTriggerTemplate", "create or replace trigger $(triggerName)\nafter insert on $(schemaName)$(tableName)\nfor each row\nbegin\n    $(custom_before_insert_text)\n    if $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition) then\n        insert into $(defaultSchema)$(prefixName)_data\n        (table_name, event_type, trigger_hist_id, pk_data, channel_id,\n        transaction_id, source_node_id, external_data, create_time)\n        values(\n        '$(targetTableName)',\n        'R',\n        $(triggerHistoryId),\n        $(newKeys),\n        $(channelExpression),\n        $(txIdExpression),\n        $(prefixName)_pkg.disable_node_id,\n        $(externalSelect),\n        " + this.getCreateTimeExpression(symmetricDialect) + "\n        );\n    end if;\n    $(custom_on_insert_text)\nend;\n");
        this.sqlTemplates.put("updateTriggerTemplate", "create or replace trigger $(triggerName) after update on $(schemaName)$(tableName)\nfor each row\nbegin\n    $(custom_before_update_text)\n    if $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition) then\n        declare\n            var_row_data $(oracleLobType);\n            var_old_data $(oracleLobType);\n        begin\n            select $(oracleToClob)$(columns) into var_row_data from dual;\n            select $(oracleToClob)$(oldColumns) into var_old_data from dual;\n            if $(dataHasChangedCondition) then\n                insert into $(defaultSchema)$(prefixName)_data\n                (table_name, event_type, trigger_hist_id, pk_data, row_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)\n                values(\n                '$(targetTableName)',\n                'U',\n                $(triggerHistoryId),\n                $(oldKeys),\n                var_row_data,\n                var_old_data,\n                $(channelExpression),\n                $(txIdExpression),\n                $(prefixName)_pkg.disable_node_id,\n                $(externalSelect),\n                " + this.getCreateTimeExpression(symmetricDialect) + "\n                );\n            end if;\n        exception\n        when others then\n            declare\n                var_row_data $(oracleLobTypeClobAlways);\n                var_old_data $(oracleLobTypeClobAlways);\n            begin\n                select $(oracleToClobAlways)$(columnsClobAlways) into var_row_data from dual;\n                select $(oracleToClobAlways)$(oldColumnsClobAlways) into var_old_data from dual;\n                if $(dataHasChangedConditionClobAlways) then\n                    insert into $(defaultSchema)$(prefixName)_data\n                    (table_name, event_type, trigger_hist_id, pk_data, row_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)\n                    values(\n                    '$(targetTableName)',\n                    'U',\n                    $(triggerHistoryId),\n                    $(oldKeys),\n                    var_row_data,\n                    var_old_data,\n                    $(channelExpression),\n                    $(txIdExpression),\n                    $(prefixName)_pkg.disable_node_id,\n                    $(externalSelect),\n                    " + this.getCreateTimeExpression(symmetricDialect) + "\n                    );\n                end if;\n            end;\n        end;\n    end if;\n    $(custom_on_update_text)\nend;\n");
        this.sqlTemplates.put("updateReloadTriggerTemplate", "create or replace trigger $(triggerName) after update on $(schemaName)$(tableName)\nfor each row\nbegin\n    $(custom_before_update_text)\n    if $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition) then\n        insert into $(defaultSchema)$(prefixName)_data\n        (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)\n        values(\n        '$(targetTableName)',\n        'R',\n        $(triggerHistoryId),\n        $(oldKeys),\n        $(channelExpression),\n        $(txIdExpression),\n        $(prefixName)_pkg.disable_node_id,\n        $(externalSelect),\n        " + this.getCreateTimeExpression(symmetricDialect) + "\n        );\n    end if;\n    $(custom_on_update_text)\nend;\n");
        this.sqlTemplates.put("deleteTriggerTemplate", "create or replace trigger  $(triggerName) after delete on $(schemaName)$(tableName)\nfor each row\nbegin\n    $(custom_before_delete_text)\n    if $(syncOnDeleteCondition) and $(syncOnIncomingBatchCondition) then\n        begin\n            insert into $(defaultSchema)$(prefixName)_data\n            (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)\n            values(\n            '$(targetTableName)',\n            'D',\n            $(triggerHistoryId),\n            $(oldKeys),\n            $(oracleToClob)$(oldColumns),\n            $(channelExpression),\n            $(txIdExpression),\n            $(prefixName)_pkg.disable_node_id,\n            $(externalSelect),\n            " + this.getCreateTimeExpression(symmetricDialect) + "\n            );\n        exception\n        when others then\n            insert into $(defaultSchema)$(prefixName)_data\n            (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)\n            values(\n            '$(targetTableName)',\n            'D',\n            $(triggerHistoryId),\n            $(oldKeys),\n            $(oracleToClobAlways)$(oldColumnsClobAlways),\n            $(channelExpression),\n            $(txIdExpression),\n            $(prefixName)_pkg.disable_node_id,\n            $(externalSelect),\n            " + this.getCreateTimeExpression(symmetricDialect) + "\n            );\n        end;\n    end if;\n    $(custom_on_delete_text)\nend;\n");
        this.sqlTemplates.put("initialLoadSqlTemplate", "select $(oracleQueryHint) $(oracleToClob)$(columns) from $(schemaName)$(tableName) t where $(whereClause)");
        this.sqlTemplates.put("filteredDdlTriggerTemplate", "create or replace trigger $(triggerName) after ddl or truncate on schema\ndeclare\ntableName varchar(255);\nhistId number(22);\nchannelId varchar(128);\nn number;\nsqlText ora_name_list_t;\nrowData varchar2(4000);\nbegin\nif (ora_dict_obj_name not like upper('$(prefixName)%')) then\n    n := ora_sql_txt(sqlText);\n    for i in 1..n loop\n        rowData := rowData || sqlText(i);\n    end loop;\n    tableName := '$(prefixName)_node';\n    if (ora_dict_obj_type like '%TABLE%' and upper(rowData) not like '%DROP%TABLE%') then\n        tableName := ora_dict_obj_name;\n    end if;\n    if (ora_dict_obj_type like '%TRIGGER%') then\n        if (upper(rowData) like '%CREATE%TRIGGER%') then\n            select regexp_substr(rowData, '\\son\\s([[:alnum:]_$#\".]+)', 1, 1, 'i', 1) into tableName from dual;\n            select regexp_replace(tableName, '$(defaultSchema)', '', 1, 1, 'i') into tableName from dual;\n            if (upper(tableName) = 'DATABASE' or upper(tableName) = 'SCHEMA' or upper(tableName) = 'NESTED') then\n                tableName := '$(prefixName)_node';\n            end if;\n        else\n            select table_name into tableName from all_triggers where trigger_name = ora_dict_obj_name;\n        end if;\n    end if;\n    if (ora_dict_obj_type like '%INDEX%') then\n        if (upper(rowData) like '%CREATE%INDEX%') then\n            select regexp_substr(rowData, '\\son\\s([[:alnum:]_$#\".]+)', 1, 1, 'i', 1) into tableName from dual;\n            select regexp_replace(tableName, '$(defaultSchema)', '', 1, 1, 'i') into tableName from dual;\n            if (upper(tableName) = 'CLUSTER') then\n                tableName := '$(prefixName)_node';\n            end if;\n        else\n            select table_name into tableName from all_indexes where index_name = ora_dict_obj_name;\n        end if;\n    end if;\n    select regexp_replace(tableName, '$(defaultSchema)', '', 1, 1, 'i') into tableName from dual;\n    begin\n        select trigger_hist_id, source_table_name into histId, tableName from sym_trigger_hist where upper(source_table_name) = upper(tableName) and inactive_time is null;\n    exception when no_data_found then\n        histId := '';\n    end;\n    if (histId is not null) then\n        begin\n            select channel_id into channelId from sym_trigger where upper(source_table_name) = upper(tableName);\n        exception when no_data_found then\n            channelId := 'config';\n        end;\n        select regexp_replace(rowData, '$(defaultSchema)', '', 1, 0, 'i') into rowData from dual;\n        insert into $(defaultSchema)$(prefixName)_data\n        (table_name, event_type, trigger_hist_id, row_data, channel_id, source_node_id, create_time)\n        values (tableName, '" + DataEventType.SQL.getCode() + "', histId,\n        '\"delimiter " + this.delimiter + ";' || chr(13) || chr(10) || replace(replace(rowData,'\\','\\\\'),'\"','\\\"') || '\",ddl',\n        channelId, $(prefixName)_pkg.disable_node_id, " + this.getCreateTimeExpression(symmetricDialect) + ");\n    end if;\nend if;\nend;\n");
        this.sqlTemplates.put("allDdlTriggerTemplate", "create or replace trigger $(triggerName) after ddl or truncate on schema\ndeclare\ntableName varchar(255);\nhistId number(22);\nchannelId varchar(128);\nn number;\nsqlText ora_name_list_t;\nrowData varchar2(4000);\nbegin\nif (ora_dict_obj_name not like upper('$(prefixName)%')) then\n    n := ora_sql_txt(sqlText);\n    for i in 1..n loop\n        rowData := rowData || sqlText(i);\n    end loop;\n    if (ora_dict_obj_name not like 'SYS_C%' and rowData not like 'CREATE UNIQUE INDEX%') then\n        if (ora_dict_obj_type like '%TABLE%' and upper(rowData) not like '%DROP%TABLE%') then\n            tableName := ora_dict_obj_name;\n        end if;\n        if (ora_dict_obj_type like '%TRIGGER%') then\n            if (upper(rowData) like '%CREATE%TRIGGER%') then\n                select regexp_substr(rowData, '\\son\\s([[:alnum:]_$#\".]+)', 1, 1, 'i', 1) into tableName from dual;\n                select regexp_replace(tableName, '$(defaultSchema)', '', 1, 1, 'i') into tableName from dual;\n                if (upper(tableName) = 'DATABASE' or upper(tableName) = 'SCHEMA' or upper(tableName) = 'NESTED') then\n                    tableName := '$(prefixName)_node';\n                end if;\n            else\n                select table_name into tableName from all_triggers where trigger_name = ora_dict_obj_name;\n            end if;\n        end if;\n        if (ora_dict_obj_type like '%INDEX%') then\n            if (upper(rowData) like '%CREATE%INDEX%') then\n                select regexp_substr(rowData, '\\son\\s([[:alnum:]_$#\".]+)', 1, 1, 'i', 1) into tableName from dual;\n                select regexp_replace(tableName, '$(defaultSchema)', '', 1, 1, 'i') into tableName from dual;\n                if (upper(tableName) = 'CLUSTER') then\n                    tableName := '$(prefixName)_node';\n                end if;\n            else\n                select table_name into tableName from all_indexes where index_name = ora_dict_obj_name;\n            end if;\n        end if;\n        if (tableName is not null) then\n            select regexp_replace(tableName, '$(defaultSchema)', '', 1, 1, 'i') into tableName from dual;\n            begin\n                select trigger_hist_id, source_table_name into histId, tableName from sym_trigger_hist where upper(source_table_name) = upper(tableName) and inactive_time is null;\n            exception when no_data_found then\n                histId := '';\n            end;\n        end if;\n        if (histId is null) then\n            tableName := '$(prefixName)_node';\n            select trigger_hist_id into histId from sym_trigger_hist where upper(source_table_name) = upper(tableName) and inactive_time is null;\n        end if;\n        begin\n            select channel_id into channelId from sym_trigger where upper(source_table_name) = upper(tableName);\n        exception when no_data_found then\n            channelId := 'config';\n        end;\n        select regexp_replace(rowData, '$(defaultSchema)', '', 1, 0, 'i') into rowData from dual;\n        insert into $(defaultSchema)$(prefixName)_data\n        (table_name, event_type, trigger_hist_id, row_data, channel_id, source_node_id, create_time)\n        values (tableName, '" + DataEventType.SQL.getCode() + "', histId,\n        '\"delimiter " + this.delimiter + ";' || chr(13) || chr(10) || replace(replace(rowData,'\\','\\\\'),'\"','\\\"') || '\",ddl',\n        channelId, $(prefixName)_pkg.disable_node_id, " + this.getCreateTimeExpression(symmetricDialect) + ");\n    end if;\nend if;\nend;\n");
    }

    protected final String getNumberConversionString() {
        if (this.symmetricDialect.getParameterService().is("oracle.template.precision.text.minimum")) {
            return "to_char($(tableAlias).\"$(columnName)\", 'TM')";
        }
        return "cast($(tableAlias).\"$(columnName)\" as number(" + this.symmetricDialect.getTemplateNumberPrecisionSpec() + "))";
    }

    protected final String getCreateTimeExpression(ISymmetricDialect symmetricDialect) {
        String timezone = symmetricDialect.getParameterService().getString("data.create_time.timezone");
        if (StringUtils.isEmpty((CharSequence)timezone)) {
            return "CURRENT_TIMESTAMP";
        }
        return String.format("CURRENT_TIMESTAMP AT TIME ZONE '%s'", timezone);
    }

    protected String toClobExpression(Table table) {
        if (this.symmetricDialect.getParameterService().is("oracle.use.ntypes.for.sync")) {
            return "to_nclob('')||";
        }
        return "to_clob('')||";
    }
}

