/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.util.ArrayList;
import java.util.List;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.FileSyncPullJob;
import org.jumpmind.symmetric.job.FileSyncPushJob;
import org.jumpmind.symmetric.job.FileSyncTrackerJob;
import org.jumpmind.symmetric.job.HeartbeatJob;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.job.IncomingPurgeJob;
import org.jumpmind.symmetric.job.InitialLoadExtractorJob;
import org.jumpmind.symmetric.job.InitialLoadJob;
import org.jumpmind.symmetric.job.LogMinerJob;
import org.jumpmind.symmetric.job.OfflinePullJob;
import org.jumpmind.symmetric.job.OfflinePushJob;
import org.jumpmind.symmetric.job.OutgoingPurgeJob;
import org.jumpmind.symmetric.job.PullJob;
import org.jumpmind.symmetric.job.PushJob;
import org.jumpmind.symmetric.job.RefreshCacheJob;
import org.jumpmind.symmetric.job.ReportStatusJob;
import org.jumpmind.symmetric.job.RouterJob;
import org.jumpmind.symmetric.job.StageManagementJob;
import org.jumpmind.symmetric.job.StatisticFlushJob;
import org.jumpmind.symmetric.job.SyncTriggersJob;
import org.jumpmind.symmetric.job.WatchdogJob;
import org.jumpmind.symmetric.model.JobDefinition;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class BuiltInJobs {
    public List<JobDefinition> syncBuiltInJobs(List<JobDefinition> existingJobs, ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        List<IJob> builtInJobs = this.getBuiltInJobs(engine, taskScheduler);
        for (IJob job : builtInJobs) {
            existingJobs.add(job.getJobDefinition());
        }
        return existingJobs;
    }

    public List<IJob> getBuiltInJobs(ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        ArrayList<IJob> builtInJobs = new ArrayList<IJob>(20);
        builtInJobs.add(new RouterJob(engine, taskScheduler));
        builtInJobs.add(new PushJob(engine, taskScheduler));
        builtInJobs.add(new PullJob(engine, taskScheduler));
        builtInJobs.add(new OfflinePushJob(engine, taskScheduler));
        builtInJobs.add(new OfflinePullJob(engine, taskScheduler));
        builtInJobs.add(new OutgoingPurgeJob(engine, taskScheduler));
        builtInJobs.add(new IncomingPurgeJob(engine, taskScheduler));
        builtInJobs.add(new StatisticFlushJob(engine, taskScheduler));
        builtInJobs.add(new SyncTriggersJob(engine, taskScheduler));
        builtInJobs.add(new HeartbeatJob(engine, taskScheduler));
        builtInJobs.add(new WatchdogJob(engine, taskScheduler));
        builtInJobs.add(new StageManagementJob(engine, taskScheduler));
        builtInJobs.add(new RefreshCacheJob(engine, taskScheduler));
        builtInJobs.add(new FileSyncTrackerJob(engine, taskScheduler));
        builtInJobs.add(new FileSyncPullJob(engine, taskScheduler));
        builtInJobs.add(new FileSyncPushJob(engine, taskScheduler));
        builtInJobs.add(new InitialLoadExtractorJob(engine, taskScheduler));
        builtInJobs.add(new ReportStatusJob(engine, taskScheduler));
        builtInJobs.add(new LogMinerJob(engine, taskScheduler));
        builtInJobs.add(new InitialLoadJob(engine, taskScheduler));
        List extendedJobs = engine.getExtensionService().getExtensionPointList(IJob.class);
        for (IJob extendedJob : extendedJobs) {
            if (extendedJob instanceof AbstractJob) {
                ((AbstractJob)extendedJob).setTaskScheduler(taskScheduler);
            }
            builtInJobs.add(extendedJob);
        }
        for (IJob builtInJob : builtInJobs) {
            this.setBuiltInDefaults(builtInJob);
        }
        return builtInJobs;
    }

    protected void setBuiltInDefaults(IJob argBuiltInJob) {
        AbstractJob builtInJob = (AbstractJob)argBuiltInJob;
        JobDefinition jobDefinition = new JobDefinition();
        jobDefinition.setJobName(builtInJob.getName());
        jobDefinition.setDescription(builtInJob.getDefaults().getDescription());
        jobDefinition.setRequiresRegistration(builtInJob.getDefaults().isRequiresRegisteration());
        jobDefinition.setJobType(JobDefinition.JobType.BUILT_IN);
        jobDefinition.setJobExpression(argBuiltInJob.getClass().getName());
        jobDefinition.setNodeGroupId("ALL");
        jobDefinition.setCreateBy("SymmetricDS");
        jobDefinition.setDefaultAutomaticStartup(builtInJob.getDefaults().isEnabled());
        builtInJob.setJobDefinition(jobDefinition);
    }
}

