/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.jumpmind.symmetric.model.JobDefinition;
import org.jumpmind.util.SimpleClassCompiler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class JavaJob
extends AbstractJob {
    private JavaJob configuredJob;
    protected ISqlTemplate sqlTemplate;
    public static final String CODE_START = "import org.jumpmind.symmetric.job.JavaJob;\nimport org.apache.commons.lang3.StringUtils;\nimport org.jumpmind.symmetric.ISymmetricEngine;\nimport org.jumpmind.symmetric.model.JobDefinition.JobType;\nimport org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;\n\npublic class CustomJavaJob extends JavaJob {\n\n     public void doJob(boolean force) throws Exception {\n";
    public static final String CODE_END = "\n}\n}";

    public JavaJob() {
    }

    public JavaJob(String jobName, ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super(jobName, engine, taskScheduler);
    }

    public JobDefinition.JobType getJobType() {
        return JobDefinition.JobType.JAVA;
    }

    @Override
    public JobDefaults getDefaults() {
        return new JobDefaults();
    }

    @Override
    public void doJob(boolean force) throws Exception {
        if (this.configuredJob == null) {
            this.configuredJob = this.compileJob();
        }
        if (this.configuredJob != null) {
            this.configuredJob.doJob(force);
        }
    }

    protected JavaJob compileJob() {
        String jobExression = this.getJobDefinition().getJobExpression();
        if (StringUtils.isEmpty((CharSequence)jobExression)) {
            return null;
        }
        String code = CODE_START + jobExression + CODE_END;
        SimpleClassCompiler compiler = new SimpleClassCompiler();
        try {
            JavaJob job = (JavaJob)compiler.getCompiledClass(code);
            job.setEngine(this.engine);
            job.setSqlTemplate(this.engine.getSqlTemplate());
            job.setJobName(this.getJobName());
            job.setJobDefinition(this.getJobDefinition());
            job.setParameterService(this.engine.getParameterService());
            job.setTaskScheduler(this.getTaskScheduler());
            return job;
        }
        catch (Exception ex) {
            throw new SymmetricException("Failed to compile Java code for job " + this.getJobDefinition().getJobName() + " code: \n" + code, (Throwable)ex);
        }
    }

    public ISqlTemplate getSqlTemplate() {
        return this.sqlTemplate;
    }

    public void setSqlTemplate(ISqlTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }
}

