/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.jumpmind.symmetric.service.ILogMinerService;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class LogMinerJob
extends AbstractJob {
    public LogMinerJob(ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super("Log Miner", engine, taskScheduler);
    }

    @Override
    public JobDefaults getDefaults() {
        return new JobDefaults().schedule("10000").description("Read database log for changes");
    }

    @Override
    public void doJob(boolean force) throws Exception {
        ILogMinerService logMinerService;
        if (this.engine != null && (logMinerService = (ILogMinerService)this.engine.getExtensionService().getExtensionPoint(ILogMinerService.class)) != null) {
            logMinerService.mineData(false);
        }
    }
}

