/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.jmx;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeCommunication;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.transport.ConcurrentConnectionManager;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="The management interface for a node")
public class NodeManagementService
implements IBuiltInExtensionPoint,
ISymmetricEngineAware {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine engine;

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @ManagedAttribute(description="Checks if SymmetricDS has been started.")
    public boolean isStarted() {
        if (this.engine != null) {
            return this.engine.isStarted();
        }
        return false;
    }

    @ManagedOperation(description="Start the SymmetricDS engine")
    public boolean start() {
        try {
            if (this.engine != null) {
                this.engine.getParameterService().saveParameter(this.engine.getParameterService().getExternalId(), this.engine.getParameterService().getNodeGroupId(), "auto.start.engine", (Object)"true", "system");
                return this.engine.start();
            }
            return false;
        }
        catch (Exception ex) {
            this.log.error("", (Throwable)ex);
            return false;
        }
    }

    @ManagedOperation(description="Stop the SymmetricDS engine")
    public void stop() {
        try {
            if (this.engine != null) {
                this.log.info("JMX is stopping the following engine: {}", (Object)this.engine.getEngineName());
                this.engine.stop();
                this.engine.getParameterService().saveParameter(this.engine.getParameterService().getExternalId(), this.engine.getParameterService().getNodeGroupId(), "auto.start.engine", (Object)"false", "system");
            }
        }
        catch (Exception ex) {
            this.log.error("", (Throwable)ex);
        }
    }

    @ManagedOperation(description="Run the outgoing purge process")
    public void purge() {
        this.log.info("JMX is running the outgoing purge process from the following engine: {} ", (Object)this.engine.getEngineName());
        this.engine.getPurgeService().purgeOutgoing(true);
    }

    @ManagedOperation(description="Create a snapshot of the current state of the system")
    public String snapshot() {
        File file = this.engine.snapshot(null);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    @ManagedOperation(description="Force the cached objects to be reread from the database the next time they are accessed")
    public void clearCaches() {
        this.engine.clearCaches();
    }

    @ManagedOperation(description="Synchronize the triggers")
    public void syncTriggers() {
        this.log.info("JMX is running syncTriggers from the following engine: {} ", (Object)this.engine.getEngineName());
        this.engine.getTriggerRouterService().syncTriggers();
    }

    @ManagedAttribute(description="Get the number of current connections allowed to this instance of the node via HTTP.  If this value is 20, then 20 concurrent push clients and 20 concurrent pull clients will be allowed")
    public int getConcurrentWorkersMax() {
        return this.engine.getParameterService().getInt("http.concurrent.workers.max");
    }

    @ManagedAttribute(description="Get the number of active connections to this node via HTTP")
    public int getConcurrentWorkersActive() {
        if (this.engine != null) {
            int available = this.engine.getNodeCommunicationService().getAvailableThreads(NodeCommunication.CommunicationType.PUSH);
            return this.engine.getParameterService().getInt("http.concurrent.workers.max") - (available += this.engine.getNodeCommunicationService().getAvailableThreads(NodeCommunication.CommunicationType.PULL));
        }
        return 0;
    }

    @ManagedOperation(description="Get connection statistics about indivdual nodes")
    public String showNodeConcurrencyStatisticsAsText() {
        String lineFeed = "\n";
        if (this.engine.getParameterService().getString("jmx.line.feed").equals("html")) {
            lineFeed = "</br>";
        }
        Map stats = this.engine.getConcurrentConnectionManager().getNodeConnectionStatisticsByPoolByNodeId();
        StringBuilder out = new StringBuilder();
        for (String pool : stats.keySet()) {
            out.append("-------------------------------------------------------------------------------------------------------------------------------");
            out.append(lineFeed);
            out.append("  CONNECTION TYPE: ");
            out.append(pool);
            out.append(lineFeed);
            out.append("-------------------------------------------------------------------------------------------------------------------------------");
            out.append(lineFeed);
            out.append("             NODE ID             LAST CONNECT TIME      NUMBER OF CONNECTIONS     NUMBER OF REJECTIONS       AVG CONNECTED TIME");
            out.append(lineFeed);
            out.append("-------------------------------------------------------------------------------------------------------------------------------");
            out.append(lineFeed);
            Map nodeStats = (Map)stats.get(pool);
            for (String nodeId : nodeStats.keySet()) {
                ConcurrentConnectionManager.NodeConnectionStatistics nodeStat = (ConcurrentConnectionManager.NodeConnectionStatistics)nodeStats.get(nodeId);
                out.append(StringUtils.leftPad((String)nodeId, (int)20));
                out.append(StringUtils.leftPad((String)DateFormat.getDateTimeInstance(2, 2).format(new Date(nodeStat.getLastConnectionTimeMs())), (int)30));
                out.append(StringUtils.leftPad((String)Long.toString(nodeStat.getTotalConnectionCount()), (int)27));
                out.append(StringUtils.leftPad((String)Integer.toString(nodeStat.getNumOfRejections()), (int)25));
                out.append(StringUtils.leftPad((String)NumberFormat.getIntegerInstance().format(nodeStat.getTotalConnectionTimeMs() / nodeStat.getTotalConnectionCount()), (int)25));
            }
            out.append(lineFeed);
        }
        return out.toString();
    }

    @ManagedOperation(description="Clean up both incoming and outgoing resources that are older than the passed in number of milliseconds")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="timeToLiveInMS", description="The number of milliseconds old a resource should be before it is cleaned up")})
    public long cleanStaging(long timeToLiveInMS) {
        return this.engine.getStagingManager().clean(timeToLiveInMS);
    }

    @ManagedAttribute(description="Get a list of nodes that have been added to the white list, a list of node ids that always get through the concurrency manager.")
    public String getNodesInWhiteList() {
        String[] list;
        StringBuilder ret = new StringBuilder();
        for (String string : list = this.engine.getConcurrentConnectionManager().getWhiteList()) {
            ret.append(string);
            ret.append(",");
        }
        return ret.length() > 0 ? ret.substring(0, ret.length() - 1) : "";
    }

    @ManagedOperation(description="Add a node id to the list of nodes that will always get through the concurrency manager")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to add to the white list")})
    public void addNodeToWhiteList(String nodeId) {
        this.log.info("JMX is adding node: {} to the white list from the following engine: {} ", (Object)nodeId, (Object)this.engine.getEngineName());
        this.engine.getConcurrentConnectionManager().addToWhitelist(nodeId);
    }

    @ManagedOperation(description="Remove a node id to the list of nodes that will always get through the concurrency manager")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to remove from the white list")})
    public void removeNodeFromWhiteList(String nodeId) {
        this.log.info("JMX is removing node: {} from the white list from the following engine: {} ", (Object)nodeId, (Object)this.engine.getEngineName());
        this.engine.getConcurrentConnectionManager().removeFromWhiteList(nodeId);
    }

    @ManagedAttribute(description="Configure the number of connections allowed to this node.  If the value is set to zero you are effectively disabling your transport (wihch can be useful for maintainance")
    public void setConcurrentWorkersMax(int value) {
        this.log.info("JMX is setting the http.concurrent.workers.max to {} parameter from the following engine: {} ", (Object)value, (Object)this.engine.getEngineName());
        this.engine.getParameterService().saveParameter("http.concurrent.workers.max", (Object)value, "jmx");
    }

    @ManagedAttribute(description="The group this node belongs to")
    public String getNodeGroupId() {
        return this.engine.getParameterService().getNodeGroupId();
    }

    @ManagedAttribute(description="An external name given to this SymmetricDS node")
    public String getExternalId() {
        return this.engine.getParameterService().getExternalId();
    }

    @ManagedAttribute(description="The node id given to this SymmetricDS node")
    public String getNodeId() {
        Node node = this.engine.getNodeService().findIdentity();
        if (node != null) {
            return node.getNodeId();
        }
        return "?";
    }

    @ManagedAttribute(description="Whether the basic DataSource is being used as the default datasource.")
    public boolean isBasicDataSource() {
        DataSource dataSource = (DataSource)this.engine.getDataSource();
        return dataSource instanceof BasicDataSource;
    }

    @ManagedAttribute(description="If a BasicDataSource, then show the number of active connections")
    public int getDatabaseConnectionsActive() {
        if (this.isBasicDataSource()) {
            DataSource dataSource = (DataSource)this.engine.getDataSource();
            return ((BasicDataSource)dataSource).getNumActive();
        }
        return -1;
    }

    @ManagedAttribute(description="If a BasicDataSource, then show the max number of total connections")
    public int getDatabaseConnectionsMax() {
        if (this.isBasicDataSource()) {
            DataSource dataSource = (DataSource)this.engine.getDataSource();
            return ((BasicDataSource)dataSource).getMaxTotal();
        }
        return -1;
    }

    @ManagedOperation(description="Check to see if the external id is registered")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeGroupId", description="The node group id for a node"), @ManagedOperationParameter(name="externalId", description="The external id for a node")})
    public boolean isExternalIdRegistered(String nodeGroupdId, String externalId) {
        return this.engine.getNodeService().isExternalIdRegistered(nodeGroupdId, externalId);
    }

    @ManagedOperation(description="Emergency remove all locks (if left abandoned on a cluster)")
    public void clearAllLocks() {
        this.engine.getClusterService().clearAllLocks();
    }

    @ManagedOperation(description="Check to see if the initial load for a node id is complete.  This method will throw an exception if the load error'd out or was never started.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id")})
    public boolean areAllLoadBatchesComplete(String nodeId) {
        return this.engine.getOutgoingBatchService().areAllLoadBatchesComplete(nodeId);
    }

    @ManagedOperation(description="Enable or disable synchronization completely for a node")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node to enable or disable"), @ManagedOperationParameter(name="syncEnabled", description="true is enabled, false is disabled")})
    public boolean setSyncEnabledForNode(String nodeId, boolean syncEnabled) {
        Node node = this.engine.getNodeService().findNode(nodeId);
        if (node != null) {
            this.log.info("JMX is setting the SyncEnabled flag to {} from the following engine: {} ", (Object)syncEnabled, (Object)this.engine.getEngineName());
            node.setSyncEnabled(syncEnabled);
            this.engine.getNodeService().save(node);
            return true;
        }
        return false;
    }

    @ManagedOperation(description="Extract multiple batches to a file for a time range")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="fileName", description="The file to write the batch output to"), @ManagedOperationParameter(name="nodeId", description="The target node id whose batches need extracted"), @ManagedOperationParameter(name="startTime", description="The start time range to extract.  The format is yyyy-MM-dd hh:mm"), @ManagedOperationParameter(name="endTime", description="The start time range to extract.  The format is yyyy-MM-dd hh:mm"), @ManagedOperationParameter(name="channelIdList", description="A comma separated list of channels to extract")})
    public boolean extractBatcheRange(String fileName, String nodeId, String startTime, String endTime, String channelIdList) {
        boolean bl;
        File file = new File(fileName);
        file.getParentFile().mkdirs();
        Date startBatchTime = FormatUtils.parseDate((String)startTime, (String[])FormatUtils.TIMESTAMP_PATTERNS);
        Date endBatchTime = FormatUtils.parseDate((String)endTime, (String[])FormatUtils.TIMESTAMP_PATTERNS);
        String[] channelIds = channelIdList.split(",");
        IDataExtractorService dataExtractorService = this.engine.getDataExtractorService();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            dataExtractorService.extractBatchRange((Writer)writer, nodeId, startBatchTime, endBatchTime, channelIds);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                this.log.error("Failed to write batch range to file", (Throwable)ex);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    @ManagedOperation(description="Enable or disable a channel for a specific external id")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="ignore", description="Set to true to enable and false to disable"), @ManagedOperationParameter(name="channelId", description="The channel id to enable or disable"), @ManagedOperationParameter(name="nodeGroupId", description="The node group id for a node"), @ManagedOperationParameter(name="externalId", description="The external id for a node")})
    public void ignoreNodeChannelForExternalId(boolean ignore, String channelId, String nodeGroupId, String externalId) {
        if (ignore) {
            this.log.info("JMX is disabling the {} channel for the externalId of {} from the following engine: {} ", new Object[]{channelId, externalId, this.engine.getEngineName()});
        } else {
            this.log.info("JMX is enabling the {} channel for the externalId of {} from the following engine: {} ", new Object[]{channelId, externalId, this.engine.getEngineName()});
        }
        this.engine.getNodeService().ignoreNodeChannelForExternalId(ignore, channelId, nodeGroupId, externalId);
    }

    @ManagedOperation(description="Open the registration for a node with the specified external id")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeGroup", description="The node group id this node will belong to"), @ManagedOperationParameter(name="externalId", description="The external id for the node")})
    public void openRegistration(String nodeGroupId, String externalId) {
        this.engine.getRegistrationService().openRegistration(nodeGroupId, externalId);
    }

    @ManagedOperation(description="Re-open the registration for a node with the specified external id")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to reopen registration for")})
    public void reopenRegistration(String nodeId) {
        this.engine.getRegistrationService().reOpenRegistration(nodeId);
    }

    @ManagedOperation(description="Send an initial load of data to a node.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to reload.")})
    public String reloadNode(String nodeId) {
        return this.engine.getDataService().reloadNode(nodeId, false, "jmx");
    }

    @ManagedOperation(description="Send a SQL event to a node.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to sent the event to."), @ManagedOperationParameter(name="catalogName", description="The catalog name to reload. Can be null."), @ManagedOperationParameter(name="schemaName", description="The schema name to reload. Can be null."), @ManagedOperationParameter(name="tableName", description="The table name the SQL is for."), @ManagedOperationParameter(name="sql", description="The SQL statement to send.")})
    public String sendSQL(String nodeId, String catalogName, String schemaName, String tableName, String sql) {
        return this.engine.getDataService().sendSQL(nodeId, catalogName, schemaName, tableName, sql);
    }

    @ManagedOperation(description="Send a delete and reload of a table to a node.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to reload."), @ManagedOperationParameter(name="catalogName", description="The catalog name to reload. Can be null."), @ManagedOperationParameter(name="schemaName", description="The schema name to reload. Can be null."), @ManagedOperationParameter(name="tableName", description="The table name to reload.")})
    public String reloadTable(String nodeId, String catalogName, String schemaName, String tableName) {
        return this.engine.getDataService().reloadTable(nodeId, catalogName, schemaName, tableName);
    }

    @ManagedOperation(description="Send a delete and reload of a table to a node.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to reload."), @ManagedOperationParameter(name="catalogName", description="The catalog name to reload. Can be null."), @ManagedOperationParameter(name="schemaName", description="The schema name to reload. Can be null."), @ManagedOperationParameter(name="tableName", description="The table name to reload."), @ManagedOperationParameter(name="overrideInitialLoadSelect", description="Override initial load select where-clause.")})
    public String reloadTable(String nodeId, String catalogName, String schemaName, String tableName, String overrideInitialLoadSelect) {
        return this.engine.getDataService().reloadTable(nodeId, catalogName, schemaName, tableName, overrideInitialLoadSelect);
    }

    @ManagedOperation(description="Write a range of batches to a file in SymmetricDS Data Format.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id for the batches which will be written"), @ManagedOperationParameter(name="startBatchId", description="Starting batch ID of range"), @ManagedOperationParameter(name="endBatchId", description="Ending batch ID of range"), @ManagedOperationParameter(name="fileName", description="File name to write batches")})
    public void writeBatchRangeToFile(String nodeId, String startBatchId, String endBatchId, String fileName) throws Exception {
        FileWriter writer = new FileWriter(new File(fileName));
        this.engine.getDataExtractorService().extractBatchRange((Writer)writer, nodeId, Long.valueOf(startBatchId).longValue(), Long.valueOf(endBatchId).longValue());
        try {
            ((Writer)writer).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @ManagedOperation(description="Encrypts plain text for use with db.user and db.password properties")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="plainText", description="Plain text to encrypt")})
    public String encryptText(String plainText) throws Exception {
        try {
            return "enc:" + this.engine.getSecurityService().encrypt(plainText);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @ManagedAttribute(description="Number of batches in error")
    public int getBatchesInError() {
        if (this.engine != null) {
            return this.engine.getOutgoingBatchService().countOutgoingBatchesInError();
        }
        return 0;
    }

    @ManagedAttribute(description="Number of batches unsent")
    public int getBatchesUnsent() {
        if (this.engine != null) {
            return this.engine.getOutgoingBatchService().countOutgoingBatchesUnsent();
        }
        return 0;
    }

    @ManagedAttribute(description="Number of data unrouted")
    public long getDataUnrouted() {
        if (this.engine != null) {
            return this.engine.getRouterService().getUnroutedDataCount();
        }
        return 0L;
    }

    @ManagedAttribute(description="Last restart time")
    public Date getStartedTime() {
        if (this.engine != null) {
            return this.engine.getLastRestartTime();
        }
        return null;
    }

    @ManagedAttribute(description="Version")
    public String getVersion() {
        return Version.version();
    }
}

