/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import jakarta.servlet.ServletContext;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.SymmetricWebServer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={Server.class})
public class JettyCustomizer
implements WebServerFactoryCustomizer<JettyServletWebServerFactory>,
JettyServerCustomizer {
    protected WebAppContext webapp;

    public void customize(JettyServletWebServerFactory factory) {
        factory.addServerCustomizers(new JettyServerCustomizer[]{this});
    }

    public void customize(Server server) {
        TypedProperties sysProps = new TypedProperties(System.getProperties());
        boolean httpEnabled = sysProps.is("http.enable", true);
        boolean httpsEnabled = sysProps.is("https.enable", false);
        String ignoredProtocols = System.getProperty("symmetric.ssl.ignore.protocols", "SSLv3");
        String ignoredCiphers = System.getProperty("symmetric.ssl.ignore.ciphers");
        if (httpsEnabled) {
            for (Connector connector : server.getConnectors()) {
                HttpConfiguration httpsConfig;
                ServerConnector serverConnector;
                HttpConnectionFactory connectionFactory2;
                if (connector instanceof ServerConnector && (connectionFactory2 = (HttpConnectionFactory)(serverConnector = (ServerConnector)connector).getConnectionFactory(HttpConnectionFactory.class)) != null && (httpsConfig = connectionFactory2.getHttpConfiguration()) != null) {
                    httpsConfig.setSendServerVersion(false);
                    SecureRequestCustomizer customizer = (SecureRequestCustomizer)httpsConfig.getCustomizer(SecureRequestCustomizer.class);
                    if (customizer != null && Boolean.parseBoolean(System.getProperty("https.allow.self.signed.certs", Boolean.toString(true)))) {
                        customizer.setSniHostCheck(false);
                    }
                }
                if (!(connector instanceof AbstractConnector)) continue;
                for (HttpConnectionFactory connectionFactory2 : ((AbstractConnector)connector).getConnectionFactories()) {
                    if (!(connectionFactory2 instanceof SslConnectionFactory)) continue;
                    SslContextFactory.Server sslContextFactory = ((SslConnectionFactory)connectionFactory2).getSslContextFactory();
                    if (ignoredProtocols != null && ignoredProtocols.length() > 0) {
                        String[] protocols = ignoredProtocols.split(",");
                        sslContextFactory.addExcludeProtocols(protocols);
                    }
                    if (ignoredCiphers == null || ignoredCiphers.length() <= 0) continue;
                    String[] ciphers = ignoredCiphers.split(",");
                    sslContextFactory.addExcludeCipherSuites(ciphers);
                }
            }
        }
        if (httpEnabled && httpsEnabled) {
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSendServerVersion(false);
            ServerConnector connector = new ServerConnector(server);
            connector.addConnectionFactory((ConnectionFactory)new HttpConnectionFactory(httpConfig));
            connector.setPort(sysProps.getInt("http.port", Integer.parseInt(SymmetricWebServer.DEFAULT_HTTP_PORT)));
            server.addConnector((Connector)connector);
        }
        for (Handler handler : server.getHandlers()) {
            WebAppContext webapp;
            if (!(handler instanceof WebAppContext)) continue;
            this.webapp = webapp = (WebAppContext)handler;
            webapp.setParentLoaderPriority(true);
        }
        if (sysProps.is("https.allow.self.signed.certs")) {
            System.setProperty("org.eclipse.jetty.websocket.jsr356.ssl-trust-all", Boolean.toString(true));
        }
    }

    public ServletContext getServletContext() {
        return this.webapp != null ? this.webapp.getServletContext() : null;
    }
}

