/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.integrate;

import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.load.IReloadListener;
import org.jumpmind.symmetric.model.Node;

public class RunSqlReloadListener
implements IReloadListener,
ISymmetricEngineAware {
    private ISymmetricEngine engine;
    private String sqlToRunAtTargetBeforeReload;
    private String sqlToRunAtTargetAfterReload;

    public void afterReload(ISqlTransaction transaction, Node node, long loadId) {
        if (StringUtils.isNotBlank((CharSequence)this.sqlToRunAtTargetAfterReload)) {
            this.engine.getDataService().insertSqlEvent(transaction, node, this.sqlToRunAtTargetAfterReload, true, loadId, null);
        }
    }

    public void beforeReload(ISqlTransaction transaction, Node node, long loadId) {
        if (StringUtils.isNotBlank((CharSequence)this.sqlToRunAtTargetBeforeReload)) {
            this.engine.getDataService().insertSqlEvent(transaction, node, this.sqlToRunAtTargetBeforeReload, true, loadId, null);
        }
    }

    public void setSqlToRunAtTargetAfterReload(String sqlToRunAfterReload) {
        this.sqlToRunAtTargetAfterReload = sqlToRunAfterReload;
    }

    public void setSqlToRunAtTargetBeforeReload(String sqlToRunBeforeReload) {
        this.sqlToRunAtTargetBeforeReload = sqlToRunBeforeReload;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }
}

