/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.integrate;

import java.text.ParseException;
import java.util.Map;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.integrate.AbstractTextPublisherDataLoaderFilter;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;

public class TemplatedPublisherDataLoaderFilter
extends AbstractTextPublisherDataLoaderFilter {
    private String headerTableTemplate;
    private String footerTableTemplate;
    private String contentTableTemplate;
    private Map<String, IFormat> columnNameToDataFormatter;
    private boolean processDelete = true;
    private boolean processInsert = true;
    private boolean processUpdate = true;
    private IDatabaseWriterFilter dataFilter;

    @Override
    protected String addTextElement(DataContext context, Table table, CsvData data) {
        if (this.dataFilter == null || this.dataFilter.beforeWrite(context, table, data)) {
            DataEventType eventType = data.getDataEventType();
            String template = null;
            if ((this.processInsert && eventType == DataEventType.INSERT || this.processUpdate && eventType == DataEventType.UPDATE || this.processDelete && eventType == DataEventType.DELETE) && (template = this.contentTableTemplate) != null) {
                template = this.fillOutTemplate(table, data, template, context);
            }
            return template;
        }
        return null;
    }

    @Override
    protected String addTextFooter(DataContext context) {
        return this.footerTableTemplate;
    }

    @Override
    protected String addTextHeader(DataContext context) {
        return this.headerTableTemplate;
    }

    protected String fillOutTemplate(Table table, CsvData data, String template, DataContext context) {
        DataEventType eventType = data.getDataEventType();
        String[] colNames = null;
        String[] colValues = null;
        if (eventType == DataEventType.DELETE) {
            colNames = table.getPrimaryKeyColumnNames();
            colValues = data.getParsedData("pkData");
        } else {
            colNames = table.getColumnNames();
            colValues = data.getParsedData("rowData");
        }
        for (int i = 0; i < colValues.length; ++i) {
            String col = colNames[i];
            template = this.replace(template, col, this.format(col, colValues[i]));
        }
        template = template.replace("DMLTYPE", eventType.name());
        template = template.replace("TIMESTAMP", Long.toString(System.currentTimeMillis()));
        return template;
    }

    protected String format(String col, String data) {
        IFormat formatter;
        if (this.columnNameToDataFormatter != null && (formatter = this.columnNameToDataFormatter.get(col)) != null) {
            try {
                data = formatter.format(data);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return data;
    }

    protected String replace(String template, String token, String value) {
        if (value == null) {
            value = "";
        }
        if (template != null) {
            template = template.replace("%" + token + "%", value);
        }
        return template;
    }

    public void setColumnNameToDataFormatter(Map<String, IFormat> columnNameToDataFormatter) {
        this.columnNameToDataFormatter = columnNameToDataFormatter;
    }

    public void setProcessDelete(boolean processDeletes) {
        this.processDelete = processDeletes;
    }

    public void setProcessInsert(boolean processInserts) {
        this.processInsert = processInserts;
    }

    public void setProcessUpdate(boolean processUpdates) {
        this.processUpdate = processUpdates;
    }

    public void setHeaderTableTemplate(String headerTableTemplate) {
        this.headerTableTemplate = headerTableTemplate;
    }

    public void setFooterTableTemplate(String footerTableTemplate) {
        this.footerTableTemplate = footerTableTemplate;
    }

    public void setContentTableTemplate(String contentTableTemplate) {
        this.contentTableTemplate = contentTableTemplate;
    }

    public void setDataFilter(IDatabaseWriterFilter dataFilter) {
        this.dataFilter = dataFilter;
    }

    public static interface IFormat {
        public String format(String var1) throws ParseException;
    }
}

