/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;

public class FileSyncPushUriHandler
extends AbstractUriHandler {
    private ISymmetricEngine engine;

    public FileSyncPushUriHandler(ISymmetricEngine engine, IInterceptor ... interceptors) {
        super("/filesync/push/*", engine.getParameterService(), interceptors);
        this.engine = engine;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException, FileUploadException {
        String nodeId = ServletUtils.getParameter(req, "nodeId");
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            ServletUtils.sendError(res, 603, "Node must be specified");
            return;
        }
        if (!JakartaServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            ServletUtils.sendError(res, 603, "We only handle multipart requests");
            return;
        }
        this.log.debug("File sync push request received from {}", (Object)nodeId);
        JakartaServletFileUpload upload = new JakartaServletFileUpload();
        FileItemInputIterator iter = upload.getItemIterator(req);
        while (iter.hasNext()) {
            FileItemInput item = iter.next();
            String name = item.getFieldName();
            if (item.isFormField()) continue;
            this.log.debug("Processing upload file field " + name + " with file name " + item.getName() + " detected.");
            this.engine.getFileSyncService().loadFilesFromPush(nodeId, item.getInputStream(), (OutputStream)res.getOutputStream());
        }
        res.flushBuffer();
    }
}

