/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.web.SymmetricEngineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SymmetricContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(SymmetricContextListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        URL serverPropertiesURL;
        Class<?> remoteStatusEndpoint = this.loadRemoteStatusEndpoint();
        if (remoteStatusEndpoint != null) {
            // empty if block
        }
        SymmetricEngineHolder engineHolder = new SymmetricEngineHolder();
        ServletContext ctx = sce.getServletContext();
        String autoStart = ctx.getInitParameter("autoStart");
        engineHolder.setAutoStart(autoStart == null ? true : autoStart.equalsIgnoreCase("true"));
        String autoCreate = ctx.getInitParameter("autoCreate");
        engineHolder.setAutoCreate(autoCreate == null ? true : autoCreate.equalsIgnoreCase("true"));
        String multiServerMode = ctx.getInitParameter("multiServerMode");
        engineHolder.setMultiServerMode(multiServerMode != null && multiServerMode.equalsIgnoreCase("true") || StringUtils.isNotBlank((CharSequence)System.getProperty("symmetric.engines.dir")));
        engineHolder.setSingleServerPropertiesFile(ctx.getInitParameter("singleServerPropertiesFile"));
        String staticEnginesMode = ctx.getInitParameter("staticEnginesMode");
        engineHolder.setStaticEnginesMode(staticEnginesMode != null && staticEnginesMode.equalsIgnoreCase("true"));
        engineHolder.setDeploymentType(ctx.getInitParameter("deploymentType"));
        ctx.setAttribute("symmetricEngineHolder", (Object)engineHolder);
        String useWebApplicationContext = ctx.getInitParameter("useWebApplicationContext");
        if ("true".equals(useWebApplicationContext)) {
            engineHolder.setSpringContext((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext()));
        }
        if (!"true".equals(System.getProperty("symmetric.launcher")) && (serverPropertiesURL = this.getClass().getClassLoader().getResource("/symmetric-server.properties")) != null) {
            try (InputStream fis = serverPropertiesURL.openStream();){
                TypedProperties serverProperties = new TypedProperties();
                serverProperties.load(fis);
                serverProperties.merge(System.getProperties());
                System.getProperties().putAll((Map<?, ?>)serverProperties);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        engineHolder.start();
    }

    protected Class<?> loadRemoteStatusEndpoint() {
        try {
            Class clazz = ClassUtils.getClass((String)"com.jumpmind.symmetric.console.remote.ServerEndpoint");
            return clazz;
        }
        catch (ClassNotFoundException clazz) {
        }
        catch (Exception ex) {
            log.debug("Failed to load remote status endpoint.", (Throwable)ex);
        }
        return null;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        SymmetricEngineHolder engineHolder = (SymmetricEngineHolder)ctx.getAttribute("symmetricEngineHolder");
        if (engineHolder != null) {
            engineHolder.stop();
            ctx.removeAttribute("symmetricEngineHolder");
        }
    }
}

