/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.exception.IoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(TypedProperties.class);

    public TypedProperties(InputStream is) {
        try {
            this.load(is);
        }
        catch (IOException ex) {
            throw new IoException(ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public TypedProperties() {
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (value != null) {
            return super.put(key, value);
        }
        return null;
    }

    public TypedProperties(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.load(fis);
        }
        catch (IOException ex) {
            throw new IoException(ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public TypedProperties(Properties properties) {
        this();
        this.putAll(properties);
    }

    public final void putAll(Properties properties) {
        for (Object key : properties.keySet()) {
            this.put((String)key, properties.getProperty((String)key));
        }
    }

    public long getLong(String key) {
        return this.getLong(key, -1L);
    }

    public long getLong(String key, long defaultValue) {
        long returnValue = defaultValue;
        String value = this.getProperty(key);
        if (value != null) {
            try {
                returnValue = Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                TypedProperties.logPropertiesException(log, key, value);
            }
        }
        return returnValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        int returnValue = defaultValue;
        String value = this.getProperty(key);
        if (value != null) {
            try {
                returnValue = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                TypedProperties.logPropertiesException(log, key, value);
            }
        }
        return returnValue;
    }

    public boolean is(String key) {
        return this.is(key, false);
    }

    public boolean is(String key, boolean defaultValue) {
        boolean returnValue = defaultValue;
        String value = this.getProperty(key);
        if (value != null) {
            returnValue = Boolean.parseBoolean(value);
        }
        return returnValue;
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        String returnValue = defaultValue;
        String value = this.getProperty(key);
        if (value != null) {
            returnValue = value;
        }
        return returnValue;
    }

    public void setProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public void setProperty(String key, long value) {
        this.setProperty(key, Long.toString(value));
    }

    public String[] getArray(String key, String[] defaultValue) {
        String value = this.getProperty(key);
        String[] retValue = defaultValue;
        if (value != null) {
            retValue = value.split(",");
        }
        return retValue;
    }

    public void merge(Properties properties) {
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            if (!this.containsKey(key)) continue;
            this.setProperty((String)key, properties.getProperty((String)key));
        }
    }

    public TypedProperties copy() {
        return new TypedProperties(this);
    }

    public static void logPropertiesException(Logger logger, String key, String val) {
        if (StringUtils.isNotBlank((CharSequence)val)) {
            logger.error("Could not parse integer from parameter \"" + key + "\"=\"" + val + "\"");
        }
    }
}

