/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.security;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.jumpmind.security.BouncyCastleHelper;
import org.jumpmind.security.KeystoreAliasException;
import org.jumpmind.security.SecurityService;
import org.jumpmind.util.AppUtils;

public class BouncyCastleSecurityService
extends SecurityService {
    protected KeyPair generateRSAKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        kpGen.initialize(2048, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    @Override
    public boolean supportsExportCertificate() {
        return true;
    }

    @Override
    public boolean supportsImportCertificate() {
        return true;
    }

    @Override
    public boolean supportsBackupCertificate() {
        return true;
    }

    @Override
    public boolean supportsGenerateSelfSignedCertificate() {
        return true;
    }

    protected X509Certificate generateV1Certificate(String host, KeyPair pair, int lifetimeInDays) throws Exception {
        host = host == null || host.equals("0.0.0.0") ? AppUtils.getHostName() : host;
        String certString = String.format("CN=%s, OU=SymmetricDS, O=JumpMind", host);
        SubjectPublicKeyInfo publicKeyInfo = new BouncyCastleHelper().getInstance(pair.getPublic());
        if (lifetimeInDays < 1) {
            this.log.warn("Invalid lifetime for certificate: {} days. Setting lifetime to 25 years.", (Object)lifetimeInDays);
            lifetimeInDays = 9125;
        }
        X509v1CertificateBuilder builder = new X509v1CertificateBuilder(new X500Name(certString), BigInteger.valueOf(System.currentTimeMillis()), new Date(System.currentTimeMillis() - 86400000L), new Date(System.currentTimeMillis() + (long)lifetimeInDays * 86400000L), new X500Name(certString), publicKeyInfo);
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256WithRSAEncryption");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        ContentSigner signer = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(new BouncyCastleHelper().createKey(pair.getPrivate()));
        X509CertificateHolder holder = builder.build(signer);
        return new JcaX509CertificateConverter().getCertificate(holder);
    }

    @Override
    public synchronized void installDefaultSslCert(String host) {
        String alias = System.getProperty("sym.keystore.ssl.cert.alias", "sym");
        this.installDefaultSslCert(host, alias, 9125);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void installDefaultSamlSslCert(String host, int lifetimeInDays) {
        Class<BouncyCastleSecurityService> clazz = BouncyCastleSecurityService.class;
        synchronized (BouncyCastleSecurityService.class) {
            this.installDefaultSslCert(host, "saml", lifetimeInDays);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void installDefaultSslCert(String host, String alias, int lifetimeInDays) {
        try {
            KeyStore keyStore = this.getKeyStore();
            KeyStore.PasswordProtection param = new KeyStore.PasswordProtection(this.getKeyStorePassword().toCharArray());
            KeyStore.Entry entry = keyStore.getEntry(alias, param);
            if (entry == null) {
                new BouncyCastleHelper().checkProviderInstalled();
                KeyStore.PrivateKeyEntry privateEntry = this.createDefaultSslCert(host, lifetimeInDays);
                if (alias.equals("saml")) {
                    this.log.info("Installing a default SSL certificate for SAML: {}", (Object)((X509Certificate)privateEntry.getCertificate()).getSubjectX500Principal().getName());
                } else {
                    this.log.info("Installing a default SSL certificate: {}", (Object)((X509Certificate)privateEntry.getCertificate()).getSubjectX500Principal().getName());
                }
                keyStore.setEntry(alias, privateEntry, param);
                this.saveKeyStore(keyStore, this.getKeyStorePassword());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public KeyStore.PrivateKeyEntry createDefaultSslCert(String host) {
        return this.createDefaultSslCert(host, 9125);
    }

    private KeyStore.PrivateKeyEntry createDefaultSslCert(String host, int lifetimeInDays) {
        KeyStore.PrivateKeyEntry entry = null;
        new BouncyCastleHelper().checkProviderInstalled();
        try {
            KeyPair pair = this.generateRSAKeyPair();
            X509Certificate cert = this.generateV1Certificate(host, pair, lifetimeInDays);
            Certificate[] serverChain = new X509Certificate[]{cert};
            entry = new KeyStore.PrivateKeyEntry(pair.getPrivate(), serverChain);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return entry;
    }

    @Override
    public synchronized void installSslCert(KeyStore.PrivateKeyEntry entry) {
        String alias = System.getProperty("sym.keystore.ssl.cert.alias", "sym");
        this.installSslCert(entry, alias);
    }

    @Override
    public void installSslCert(KeyStore.PrivateKeyEntry entry, String alias) {
        try {
            new BouncyCastleHelper().checkProviderInstalled();
            KeyStore keyStore = this.getKeyStore();
            KeyStore.PasswordProtection param = new KeyStore.PasswordProtection(this.getKeyStorePassword().toCharArray());
            keyStore.setEntry(alias, entry, param);
            this.log.info("Installing SSL certificate: {}", (Object)((X509Certificate)entry.getCertificate()).getSubjectX500Principal().getName());
            this.saveKeyStore(keyStore, this.getKeyStorePassword());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized KeyStore.PrivateKeyEntry createSslCert(byte[] content, String fileType, String alias, String password) {
        return (KeyStore.PrivateKeyEntry)this.createSslCert(content, fileType, alias, password, true);
    }

    @Override
    public synchronized KeyStore.TrustedCertificateEntry createTrustedCert(byte[] content, String fileType, String alias, String password) {
        return (KeyStore.TrustedCertificateEntry)this.createSslCert(content, fileType, alias, password, false);
    }

    protected KeyStore.Entry createSslCert(byte[] content, String fileType, String alias, String password, boolean isKeyEntry) {
        KeyStore.Entry entry = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(content);
            PrivateKey key = null;
            Certificate[] chain = null;
            if (fileType.equalsIgnoreCase("pfx") || fileType.equalsIgnoreCase("p12")) {
                KeyStore store = KeyStore.getInstance("PKCS12");
                char[] passchar = password != null ? password.toCharArray() : null;
                store.load(is, passchar);
                ArrayList<String> aliases = Collections.list(store.aliases());
                if (alias == null && aliases.size() == 1) {
                    alias = (String)aliases.get(0);
                } else {
                    if (alias != null && !store.containsAlias(alias)) {
                        throw new KeystoreAliasException("Entry for alias " + alias + " does not exist", aliases);
                    }
                    if (alias == null) {
                        throw new KeystoreAliasException("Alias must be specified when keystore contains multiple entries", aliases);
                    }
                }
                if (isKeyEntry) {
                    chain = store.getCertificateChain(alias);
                    if (chain == null) {
                        throw new UnrecoverableKeyException();
                    }
                    key = (PrivateKey)store.getKey(alias, passchar);
                } else {
                    chain = new Certificate[]{store.getCertificate(alias)};
                }
            } else if (fileType.equalsIgnoreCase("pem") || fileType.equalsIgnoreCase("crt") || fileType.equalsIgnoreCase("cer")) {
                ArrayList<Certificate> certs = new ArrayList<Certificate>();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("BEGIN CERTIFICATE")) {
                        CertificateFactory factory = CertificateFactory.getInstance("X.509");
                        certs.add(factory.generateCertificate(new ByteArrayInputStream(this.readPemBytes(reader))));
                        continue;
                    }
                    if (line.contains("BEGIN PRIVATE KEY")) {
                        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(this.readPemBytes(reader));
                        key = KeyFactory.getInstance("RSA").generatePrivate(spec);
                        continue;
                    }
                    if (line.contains("BEGIN RSA PRIVATE KEY")) {
                        RSAPrivateKey rsaPrivKey = RSAPrivateKey.getInstance((Object)ASN1Primitive.fromByteArray((byte[])this.readPemBytes(reader)));
                        RSAPrivateKeySpec rsaPrivKeySpec = new RSAPrivateKeySpec(rsaPrivKey.getModulus(), rsaPrivKey.getPrivateExponent());
                        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                        key = keyFactory.generatePrivate(rsaPrivKeySpec);
                        continue;
                    }
                    if (!line.contains("BEGIN ENCRYPTED PRIVATE KEY")) continue;
                    if (password != null) {
                        new BouncyCastleHelper().checkProviderInstalled();
                        InputDecryptorProvider inputDecryptorProvider = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider("BC").build(password.toCharArray());
                        PKCS8EncryptedPrivateKeyInfo pkInfo = new PKCS8EncryptedPrivateKeyInfo(this.readPemBytes(reader));
                        PrivateKeyInfo info = pkInfo.decryptPrivateKeyInfo(inputDecryptorProvider);
                        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                        key = converter.getPrivateKey(info);
                        continue;
                    }
                    throw new UnrecoverableKeyException();
                }
                chain = certs.toArray(new X509Certificate[certs.size()]);
            } else {
                throw new RuntimeException("Unknown TLS certificate format");
            }
            if (chain == null || chain.length == 0) {
                throw new RuntimeException("Missing TLS certificate");
            }
            if (isKeyEntry && key == null) {
                throw new RuntimeException("Missing TLS private key");
            }
            entry = isKeyEntry ? new KeyStore.PrivateKeyEntry(key, chain) : new KeyStore.TrustedCertificateEntry(chain[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return entry;
    }

    protected byte[] readPemBytes(BufferedReader reader) throws IOException, CertificateException {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = null;
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("----")) {
                bytes = Base64.decodeBase64((String)sb.toString());
                break;
            }
            sb.append(line);
        }
        return bytes;
    }

    @Override
    public synchronized X509Certificate getCurrentSslCert() {
        return this.getCurrentSslCert(System.getProperty("sym.keystore.ssl.cert.alias", "sym"));
    }

    @Override
    public synchronized X509Certificate getCurrentSamlSslCert() {
        return this.getCurrentSslCert("saml");
    }

    private synchronized X509Certificate getCurrentSslCert(String alias) {
        X509Certificate cert = null;
        try {
            KeyStore keyStore = this.getKeyStore();
            KeyStore.PasswordProtection param = new KeyStore.PasswordProtection(this.getKeyStorePassword().toCharArray());
            KeyStore.Entry entry = keyStore.getEntry(alias, param);
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                cert = (X509Certificate)keyStore.getCertificate(alias);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cert;
    }

    @Override
    public synchronized String exportCurrentSslCert(boolean includePrivateKey) {
        String pem = null;
        try {
            KeyStore keyStore = this.getKeyStore();
            KeyStore.PasswordProtection param = new KeyStore.PasswordProtection(this.getKeyStorePassword().toCharArray());
            String alias = System.getProperty("sym.keystore.ssl.cert.alias", "sym");
            KeyStore.Entry entry = keyStore.getEntry(alias, param);
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                String nl = System.getProperty("line.separator");
                StringWriter writer = new StringWriter();
                writer.write("-----BEGIN CERTIFICATE-----" + nl);
                writer.write(new String(Base64.encodeBase64((byte[])cert.getEncoded(), (boolean)true), Charset.defaultCharset()));
                writer.write("-----END CERTIFICATE-----" + nl);
                if (includePrivateKey) {
                    KeyStore.PrivateKeyEntry key = (KeyStore.PrivateKeyEntry)entry;
                    writer.write("-----BEGIN PRIVATE KEY-----" + nl);
                    writer.write(new String(Base64.encodeBase64((byte[])key.getPrivateKey().getEncoded(), (boolean)true), Charset.defaultCharset()));
                    writer.write("-----END PRIVATE KEY-----" + nl);
                }
                pem = writer.toString();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return pem;
    }

    @Override
    public String exportTrustedCert(String alias) {
        String pem = null;
        try {
            KeyStore keyStore = this.getTrustStore();
            KeyStore.Entry entry = keyStore.getEntry(alias, null);
            if (entry instanceof KeyStore.TrustedCertificateEntry) {
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                String nl = System.getProperty("line.separator");
                StringWriter writer = new StringWriter();
                writer.write("-----BEGIN CERTIFICATE-----" + nl);
                writer.write(new String(Base64.encodeBase64((byte[])cert.getEncoded(), (boolean)true), Charset.defaultCharset()));
                writer.write("-----END CERTIFICATE-----" + nl);
                pem = writer.toString();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return pem;
    }
}

