/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.manager.impl;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.event.Event;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiConsoleOutputListener;
import ghidra.dbg.jdi.manager.JdiEventHandler;
import ghidra.dbg.jdi.manager.JdiEventsListener;
import ghidra.dbg.jdi.manager.JdiManager;
import ghidra.dbg.jdi.manager.JdiStateListener;
import ghidra.dbg.jdi.manager.JdiTargetOutputListener;
import ghidra.dbg.jdi.rmi.jpda.JdiArguments;
import ghidra.lifecycle.Unfinished;
import ghidra.util.Msg;
import ghidra.util.datastruct.ListenerSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.tuple.Pair;

public class JdiManagerImpl
implements JdiManager {
    private VirtualMachineManager virtualMachineManager;
    private final Map<String, VirtualMachine> vms = new LinkedHashMap<String, VirtualMachine>();
    private VirtualMachine curVM = null;
    private ThreadReference curThread = null;
    private StackFrame curFrame = null;
    private Location curLocation = null;
    private Event curEvent = null;
    private final Map<String, VirtualMachine> unmodifiableVMs = Collections.unmodifiableMap(this.vms);
    protected final ListenerSet<JdiTargetOutputListener> listenersTargetOutput = new ListenerSet(JdiTargetOutputListener.class, true);
    protected final ListenerSet<JdiConsoleOutputListener> listenersConsoleOutput = new ListenerSet(JdiConsoleOutputListener.class, true);
    protected final ExecutorService eventThread = Executors.newSingleThreadExecutor();
    protected JdiEventHandler globalEventHandler = new JdiEventHandler();
    protected Map<VirtualMachine, JdiEventHandler> eventHandlers = new HashMap<VirtualMachine, JdiEventHandler>();
    protected Map<VirtualMachine, Connector> connectors = new HashMap<VirtualMachine, Connector>();

    public JdiManagerImpl() {
        this.virtualMachineManager = Bootstrap.virtualMachineManager();
    }

    private static void pumpStream(InputStream in, OutputStream out) {
        try {
            in.transferTo(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public VirtualMachine connectVM(Connector cx, Map<String, Connector.Argument> arguments) throws Exception {
        if (cx instanceof LaunchingConnector) {
            LaunchingConnector lcx = (LaunchingConnector)cx;
            VirtualMachine vm = lcx.launch(arguments);
            new Thread(() -> JdiManagerImpl.pumpStream(vm.process().getErrorStream(), System.err)).start();
            new Thread(() -> JdiManagerImpl.pumpStream(vm.process().getInputStream(), System.out)).start();
            return vm;
        }
        if (cx instanceof AttachingConnector) {
            AttachingConnector acx = (AttachingConnector)cx;
            return acx.attach(arguments);
        }
        if (cx instanceof ListeningConnector) {
            ListeningConnector lcx = (ListeningConnector)cx;
            return lcx.accept(arguments);
        }
        throw new Exception("Unknown connector type");
    }

    public VirtualMachine createVM(Map<String, String> env) {
        JdiArguments args = new JdiArguments(env);
        Connector cx = args.getConnector(this.virtualMachineManager);
        Map<String, Connector.Argument> defaultArguments = cx.defaultArguments();
        args.putArguments(defaultArguments);
        return this.addVM(cx, defaultArguments);
    }

    @Override
    public void terminate() {
        for (VirtualMachine vm : this.vms.values()) {
            try {
                vm.dispose();
            }
            catch (VMDisconnectedException vMDisconnectedException) {}
        }
    }

    @Override
    public void addStateListener(VirtualMachine vm, JdiStateListener listener) {
        if (vm != null) {
            JdiEventHandler eventHandler = this.eventHandlers.get(vm);
            if (eventHandler != null) {
                eventHandler.addStateListener(listener);
            }
        } else {
            this.globalEventHandler.addStateListener(listener);
        }
    }

    @Override
    public void removeStateListener(VirtualMachine vm, JdiStateListener listener) {
        if (vm != null) {
            this.eventHandlers.get(vm).removeStateListener(listener);
        } else {
            this.globalEventHandler.removeStateListener(listener);
        }
    }

    @Override
    public void addEventsListener(VirtualMachine vm, JdiEventsListener listener) {
        if (vm != null) {
            this.eventHandlers.get(vm).addEventsListener(listener);
        } else {
            this.globalEventHandler.addEventsListener(listener);
        }
    }

    @Override
    public void removeEventsListener(VirtualMachine vm, JdiEventsListener listener) {
        if (vm != null) {
            this.eventHandlers.get(vm).removeEventsListener(listener);
        } else {
            this.globalEventHandler.removeEventsListener(listener);
        }
    }

    @Override
    public void addTargetOutputListener(JdiTargetOutputListener listener) {
        this.listenersTargetOutput.add((Object)listener);
    }

    @Override
    public void removeTargetOutputListener(JdiTargetOutputListener listener) {
        this.listenersTargetOutput.remove((Object)listener);
    }

    @Override
    public void addConsoleOutputListener(JdiConsoleOutputListener listener) {
        this.listenersConsoleOutput.add((Object)listener);
    }

    @Override
    public void removeConsoleOutputListener(JdiConsoleOutputListener listener) {
        this.listenersConsoleOutput.remove((Object)listener);
    }

    @Override
    public VirtualMachine getVM(String id) {
        return this.vms.get(id);
    }

    @Override
    public Map<String, VirtualMachine> getKnownVMs() {
        return this.unmodifiableVMs;
    }

    @Override
    public void sendInterruptNow() throws IOException {
        for (VirtualMachine vm : this.vms.values()) {
            for (ThreadReference thread : vm.allThreads()) {
                thread.interrupt();
            }
        }
    }

    @Override
    public VirtualMachine addVM(Connector cx, List<String> args) {
        Map<String, Connector.Argument> arguments = cx.defaultArguments();
        if (cx instanceof LaunchingConnector) {
            if (arguments.containsKey("command")) {
                arguments.get("command").setValue(args.get(0));
            } else {
                arguments.get("main").setValue(args.get(0));
            }
        }
        if (cx instanceof AttachingConnector) {
            if (arguments.containsKey("pid")) {
                arguments.get("pid").setValue("" + Integer.decode(args.get(0)));
            } else if (args.size() == 2) {
                arguments.get("hostname").setValue(args.get(0));
                arguments.get("port").setValue(args.get(1));
            } else {
                arguments.get("port").setValue(args.get(0));
            }
        }
        if (cx instanceof ListeningConnector) {
            arguments.get("port").setValue("0");
            arguments.get("localAddress").setValue("localhost");
        }
        return this.addVM(cx, arguments);
    }

    @Override
    public VirtualMachine addVM(Connector cx, Map<String, Connector.Argument> args) {
        try {
            this.setCurrentVM(this.connectVM(cx, args));
            JdiEventHandler eventHandler = new JdiEventHandler(this.getCurrentVM(), this.globalEventHandler);
            eventHandler.start();
            eventHandler.setState(5, JdiCause.Causes.UNCLAIMED);
            this.eventHandlers.put(this.getCurrentVM(), eventHandler);
            this.vms.put(this.getCurrentVM().name(), this.getCurrentVM());
            this.connectors.put(this.getCurrentVM(), cx);
        }
        catch (VMDisconnectedException e) {
            Msg.error((Object)this, (Object)"Virtual Machine is disconnected.");
            return null;
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Could not connect Virtual Machine", (Throwable)e);
            return null;
        }
        return this.getCurrentVM();
    }

    public void addVM(VirtualMachine vm) {
        JdiEventHandler eventHandler = new JdiEventHandler(vm, this.globalEventHandler);
        eventHandler.start();
        eventHandler.setState(5, JdiCause.Causes.UNCLAIMED);
        this.eventHandlers.put(this.getCurrentVM(), eventHandler);
        this.vms.put(this.getCurrentVM().name(), this.getCurrentVM());
    }

    @Override
    public CompletableFuture<Void> removeVM(VirtualMachine vm) {
        if (this.getCurrentVM() == vm) {
            this.setCurrentVM(null);
        }
        this.vms.remove(vm.name());
        this.connectors.remove(vm);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> console(String command) {
        return (CompletableFuture)Unfinished.TODO();
    }

    @Override
    public CompletableFuture<String> consoleCapture(String command) {
        return (CompletableFuture)Unfinished.TODO();
    }

    @Override
    public CompletableFuture<Map<String, VirtualMachine>> listVMs() {
        return CompletableFuture.completedFuture(this.vms);
    }

    @Override
    @Deprecated(forRemoval=true)
    public CompletableFuture<List<Pair<Integer, String>>> listAvailableProcesses() {
        ArrayList processes = new ArrayList();
        return CompletableFuture.completedFuture(processes);
    }

    @Override
    public VirtualMachineManager getVirtualMachineManager() {
        return this.virtualMachineManager;
    }

    public Connector getConnector(VirtualMachine vm) {
        return this.connectors.get(vm);
    }

    @Override
    public JdiEventHandler getEventHandler(VirtualMachine vm) {
        return this.eventHandlers.get(vm);
    }

    public VirtualMachine getCurrentVM() {
        return this.curVM;
    }

    public void setCurrentVM(VirtualMachine vm) {
        this.curVM = vm;
        if (!this.vms.containsValue(vm)) {
            this.addVM(vm);
        }
    }

    public ThreadReference getCurrentThread() {
        if (this.curThread == null) {
            List<ThreadReference> threads = this.curVM.allThreads();
            this.curThread = threads.getFirst();
        }
        return this.curThread;
    }

    public void setCurrentThread(ThreadReference thread) {
        this.curThread = thread;
    }

    public StackFrame getCurrentFrame() {
        return this.curFrame;
    }

    public void setCurrentFrame(StackFrame frame) {
        this.curFrame = frame;
    }

    public void setCurrentLocation(Location location) {
        this.curLocation = location;
    }

    public Location getCurrentLocation() {
        return this.curLocation;
    }

    public void setCurrentEvent(Event event) {
        this.curEvent = event;
    }

    public Event getCurrentEvent() {
        return this.curEvent;
    }
}

