/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.DBRecord;
import db.Field;
import db.FixedKeyNode;
import db.FixedKeyRecordNode;
import db.NodeMgr;
import db.Schema;
import db.buffers.DataBuffer;
import ghidra.util.exception.AssertException;
import java.io.IOException;

class FixedKeyFixedRecNode
extends FixedKeyRecordNode {
    private static final int HEADER_SIZE = 13;
    private static final int ENTRY_BASE_OFFSET = 13;
    private static final int[] EMPTY_ID_LIST = new int[0];
    private int entrySize;
    private int recordLength;

    FixedKeyFixedRecNode(NodeMgr nodeMgr, DataBuffer buf) throws IOException {
        super(nodeMgr, buf);
        this.recordLength = nodeMgr.getTableSchema().getFixedLength();
        this.entrySize = this.keySize + this.recordLength;
    }

    FixedKeyFixedRecNode(NodeMgr nodeMgr, int prevLeafId, int nextLeafId) throws IOException {
        super(nodeMgr, (byte)7, prevLeafId, nextLeafId);
        this.recordLength = nodeMgr.getTableSchema().getFixedLength();
        this.entrySize = this.keySize + this.recordLength;
    }

    @Override
    FixedKeyRecordNode createNewLeaf(int prevLeafId, int nextLeafId) throws IOException {
        return new FixedKeyFixedRecNode(this.nodeMgr, prevLeafId, nextLeafId);
    }

    @Override
    public int getKeyOffset(int index) {
        return 13 + index * this.entrySize;
    }

    @Override
    public int getRecordOffset(int index) {
        return 13 + index * this.entrySize;
    }

    private void shiftRecords(int index, boolean rightShift) {
        if (index == this.keyCount) {
            return;
        }
        int start = this.getRecordOffset(index);
        int end = this.getRecordOffset(this.keyCount);
        int len = end - start;
        int offset = start + (rightShift ? this.entrySize : -this.entrySize);
        this.buffer.move(start, offset, len);
    }

    @Override
    public void remove(int index) {
        if (index < 0 || index >= this.keyCount) {
            throw new AssertException();
        }
        this.shiftRecords(index + 1, false);
        this.setKeyCount(this.keyCount - 1);
    }

    @Override
    boolean insertRecord(int index, DBRecord record) throws IOException {
        if (this.keyCount == (this.buffer.length() - 13) / this.entrySize) {
            return false;
        }
        this.shiftRecords(index, true);
        int offset = this.getRecordOffset(index);
        record.getKeyField().write(this.buffer, offset);
        record.write(this.buffer, offset + this.keySize);
        this.setKeyCount(this.keyCount + 1);
        return true;
    }

    @Override
    FixedKeyNode updateRecord(int index, DBRecord record) throws IOException {
        int offset = this.getRecordOffset(index) + this.keySize;
        record.write(this.buffer, offset);
        return this.getRoot();
    }

    @Override
    public DBRecord getRecord(Field key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            return null;
        }
        DBRecord record = schema.createRecord(key);
        record.read(this.buffer, this.getRecordOffset(index) + this.keySize);
        return record;
    }

    @Override
    public DBRecord getRecord(Schema schema, int index) throws IOException {
        Field key = this.getKeyField(index);
        DBRecord record = schema.createRecord(key);
        record.read(this.buffer, this.getRecordOffset(index) + this.keySize);
        return record;
    }

    @Override
    void splitData(FixedKeyRecordNode newRightLeaf) {
        FixedKeyFixedRecNode rightNode = (FixedKeyFixedRecNode)newRightLeaf;
        int splitIndex = this.keyCount / 2;
        int count = this.keyCount - splitIndex;
        int start = this.getRecordOffset(splitIndex);
        int end = this.getRecordOffset(this.keyCount);
        int splitLen = end - start;
        rightNode.buffer.copy(13, this.buffer, start, splitLen);
        this.setKeyCount(this.keyCount - count);
        rightNode.setKeyCount(count);
    }

    @Override
    public void delete() throws IOException {
        this.nodeMgr.deleteNode(this);
    }

    @Override
    public int[] getBufferReferences() {
        return EMPTY_ID_LIST;
    }
}

