/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge;

import ghidra.app.merge.DataTypeArchiveMergeManagerPlugin;
import ghidra.app.merge.MergeManager;
import ghidra.app.merge.MergeManagerPlugin;
import ghidra.app.merge.MergeResolver;
import ghidra.app.merge.datatypes.DataTypeMergeManager;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.ModalPluginTool;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.program.model.listing.DataTypeArchiveChangeSet;
import ghidra.program.model.listing.DataTypeChangeSet;
import ghidra.program.model.listing.DomainObjectChangeSet;

public class DataTypeArchiveMergeManager
extends MergeManager {
    public DataTypeArchiveMergeManager(DataTypeManagerDomainObject resultDtArchive, DataTypeManagerDomainObject myDtArchive, DataTypeManagerDomainObject originalDtArchive, DataTypeManagerDomainObject latestDtArchive, DataTypeArchiveChangeSet latestChangeSet, DataTypeArchiveChangeSet myChangeSet) {
        super((DomainObject)resultDtArchive, (DomainObject)myDtArchive, (DomainObject)originalDtArchive, (DomainObject)latestDtArchive, (DomainObjectChangeSet)latestChangeSet, (DomainObjectChangeSet)myChangeSet);
    }

    @Override
    protected void createMergeResolvers() {
        int idx = 0;
        this.mergeResolvers = new MergeResolver[1];
        this.mergeResolvers[idx++] = new DataTypeMergeManager(this, (DataTypeManagerDomainObject)this.resultDomainObject, (DataTypeManagerDomainObject)this.myDomainObject, (DataTypeManagerDomainObject)this.originalDomainObject, (DataTypeManagerDomainObject)this.latestDomainObject, (DataTypeChangeSet)((DataTypeArchiveChangeSet)this.latestChangeSet), (DataTypeChangeSet)((DataTypeArchiveChangeSet)this.myChangeSet));
    }

    public DataTypeArchive getDataTypeArchive(int version) {
        switch (version) {
            case 1: {
                return (DataTypeArchive)this.latestDomainObject;
            }
            case 2: {
                return (DataTypeArchive)this.myDomainObject;
            }
            case 3: {
                return (DataTypeArchive)this.originalDomainObject;
            }
            case 0: {
                return (DataTypeArchive)this.resultDomainObject;
            }
        }
        return null;
    }

    @Override
    protected MergeManagerPlugin createMergeManagerPlugin(ModalPluginTool mergePluginTool, MergeManager multiUserMergeManager, DomainObject modifiableDomainObject) {
        return new DataTypeArchiveMergeManagerPlugin((PluginTool)this.mergeTool, this, (DataTypeArchive)this.resultDomainObject);
    }

    @Override
    protected void initializeMerge() {
    }

    @Override
    protected void cleanupMerge() {
    }
}

