/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import ghidra.features.bsim.gui.filters.DateBSimFilterType;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.client.SQLEffects;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.elastic.ElasticEffects;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.features.bsim.query.elastic.IDElasticResolution;
import ghidra.features.bsim.query.protocol.FilterAtom;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;

public class DateEarlierBSimFilterType
extends DateBSimFilterType {
    public static final String XML_VALUE = "dateearlier";

    public DateEarlierBSimFilterType(String sub) {
        super(sub + " is earlier than", XML_VALUE, "1974-09-21 or 09/21/1974");
    }

    @Override
    public void gatherSQLEffect(SQLEffects effect, FilterAtom atom, IDSQLResolution resolution) throws SQLException {
        LocalDate localDate = this.formatDate(atom.value);
        if (localDate == null) {
            return;
        }
        Date date = Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        effect.setExeTable();
        String dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ").format(date);
        StringBuilder buf = new StringBuilder();
        buf.append("exetable.ingest_date < to_timestamp('").append(dateString).append("','YYYY-MM-DD HH24:MI:SS.MSz')");
        effect.addWhere(this, buf.toString());
    }

    @Override
    public void gatherElasticEffect(ElasticEffects effect, FilterAtom atom, IDElasticResolution resolution) throws ElasticException {
        LocalDate localDate = this.formatDate(atom.value);
        Date date = Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        if (date == null) {
            return;
        }
        effect.addDocValue("ZonedDateTime date = doc['ingest_date'].value; ");
        String argName = effect.assignArgument();
        effect.addScriptElement(this, "ZonedDateTime.ofInstant(Instant.ofEpochMilli(params." + argName + "), ZoneId.of('Z')).compareTo(date) > 0");
        effect.addDateParam(argName, date);
    }

    @Override
    public boolean evaluate(ExecutableRecord rec, String value) {
        LocalDate localDate = this.formatDate(value);
        Date date = Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        if (date == null) {
            return true;
        }
        return rec.getDate().before(date);
    }
}

