/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.EmptyBorderButton;
import docking.widgets.combobox.GComboBox;
import docking.widgets.textfield.FloatingPointTextField;
import generic.theme.Gui;
import ghidra.features.bsim.gui.BSimServerManager;
import ghidra.features.bsim.gui.search.dialog.BSimSearchService;
import ghidra.features.bsim.gui.search.dialog.BSimSearchSettings;
import ghidra.features.bsim.gui.search.dialog.BSimServerCache;
import ghidra.features.bsim.gui.search.dialog.BSimServerDialog;
import ghidra.features.bsim.gui.search.dialog.BSimServerManagerListener;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.facade.QueryDatabaseException;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.task.Task;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import resources.Icons;

public abstract class AbstractBSimSearchDialog
extends DialogComponentProvider {
    private final BSimServerManager serverManager;
    private GComboBox<BSimServerInfo> serverCombo;
    private BSimServerManagerListener serverInfoListener = this::serverListChanged;
    private ItemListener serverComboListener = this::comboChanged;
    protected BSimSearchService searchService;
    protected PluginTool tool;
    protected FloatingPointTextField similarityField;
    protected FloatingPointTextField confidenceField;
    protected BSimServerCache serverCache;

    protected AbstractBSimSearchDialog(String title, PluginTool tool, BSimSearchService service, BSimServerManager serverManager) {
        super(title, true);
        this.tool = tool;
        this.searchService = service;
        this.serverManager = serverManager;
        serverManager.addListener(this.serverInfoListener);
        this.addWorkPanel(this.buildMainPanel());
        this.populateComboServerComboBox();
        this.addOKButton();
        this.addCancelButton();
        this.initializeConnection(this.searchService.getLastUsedServer());
        this.initializeSettings(this.searchService.getLastUsedSearchSettings());
    }

    protected void initializeSettings(BSimSearchSettings lastUsedSearchSettings) {
        this.similarityField.setValue(lastUsedSearchSettings.getSimilarity());
        this.confidenceField.setValue(lastUsedSearchSettings.getConfidence());
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.buildNorthPanel(), "North");
        panel.add(this.buildCenterPanel(), "Center");
        panel.getAccessibleContext().setAccessibleName("BSim Search");
        return panel;
    }

    private Component buildNorthPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(10));
        panel.add(this.buildServerPanel());
        panel.add(this.createTitledPanel("Options", this.buildOptionsPanel(), false));
        panel.getAccessibleContext().setAccessibleName("Server and Options");
        return panel;
    }

    protected Component buildCenterPanel() {
        return new JPanel();
    }

    protected JPanel buildServerPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(10, 10));
        panel.add(new JLabel("BSim Server:"));
        panel.add(this.buildServerComponent());
        panel.getAccessibleContext().setAccessibleName("Server");
        return panel;
    }

    protected JPanel buildOptionsPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(2, 10));
        this.similarityField = new FloatingPointTextField(10);
        this.similarityField.setValue(0.7);
        this.similarityField.setMinValue(0.0);
        this.similarityField.setMaxValue(1.0);
        this.confidenceField = new FloatingPointTextField(10);
        this.confidenceField.setValue(0.0);
        this.confidenceField.setMinValue(0.0);
        JLabel similarityLabel = new JLabel("Similarity Threshold (0-1):");
        JLabel confidenceLabel = new JLabel("Confidence Threshold:");
        similarityLabel.setLabelFor((Component)this.similarityField);
        confidenceLabel.setLabelFor((Component)this.confidenceField);
        panel.add(similarityLabel);
        panel.add((Component)this.similarityField);
        panel.add(confidenceLabel);
        panel.add((Component)this.confidenceField);
        panel.getAccessibleContext().setAccessibleName("Options");
        return panel;
    }

    public void dispose() {
        this.serverManager.removeListener(this.serverInfoListener);
        super.dispose();
    }

    private void serverListChanged() {
        this.populateComboServerComboBox();
    }

    private void populateComboServerComboBox() {
        this.serverCombo.removeItemListener(this.serverComboListener);
        DefaultComboBoxModel<BSimServerInfo> model = new DefaultComboBoxModel<BSimServerInfo>();
        ArrayList<BSimServerInfo> serverInfos = new ArrayList<BSimServerInfo>(this.serverManager.getServerInfos());
        Collections.sort(serverInfos);
        model.addElement(null);
        model.addAll(serverInfos);
        this.serverCombo.setModel(model);
        this.serverCombo.addItemListener(this.serverComboListener);
    }

    private void comboChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        Swing.runLater(() -> {
            BSimServerInfo selected = (BSimServerInfo)this.serverCombo.getSelectedItem();
            if (this.serverCache == null || !this.serverCache.getServerInfo().equals(selected)) {
                this.initializeConnection(selected);
            }
        });
        this.setStatusText("");
    }

    private void initializeConnection(BSimServerInfo info) {
        if (info != null) {
            try {
                this.setServerCache(new BSimServerCache(info));
                return;
            }
            catch (QueryDatabaseException e) {
                if (!e.getMessage().contains("cancelled")) {
                    Msg.showError((Object)((Object)this), (Component)this.rootPanel, (String)"BSim Server Connection Failure", (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                Msg.showError((Object)((Object)this), (Component)this.rootPanel, (String)"BSim Server Connection Failure", (Object)("Unexpected error while connecting to: " + String.valueOf(info)), (Throwable)e);
            }
        }
        this.setServerCache(null);
    }

    protected DatabaseInformation getDatabaseInformation() {
        if (this.serverCache != null) {
            return this.serverCache.getDatabaseInformation();
        }
        return null;
    }

    protected void updateSearchEnablement() {
        this.setOkEnabled(this.canQuery());
    }

    protected boolean canQuery() {
        if (this.serverCache == null) {
            this.setStatusText("Please select a Bsim Server.");
            return false;
        }
        return true;
    }

    protected void setServerCache(BSimServerCache serverCache) {
        this.serverCache = serverCache;
        this.setSelectedComboValue(serverCache != null ? serverCache.getServerInfo() : null);
        this.updateSearchEnablement();
    }

    private void setSelectedComboValue(BSimServerInfo info) {
        if (!Objects.equals(this.serverCombo.getSelectedItem(), info)) {
            this.serverCombo.removeItemListener(this.serverComboListener);
            this.serverCombo.setSelectedItem((Object)info);
            this.serverCombo.addItemListener(this.serverComboListener);
        }
    }

    private JPanel buildServerComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel comboPanel = new JPanel(new BorderLayout());
        comboPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.serverCombo = new GComboBox();
        this.serverCombo.addItemListener(this.serverComboListener);
        comboPanel.add((Component)this.serverCombo, "Center");
        panel.add((Component)comboPanel, "Center");
        AccessibleContext context = this.serverCombo.getAccessibleContext();
        context.setAccessibleName("BSim Server");
        context.setAccessibleDescription("Select a predefined Bsim Server");
        EmptyBorderButton button = new EmptyBorderButton(Icons.CONFIGURE_FILTER_ICON);
        button.setToolTipText("Show Server Manager Dialog");
        button.addActionListener(e -> this.managerServers());
        panel.add((Component)button, "East");
        return panel;
    }

    protected JPanel createTitledPanel(String name, JComponent comp, boolean fullWidth) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(20, 5, 0, 0));
        JPanel titlePanel = new JPanel(new BorderLayout());
        JPanel contentPanel = new JPanel(new BorderLayout());
        panel.add((Component)titlePanel, "North");
        panel.add((Component)contentPanel, "Center");
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 15, 0, 0));
        contentPanel.add((Component)comp, fullWidth ? "Center" : "West");
        JLabel label = new JLabel(name);
        Gui.registerFont((JComponent)label, (int)1);
        titlePanel.add((Component)label, "North");
        return panel;
    }

    private void managerServers() {
        BSimServerDialog dialog = new BSimServerDialog(this.tool, this.serverManager);
        DockingWindowManager.showDialog((DialogComponentProvider)dialog);
        BSimServerInfo lastAddedServer = dialog.getLastAdded();
        if (lastAddedServer != null) {
            this.initializeConnection(lastAddedServer);
        }
    }

    protected void setServer(BSimServerInfo info) {
        this.initializeConnection(info);
    }

    protected BSimServerInfo getServer() {
        return this.serverCache == null ? null : this.serverCache.getServerInfo();
    }

    protected abstract class BSimQueryTask
    extends Task {
        protected Exception errorException;

        BSimQueryTask(AbstractBSimSearchDialog this$0, String title) {
            super(title, true, true, false);
        }

        boolean hasError() {
            return this.errorException != null;
        }

        Exception getError() {
            return this.errorException;
        }
    }
}

