/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.spatial.rtree;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.jungrapht.visualization.spatial.rtree.AbstractSplitter;
import org.jungrapht.visualization.spatial.rtree.HorizontalEdgeNodeComparator;
import org.jungrapht.visualization.spatial.rtree.InnerNode;
import org.jungrapht.visualization.spatial.rtree.Node;
import org.jungrapht.visualization.spatial.rtree.Pair;
import org.jungrapht.visualization.spatial.rtree.Splitter;
import org.jungrapht.visualization.spatial.rtree.VerticalEdgeNodeComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RStarSplitter<T>
extends AbstractSplitter<T>
implements Splitter<T> {
    private static Logger log = LoggerFactory.getLogger(RStarSplitter.class);
    private Comparator<Node<T>> horizontalEdgeComparator = new HorizontalEdgeNodeComparator();
    private Comparator verticalEdgeComparator = new VerticalEdgeNodeComparator();

    @Override
    public Pair<InnerNode<T>> split(List<Node<T>> children, Node<T> newEntry) {
        return this.chooseSplitVertices(children, newEntry);
    }

    private Pair<InnerNode<T>> chooseSplitVertices(Collection<Node<T>> entries, Node<T> newEntry) {
        Pair<List<Node<T>>> pair = this.chooseSplit(entries, newEntry);
        InnerNode innerVertexLeft = InnerNode.create((Collection)pair.left);
        InnerNode innerVertexRight = InnerNode.create((Collection)pair.right);
        return Pair.of(innerVertexLeft, innerVertexRight);
    }

    private Pair<List<Node<T>>> chooseSplit(Collection<Node<T>> entries, Node<T> newEntry) {
        ArrayList<Node<T>> xAxisList = new ArrayList<Node<T>>(entries);
        xAxisList.add(newEntry);
        ArrayList<Node<T>> yAxisList = new ArrayList<Node<T>>(entries);
        yAxisList.add(newEntry);
        xAxisList.sort(this.horizontalEdgeComparator);
        yAxisList.sort(this.verticalEdgeComparator);
        ArrayList<Pair<List<Node<T>>>> horizontalGroup = new ArrayList<Pair<List<Node<T>>>>();
        ArrayList<Pair<List<Node<T>>>> verticalGroup = new ArrayList<Pair<List<Node<T>>>>();
        for (int k = 0; k < 4; ++k) {
            horizontalGroup.add(Pair.of(xAxisList.subList(0, 3 + k), xAxisList.subList(3 + k, xAxisList.size())));
            verticalGroup.add(Pair.of(yAxisList.subList(0, 3 + k), yAxisList.subList(3 + k, yAxisList.size())));
        }
        int sumXMarginValue = 0;
        for (Pair pair : horizontalGroup) {
            sumXMarginValue = (int)((double)sumXMarginValue + Node.nodeMargin((Collection)pair.left, (Collection)pair.right));
        }
        int sumYMarginValue = 0;
        for (Pair pair : verticalGroup) {
            sumYMarginValue = (int)((double)sumYMarginValue + Node.nodeMargin((Collection)pair.left, (Collection)pair.right));
        }
        if (sumXMarginValue < sumYMarginValue) {
            return this.chooseSplitIndex(horizontalGroup);
        }
        return this.chooseSplitIndex(verticalGroup);
    }

    private Pair<List<Node<T>>> chooseSplitIndex(List<Pair<List<Node<T>>>> group) {
        double minOverlap = 0.0;
        double minArea = 0.0;
        Optional<Object> winner = Optional.empty();
        for (Pair<List<Node<T>>> pair : group) {
            double nodeOverlap = Node.nodeOverlap((Collection)pair.left, (Collection)pair.right);
            double nodeArea = Node.nodeArea((Collection)pair.left, (Collection)pair.right);
            if (winner.isEmpty()) {
                minOverlap = nodeOverlap;
                minArea = nodeArea;
                winner = Optional.of(pair);
                continue;
            }
            if (nodeOverlap == minOverlap) {
                if (!(nodeArea < minArea)) continue;
                minOverlap = nodeOverlap;
                minArea = nodeArea;
                winner = Optional.of(pair);
                continue;
            }
            if (!(nodeOverlap < minOverlap)) continue;
            minOverlap = nodeOverlap;
            minArea = nodeArea;
            winner = Optional.of(pair);
        }
        return winner.orElse(null);
    }

    @Override
    public Optional<Node<T>> chooseSubtree(InnerNode<T> nodeToSplit, T element, Rectangle2D bounds) {
        if (nodeToSplit.isLeafChildren()) {
            return this.leastOverlapThenEnlargementThenAreaThenKids(nodeToSplit, bounds);
        }
        return this.leastEnlargementThenAreaThenKids(nodeToSplit, bounds);
    }
}

