/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyTreeResolver;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.expression.OperandValue;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OperandValueSolver
extends AbstractExpressionSolver<OperandValue> {
    public OperandValueSolver() {
        super(OperandValue.class);
    }

    public static PatternExpression getDefiningExpression(OperandSymbol sym) {
        PatternExpression patexp = sym.getDefiningExpression();
        if (patexp != null) {
            return patexp;
        }
        TripleSymbol defSym = sym.getDefiningSymbol();
        if (defSym == null) {
            return null;
        }
        patexp = defSym.getPatternExpression();
        return patexp;
    }

    @Override
    public AssemblyResolution solve(AbstractAssemblyResolutionFactory<?, ?> factory, OperandValue ov, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) throws NeedsBackfillException {
        Constructor cons = ov.getConstructor();
        OperandSymbol sym = cons.getOperand(ov.getIndex());
        PatternExpression patexp = OperandValueSolver.getDefiningExpression(sym);
        if (patexp == null) {
            if (goal.equals(MaskedLong.ZERO)) {
                return factory.nop(description);
            }
            return ((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)factory.newErrorBuilder().error("Operand " + sym.getName() + " is undefined and does not agree with child requirements").description(description)).build();
        }
        AssemblyResolution result = this.solver.solve(factory, patexp, goal, vals, cur, hints, description);
        if (result.isError()) {
            AssemblyResolvedError err = (AssemblyResolvedError)result;
            return ((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)factory.newErrorBuilder().error(err.getError()).description("Solution to " + sym.getName() + " := " + String.valueOf(goal) + " = " + String.valueOf(patexp))).children(List.of(result))).build();
        }
        AssemblyResolvedPatterns con = (AssemblyResolvedPatterns)result;
        int shamt = AssemblyTreeResolver.computeOffset(sym, cons);
        return con.shift(shamt);
    }

    @Override
    public MaskedLong getValue(OperandValue ov, Map<String, Long> vals, AssemblyResolvedPatterns cur) throws NeedsBackfillException {
        Constructor cons = ov.getConstructor();
        OperandSymbol sym = cons.getOperand(ov.getIndex());
        PatternExpression patexp = OperandValueSolver.getDefiningExpression(sym);
        if (patexp == null) {
            return MaskedLong.ZERO;
        }
        int shamt = AssemblyTreeResolver.computeOffset(sym, cons);
        cur = cur == null ? null : cur.truncate(shamt);
        MaskedLong result = this.solver.getValue(patexp, vals, cur);
        return result;
    }

    @Override
    public int getInstructionLength(OperandValue ov) {
        Constructor cons = ov.getConstructor();
        OperandSymbol sym = cons.getOperand(ov.getIndex());
        PatternExpression patexp = sym.getDefiningExpression();
        if (patexp == null) {
            return 0;
        }
        int length = this.solver.getInstructionLength(patexp);
        int shamt = AssemblyTreeResolver.computeOffset(sym, cons);
        return length + shamt;
    }

    @Override
    public MaskedLong valueForResolution(OperandValue ov, Map<String, Long> vals, AssemblyResolvedPatterns rc) {
        TripleSymbol defSym;
        Constructor cons = ov.getConstructor();
        OperandSymbol sym = cons.getOperand(ov.getIndex());
        PatternExpression patexp = sym.getDefiningExpression();
        if (patexp == null && (defSym = sym.getDefiningSymbol()) != null) {
            patexp = defSym.getPatternExpression();
        }
        if (patexp == null) {
            return MaskedLong.ZERO;
        }
        return this.solver.valueForResolution(patexp, vals, rc);
    }
}

