/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeView;
import ghidra.trace.database.symbol.DBTraceClassSymbol;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.symbol.TraceClassSymbolView;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.concurrent.locks.Lock;

public class DBTraceClassSymbolView
extends AbstractDBTraceSymbolSingleTypeView<DBTraceClassSymbol>
implements TraceClassSymbolView {
    public DBTraceClassSymbolView(DBTraceSymbolManager manager) {
        super(manager, SymbolType.CLASS.getID(), manager.classStore);
    }

    @Override
    public DBTraceClassSymbol add(String name, TraceNamespaceSymbol parent, SourceType source) throws DuplicateNameException, InvalidInputException, IllegalArgumentException {
        if (source == SourceType.DEFAULT) {
            throw new IllegalArgumentException();
        }
        DBTraceSymbolManager.assertValidName(name);
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            DBTraceNamespaceSymbol dbnsParent = this.manager.assertIsMine(parent);
            this.manager.assertUniqueName(name, dbnsParent);
            DBTraceClassSymbol cls = (DBTraceClassSymbol)this.store.create();
            cls.set(name, dbnsParent, source);
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceClassSymbol, Void>(TraceEvents.SYMBOL_ADDED, null, cls));
            DBTraceClassSymbol dBTraceClassSymbol = cls;
            return dBTraceClassSymbol;
        }
    }
}

