/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.DBTraceReferenceSpace;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.symbol.TraceReference;
import ghidra.trace.model.symbol.TraceSymbolWithLifespan;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.Lock;

public class DBTraceReference
implements TraceReference {
    protected final DBTraceReferenceSpace.DBTraceReferenceEntry ent;

    public DBTraceReference(DBTraceReferenceSpace.DBTraceReferenceEntry ent) {
        this.ent = ent;
    }

    @Override
    public DBTrace getTrace() {
        return this.ent.space.trace;
    }

    @Override
    public void delete() {
        try (LockHold hold = LockHold.lock((Lock)this.ent.space.lock.writeLock());){
            this.ent.doDelete();
            this.ent.space.trace.setChanged(new TraceChangeRecord<DBTraceReferenceSpace.DBTraceReferenceEntry, DBTraceReference>(TraceEvents.REFERENCE_DELETED, this.ent.space.space, this.ent, this));
            if (this.isPrimary()) {
                Collection<? extends DBTraceReference> remaining = this.ent.space.getReferencesFrom(this.getStartSnap(), this.getFromAddress(), this.getOperandIndex());
                if (remaining.isEmpty()) {
                    return;
                }
                DBTraceReference newPrimary = remaining.iterator().next();
                newPrimary.ent.setPrimary(true);
                this.ent.space.trace.setChanged(new TraceChangeRecord<DBTraceReference, Boolean>(TraceEvents.REFERENCE_PRIMARY_CHANGED, this.ent.space.space, this, false, true));
            }
        }
    }

    @Override
    public Lifespan getLifespan() {
        return this.ent.getLifespan();
    }

    @Override
    public long getStartSnap() {
        return this.getLifespan().lmin();
    }

    public Address getFromAddress() {
        return this.ent.getX1();
    }

    @Override
    public AddressRange getToRange() {
        return this.ent.toRange;
    }

    @Override
    public void setPrimary(boolean primary) {
        try (LockHold hold = LockHold.lock((Lock)this.ent.space.lock.writeLock());){
            if (primary == this.isPrimary()) {
                return;
            }
            DBTraceReference oldPrimary = this.ent.space.getPrimaryReferenceFrom(this.getStartSnap(), this.getFromAddress(), this.getOperandIndex());
            if (oldPrimary != null) {
                oldPrimary.ent.setPrimary(false);
                this.ent.space.trace.setChanged(new TraceChangeRecord<DBTraceReference, Boolean>(TraceEvents.REFERENCE_PRIMARY_CHANGED, this.ent.space.space, oldPrimary, true, false));
            }
            this.ent.setPrimary(true);
            this.ent.space.trace.setChanged(new TraceChangeRecord<DBTraceReference, Boolean>(TraceEvents.REFERENCE_PRIMARY_CHANGED, this.ent.space.space, this, false, true));
        }
    }

    public boolean isPrimary() {
        return this.ent.isPrimary();
    }

    public long getSymbolID() {
        return this.ent.symbolId;
    }

    public RefType getReferenceType() {
        return this.ent.refType;
    }

    public int getOperandIndex() {
        return this.ent.opIndex;
    }

    public SourceType getSource() {
        return this.ent.getSourceType();
    }

    @Override
    public void setReferenceType(RefType refType) {
        if (refType == RefType.EXTERNAL_REF) {
            throw new IllegalArgumentException("Trace does not allow external references");
        }
        try (LockHold hold = LockHold.lock((Lock)this.ent.space.lock.writeLock());){
            this.ent.setRefType(refType);
        }
    }

    @Override
    public void setAssociatedSymbol(Symbol symbol) {
        try (LockHold hold = LockHold.lock((Lock)this.ent.space.lock.writeLock());){
            TraceSymbolWithLifespan symWl;
            AbstractDBTraceSymbol dbSym = this.getTrace().getSymbolManager().assertIsMine(symbol);
            if (this.ent.symbolId == symbol.getID()) {
                return;
            }
            Address toAddress = this.getToAddress();
            if (!Objects.equals(symbol.getAddress(), toAddress)) {
                throw new IllegalArgumentException(String.format("Symbol address (%s) of '%s' must match Reference's to address (%s)", symbol.getAddress(), symbol.getName(), toAddress));
            }
            if (symbol instanceof TraceSymbolWithLifespan && !(symWl = (TraceSymbolWithLifespan)symbol).getLifespan().intersects(this.getLifespan())) {
                throw new IllegalArgumentException("Associated symbol and reference must have connected lifespans");
            }
            this.ent.setSymbolId(symbol.getID());
            this.getTrace().setChanged(new TraceChangeRecord<AbstractDBTraceSymbol, DBTraceReference>(TraceEvents.SYMBOL_ASSOCIATION_ADDED, this.ent.space.space, dbSym, null, this));
        }
    }

    @Override
    public void clearAssociatedSymbol() {
        try (LockHold hold = LockHold.lock((Lock)this.ent.space.lock.writeLock());){
            if (this.ent.symbolId == -1L) {
                return;
            }
            AbstractDBTraceSymbol oldSymbol = this.getTrace().getSymbolManager().getSymbolByID(this.ent.symbolId);
            this.ent.setSymbolId(-1L);
            this.getTrace().setChanged(new TraceChangeRecord<AbstractDBTraceSymbol, Object>(TraceEvents.SYMBOL_ASSOCIATION_REMOVED, this.ent.space.space, oldSymbol, this, null));
        }
    }

    public int hashCode() {
        return this.ent.getX1().hashCode();
    }
}

