/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target.schema;

import ghidra.trace.model.target.schema.PrimitiveTraceObjectSchema;
import ghidra.trace.model.target.schema.SchemaBuilder;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.util.Msg;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedSet;

public class DefaultSchemaContext
implements SchemaContext {
    private final Map<TraceObjectSchema.SchemaName, TraceObjectSchema> schemas = new LinkedHashMap<TraceObjectSchema.SchemaName, TraceObjectSchema>();

    public DefaultSchemaContext() {
        for (PrimitiveTraceObjectSchema schema : PrimitiveTraceObjectSchema.values()) {
            this.schemas.put(schema.getName(), schema);
        }
    }

    public DefaultSchemaContext(SchemaContext ctx) {
        this();
        for (TraceObjectSchema schema : ctx.getAllSchemas()) {
            if (schema instanceof PrimitiveTraceObjectSchema) continue;
            this.builder(schema).buildAndAdd();
        }
    }

    public SchemaBuilder builder(TraceObjectSchema schema) {
        return new SchemaBuilder(this, schema);
    }

    public SchemaBuilder builder(TraceObjectSchema.SchemaName name) {
        return new SchemaBuilder(this, name);
    }

    public SchemaBuilder modify(TraceObjectSchema.SchemaName name) {
        return new SchemaBuilder(this, this.getSchema(name));
    }

    public synchronized void putSchema(TraceObjectSchema schema) {
        if (this.schemas.containsKey(schema.getName())) {
            throw new IllegalArgumentException("Name already in context: " + String.valueOf(schema.getName()));
        }
        this.schemas.put(schema.getName(), schema);
    }

    public synchronized void replaceSchema(TraceObjectSchema schema) {
        this.schemas.put(schema.getName(), schema);
    }

    @Override
    public synchronized TraceObjectSchema getSchemaOrNull(TraceObjectSchema.SchemaName name) {
        return this.schemas.get(name);
    }

    @Override
    public synchronized TraceObjectSchema getSchema(TraceObjectSchema.SchemaName name) {
        TraceObjectSchema schema = this.schemas.get(name);
        if (schema == null) {
            Msg.error((Object)this, (Object)("No such schema name: " + String.valueOf(name)));
            return PrimitiveTraceObjectSchema.ANY;
        }
        return schema;
    }

    @Override
    public synchronized SequencedSet<TraceObjectSchema> getAllSchemas() {
        return Collections.unmodifiableSequencedSet(new LinkedHashSet<TraceObjectSchema>(this.schemas.values()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TraceObjectSchema s : this.schemas.values()) {
            sb.append(String.valueOf(s) + "\n");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultSchemaContext) {
            DefaultSchemaContext that = (DefaultSchemaContext)obj;
            return Objects.equals(this.schemas, that.schemas);
        }
        if (obj instanceof SchemaContext) {
            SchemaContext that = (SchemaContext)obj;
            return this.schemas.values().equals(that.getAllSchemas());
        }
        return false;
    }

    public int hashCode() {
        return this.schemas.hashCode();
    }
}

