## 跨境电商试练 AI，DeepSeek 取代了 ChatGPT

“接下来半年我们会看到 AI 应用在国内的蓬勃发展，DeepSeek 会带来 AI 应用的枝繁叶茂。”聊起 DeepSeek，跨境电商商家钱大柱这样说道。

这样的技术论断来自“外行”的跨境商家并不寻常，背后是 AI 与电商的交织越发紧密。

当 DeepSeek 掀起大模型变革的同时，大模型的能力升级、性价比提升等也在深刻影响着电商行业，创造着“用 DeepSeek 直播一天卖出 3.3 亿”、”电商产品图生成成本从 5000 元降到 2 元”的故事。甚至在大模型“变现”仍未形成商业化闭环的当下，已有电商玩家投入大模型、AI 应用研发的新赛道创业之中。还有人用 AI 实现了带零经验的残疾人赚到跨境第一桶金，“当 AI 在满世界‘放烟花’的时候”，以更接地气的方式在垂直领域试验着技术平权能否重构人力价值。

这是区别于通用大模型在聚光灯下狂飙突进的故事，垂直领域正悄然渐进地将 AI 嵌入肌理，排斥、惊险、惊喜与希望都混杂其中，在这场没有宏大叙事的变革里，每个参与者都在尽可能触摸 AI 应用新的形状。

**一个“含 AI 率”的实验**

“前年开始，我做了一个实验，让四个职高的孩子用 AI 做跨境，跑了一年，他们实现了几百万营收，赚了大几十万。”跨境商家、外贸团长董振国告诉记者，为了这项实验，他给了学生们两个全新的跨境店铺，给他们讲跨境电商的基础逻辑后，就让他们借助 AI 工具去完成选品、产品表达（包含生成产品标题、文字介绍、图片等）、广告投流等运营流程。去年，他还带着几位残疾人以同样的方式开了店，年底分红时他们每人赚到了四五千块钱，“这个过程中他们所有的策略都去问 AI，按 AI 说的照猫画虎填空一样，流量就来了。”

“含 AI 率”因此成为一个指标，董振国发现，过去，一个跨境老手可能需要 20 至 30 天做出一个 95 分的品，AI 参与后，学生们则可以用一周做出 10 个 75 分的品。AI 带来的生产率提升踩中了跨境的“爆品”需求，学生们用 AI 完成大量产品上架，试出“爆品”的可能性也随之增加。最终，他们惊奇地发现，一个产品运营决策过程中的“含 AI 率”越大，出单的概率也相对高。

这之中是垂直领域对通用大模型垂类“说明书”的主动探索。董振国团队最开始用的是 ChatGPT，为了让非电商专业的大模型给出符合电商“老手”的回答，他们做了大量的细分指令，测试不同指令生成的效果，不断打磨，最终形成了针对每个细分需求的指令集供内部使用，才带来了学生们的快速上手。董振国举例，大模型生成的一个商品标题可能才十几字，但为了提高生成质量，他们给出的指令却有上千字。

而随着 DeepSeek 的出现，跨境商家的 AI 探索成本进一步降低。董振国告诉记者，此前 ChatGPT 对商家来说是一笔比较“肉疼”的支出，一个账号要几十美元，他的团队总共有四十多个账号，此外，接口的费用按 token 计费，每月也要几千元人民币。DeepSeek 账号是免费的，token 费用也不过 ChatGPT 的 1/10，在商家应用端能达到同样效果。

“我投资、接触的跨境团队有几百个，有些刚推动它们启用 AI 的时候很抵触，在还赚钱的状态下不愿做改变。但今年年初，不同团队的年会上，这些合伙人都在讲‘今年必须用 AI’。”董振国告诉记者。

跨境从业门槛的大幅下降以及学习模式的“反转”也由此发生。“直到这两天，我才开始给学生们讲这些指令集的背后含义，让他们真正了解跨境行业，方便他们将来有了新的想法，再通过 AI 去实现更多。”董振国表示，当 AI 在满世界“放烟花”的时候，不谈宏伟的愿景，先让 AI 扎扎实实卖出货，让更多人有机会入门、赚到钱，再有动力去知其所以然，是他眼中“技术造福人类”的具象化。

**“钉子”造“锤子”**

除了用好 AI 工具，知道“钉子”在哪里的电商玩家们，还涌动着造“锤子”的热情。

从 2024 年初开始，钱大柱的团队开始尝试自己开发电商作图软件，原因是市面上的文生图大模型大多无法满足电商行业产品细节高度还原、产品 360 度旋转+背景换图+图生视频等需求，他们自己写代码，在开源模型 Stable Diffusion 的基础上训练自己的模型 picballs，实现了可以输入一张产品白底图，AI 就能够生成产品背景图、确保不变形、实现产品在场景中 360 度旋转以及图生视频等功能。

钱大柱组建了二十多人的技术团队，有来自美国、澳大利亚的技术人才线上工作，就为了解决大量跨境中小卖家不愿花钱拍摄图片的痛点。这是一项堪比重新创业的投入项目，人工费用、算力租用成本等十分高昂。钱大柱即将推动 picballs 的商业化面世，预备定价会员费每月 29.8 元，可生成近 20 套图，“原来一套图的业内成本是 5000 元左右，周期是 2 周。现在只需要 5 分钟，成本 2 元。”

![](https://imgcdn.yicai.com/uppics/images/2025/03/ddbcdd7fabb4758b192a5d5b23c8d8f9.jpg)

（钱大柱团队用 picballs 生成的图片）

他相信，随着 DeepSeek 的火爆，这样看准细分需求的 AI 应用会越来越多。“DeepSeek 之前，Picballs 内部用了一年多，可以本地部署，但没办法推出商用，因为一旦上网算力和 API 消耗很贵，生成一张图或视频的成本是 30-50 元甚至更多，必须把成本压缩到更低才能让中小卖家愿意去尝试。”钱大柱表示，他们通过 DeepSeek 本地部署优化自己的大模型，带来的算力成本下降，也大幅降低了 Picballs 的商用成本。

“Deepseek R1 开源满血版本地部署，让国内很多原先在测试在内部使用的 AI 应用瞬间打开枷锁，我估计未来三年 AI 应用开发是一个很有前景的赛道。”钱大柱表示，他相信“跨境运营+技术团队，以后的 AI 应用会越来越商用接地气。”

电商行业中的“大卖”、头部玩家参与 AI 应用开发的野心正不断生长。近日，交个朋友抖音直播间单日销售额突破 3.3 亿元，背后也有 AI 的应用。记者从交个朋友了解到，借助 DeepSeek 大模型，单条口播稿的时间从人工的 20-40 分钟缩短至 AI 生成的 2 分钟，效率提升 10 倍以上，单人力单日输出量从 20 条提升至 100+条，产能提升 5 倍。

交个朋友信息化副总裁刘亚平对第一财经记者表示，交个朋友从 2022 年开始组建“朋友云”平台+AI 研发团队，目前整个研发团队已达 40 人左右，研发投入占集团总成本的 10%，目前使用的是自建的私有云。

接入 DeepSeek 后，刘亚平发现，生成口播稿过于官方、缺乏口语化等问题有所改善，推理成本也相对下降，未来，交个朋友会考虑研发“朋友云”系统的商业化版本对外开放，可面向 MCN 机构、达人直播间、品牌方等。同时，交个朋友还在研发直播零售行业的 AI Agent 智能体，“朋友云”也为交个朋友的海外业务搭建了业务系统和数据平台，用于跨境业务发展。

“整个行业正从“人找货”的传统模式向“货找人”的新模式演进，AI 技术无疑是完成这一跃迁的必要基础设施。”刘亚平表示。

不少电商从业者愿意为这样诞生于行业本身的应用付费。“我直接找大卖，看他们公司内部的 AI 用什么？能不能让我用？我们做广告投放接入的 AI 接口就是一家年交易额 70 亿左右的上市公司，他们管几十万个产品，自己做了 AI 系统后，广告部从几百个人减到十来个人，还是管着公司几千家店。那我交点钱，用他们的技术，也就有了人家的投放经验。”董振国告诉记者，他按照销售额百分之几的提成给该公司的应用付费，一个月的支出大概是 1 万五到两万，但能驱动出四五十万的交易额，觉得挺值。

科技公司的大模型、AI 应用开足马力冲向电商的同时，电商领域也在开启一场反向跑。他们需要面对开源大模型技术迅速迭代、不断免费覆盖细分需求的高变现风险，也在为电商行业留下更多独特火苗。

**踏入 AI 的河**

当电商领域走入 AI 深处，一个行业与 AI 交融的样本足以带来许多思考。

一个现实是，在电商行业的大部分场景下，目前的 AI 使用仍更多是为了降本增效。一位公司年销售额超过 5 亿美元的广州跨境大卖告诉记者，目前他的公司 AI 应用仍比较窄，通常用于产品图片的主色改复色，产品换背景图，但对于产品生活化的呈现不够，很难取代真人拍摄的质量。目前，在服装设计上，AI 也多用于系列款的设计演变参考，设计师会通过 AI 来多多延展风格和设计，从中找到一些新的趋势和灵感，但是无法直接使用，只能作为一些灵感的补充。如何挖掘 AI 的创造力，对行业的大多数玩家来说仍是挑战。

显然，AI 与无数普通人的连接仍是一项漫长课题。

“主播的 AI 培训其实不难。如果只是简单使用，1~2 天就能上手。但如果想让 AI 的回答更贴合产品需求，比如写‘售卖水晶的直播话术’，就需要更精准的提问，比如‘针对 25~35 岁职场女性，客单价 199~399 元的水晶手串，如何引发共鸣、提高成交量？’这种问题就需要时间去琢磨。”刘亚平提到，AI 与人的结合仍在路上。

他告诉记者，一开始，主播可能会抗拒，觉得 AI 没法替代人的“温度”。交个朋友会通过“人机协作”试点，比如让 AI 先出脚本初稿，主播再润色，让他们看到效率和质量的提升。同时在内部开 AI 培训课，提升大家对技术的认知，用对方法，让大家慢慢接受。

上述广州跨境大卖也告诉记者，目前，他的公司的 AI 培训主要是对中层的少部分主管进行内部交流和培训，再由主管对团队进行赋能，尚未引入外部的培训资源，因为市面上能针对性地做服装和海外市场的 AI 培训还比较少。董振国则提到，短视频平台的许多“AI 培训”相当“速成”，实际削弱着人们对 AI 行业应用的思考和认知，带一些人“走弯路”。

再往前一步，AI 会如何改变人？董振国回想起学生们整整两年不知道 AI 指令背后逻辑的时期，“当他强度使用 AI 后，他相当于一个搬砖的角色，这段工作对他的人生来说只停留在了表层需求。”他认为，将来人们总要面临一个思考：人类的思考如何不被 AI 豢养？

“去开拓。”这是这个行业在当下最朴实的回答。AI 可能带来的跨境门槛放低、竞争加剧面前，董振国聊起他的团队在 AI“创品”中的尝试。在梳理、总结电商平台大量“爆品”类别、标题、评论等基础后，他们基于 AI 生成了一个“未来爆品”的新品开发报告，交由工厂生产，上市三周在美国市场卖出了三十多万美元。除此之外，在 AI 的助力下，他去到了原本并未计划的日本、南美市场。在 AI 与各行各业的碰撞带来兴奋或紧张之下，AI 和人总要互相引领着，去不曾到过的地方。

> 来源：第一财经
