# 完整攻略：如何用好DeepSeek，一文汇总！

本文从DeepSeek的独特优势出发，全面分享了DeepSeek的使用方法，包括：扔掉提示词模板的正确方式、让其 “说人话” 的方法、深度思考技能、强大文风转换器运用，以及使用禁区。

《DeepSeek使用攻略》如下：

*注：本文所有技巧均来自真实案例，所有提示词都经过反复验证。*

## 一、最重要的秘密：扔掉你的提示词模板

如果你还在用各种"专业提示词"和"模板"，那就是走错了方向。

**DeepSeek根本不吃这一套。**

为什么？

因为它的核心是**推理型**大模型，不是**指令型**大模型。

这就像两个实习生：

- 一个小书呆子，需要你事无巨细地安排任务步骤。（指令型）
- 一个小机灵鬼，只要你说明目的，他就能自己思考怎么做。（推理型）

让我用一个真实案例来说明，

我们社群一位运营同学的实测，进行新能源行业分析，用于准备与比亚迪供应商谈判。

**传统方式：**

```
请你扮演一位新能源行业分析师，按照以下步骤分析：
1. 市场规模
2. 竞争格局
3. 技术路线
4. 未来趋势
要求：每部分800字，引用权威数据...
```

结果：得到一份干巴巴的报告，一眼AI。

![图片](https://pic.yupi.icu/yuyi/640)一眼AI，除了正确毛用没有。

**正确方式：**

```
我下周要和比亚迪的供应商谈判，但对动力电池一窍不通。帮我用最通俗的语言说明：
1. 他们的技术优势在哪
2. 可能要价多少
3. 有什么谈判时能用的专业术语
重点是让我听得懂，能装得像内行
```

结果：DeepSeek直接给出接地气的分析，还附带谈判话术。

![图片](https://pic.yupi.icu/yuyi/640-20250220163516065)

**这就是最大的区别：**

DeepSeek不需要你写"专业提示词"，

它需要的是**真实场景**和**具体需求**。

**送您一个通用公式：**

> 我要xx，要给xx用，希望达到xx效果，但担心xx问题...

就像你跟一个聪明的下属说话：

- 不要说"请按照STAR法则写周报"
- 而要说：

> 我要写周报，老板周一要看，希望重点放在xxx上，重点是让咱们部门在老板面前能达到装逼效果，力压隔壁研发部，但担心研发质疑我们产品文档写得不够详细……"

## **二、最被低估的功能：让它"说人话"**

很多人抱怨DeepSeek的回复太抽象，像是在读天书。

![图片](https://pic.yupi.icu/yuyi/640-20250220170404398)

但你可能不知道，只要一个简单的提示词，就能彻底改变这个问题。

这个神奇的提示词是：

> **说人话。**

没错，就这三个字。

我的学员第一次试时还不信，结果...

*原始回答：*

![图片](https://pic.yupi.icu/yuyi/640-20250220170404505)

*加上"说人话"后的回答：*

![图片](https://pic.yupi.icu/yuyi/640-20250220170404605)

**瞬间就接地气了，对吧？**

因为deepseek对“说人话”这个词语很敏感。

![图片](https://pic.yupi.icu/yuyi/640-20250220170404682)

当然，有时候这三个字不够用，还可以用这个详尽版提示词，直接复制过去即可：

```
【请用以下规范输出：1.语言平实直述，避免抽象隐喻；2.使用日常场景化案例辅助说明；3.优先选择具体名词替代抽象概念；4.保持段落简明（不超过5行）；5.技术表述需附通俗解释；6.禁用文学化修辞；7.重点信息前置；8.复杂内容分点说明；9.保持口语化但不过度简化专业内容；10.确保信息准确前提下优先选择大众认知词汇】
```

## **三、最强大的技能：深度思考** 

这是我不得不说的事:

**一个免费的国产AI，正在让月付200美金的GPT-o1坐不住了。**

为什么？

因为DeepSeek的思维方式，比GPT-o1更智慧。

让我用一个真实案例来对比：

*GPT-o1的回答：*

![图片](https://pic.yupi.icu/yuyi/640-20250220170517819)

*DeepSeek的回答：*

![图片](https://pic.yupi.icu/yuyi/640-20250220170517879)

**这就是最大的区别：**

- GPT-o1线性罗列，像个高级文档工具
- DeepSeek深度思考，像个思考伙伴

免费的DeepSeek，直接让整个硅谷AI公司的牛马连夜加班，

幸亏他们不用过春节。

但最近，我发现一个现象：

由于用户暴增，DeepSeek明显调整了响应策略：

- 思考时间从20秒降到5秒
- 回答深度明显下降
- 反思能力受限

![图片](https://pic.yupi.icu/yuyi/640-20250220170517911)

这是可以理解的临时措施，毕竟算力就是烧钱。

但对于我们用户来说，如何继续激发它的深度思考能力？

我整理了三个核心提示词，为了装逼，称为**深度思考三件套**：

> 1. 请在你的思考分析过程中同时*进行批判性思考*至少10轮，务必详尽
> 2. 请在你的思考分析过程中同时*从反面考虑你的回答*至少10轮，务必详尽
> 3. 请在你的思考分析过程中同时*对你的回答进行复盘*至少10轮，务必详尽

如此一来，深度思考将从5秒恢复为20秒左右。

斜体的部分，可以自由替换成你所擅长的形式，也可以组合叠加，

但核心是**反思**。

![图片](https://pic.yupi.icu/yuyi/640-20250220170517968)

## **四、最强大的文风转换器** 

昨天,我用DeepSeek，写了一篇汉赋。

赞扬一下王星有情有义、智勇双全的女友。王星就是前阵子被卖到缅北的演员。

![图片](https://pic.yupi.icu/yuyi/640-20250220170518017)

这用典，这骈文，真的没谁了。

发在群里后,直接炸出了三个语文老师...

![图片](https://pic.yupi.icu/yuyi/640-20250220170518060)

还有的朋友，写出的文字连专业编剧都说老到。

![图片](https://pic.yupi.icu/yuyi/640-20250220170518119)

![图片](https://pic.yupi.icu/yuyi/640-20250220170518162)

事实上,这正是DeepSeek的第四个秘密武器:**文风转换器**

提示词很简单，哪怕口述就行：

> 模仿xxx的文风，撰写关于xxxxx的一篇xx文体。

**但要注意两点局限：**

一方面，它更适合模仿经典作家，因为训练数据充足，风格特征明显。

另一方面，不要期待100%还原，80%相似度已经很厉害，重点是能抓住神韵。

我觉得deepseek肯定是训练了大量的文学语料，尤其是中国古典文学。

比如鲁迅、莫言，都是惟妙惟肖。

![图片](https://pic.yupi.icu/yuyi/640-20250220170518231)

**记住那个万能公式：**

> 我要xx，要给xx用，希望达到xx效果，但担心xx问题...

例如：

> 我要写一篇关于赞颂王星女友机智勇敢用心的赋，用来小红书上面炫技，希望重点放在模仿王勃的篇文上，重点是让我本人的文采装逼，在小红书获得一个亿的赞，但担心别人看不懂太晦涩了……"

类似的风格迁移，也可以放在当代作家上，比如我们模仿刘润老师的跨年演讲：

![图片](https://pic.yupi.icu/yuyi/640-20250220170518291)

注意要先提供内容原文（尽量详尽，一般不少于8000字），然后直接要求其模仿即可。

![图片](https://pic.yupi.icu/yuyi/640-20250220170518338)

当然，为了更好的效果，最好用上**万能公式**。

## **五、使用禁区：什么情况不要用它** 

说了这么多优点，也必须说说它的局限性。

**以下场景不建议使用DeepSeek：**

### 1. 长文本写作

超过4000字的文章容易出现逻辑断裂，建议用Claude200k。

因为deepseek默认是64k，长文不够用。

![图片](https://pic.yupi.icu/yuyi/640-20250220170518364)

### 2. 敏感内容

毕竟是国产AI，内置审核尺度丧心病狂。

![图片](https://pic.yupi.icu/yuyi/640-20250220170518405)

很多时候你不知道哪句话就触发审核了。

这种情况怎么解决呢？

因为deepseek是后置审核，所以有以下三种方案：

1.在你的提问处点击修改，再提交几次，总有一次是不触发审核的。

![图片](https://pic.yupi.icu/yuyi/640-20250220170518444)

2.在生成回答的时候，狂点复制回答按钮。这样确保触发审核的时候，你的剪贴板上面拥有前面回答的内容

![图片](https://pic.yupi.icu/yuyi/640-20250220170518482)

3.一劳永逸，换御三家。（GPT，claude，gemini）

### 3.个人风格写作

这个就不赘述了，这是个推理模型，适合解决问题、模仿。

但很难通过精确控制来确保你想要的风格写作效果。

这其实不算deepseek的缺点，只能算**特性**。

具体的，我下一篇再来论述吧。



> 来源：https://mp.weixin.qq.com/s?__biz=MzIyNjM2MzQyNg==&mid=2247699782&idx=1&sn=04a0f3d4b6af83c38ca9afaf24c3edd6&chksm=e92df03eff0422ad2bded8ccd79ceab7132ae39c457ce4f7f0054dce6f260c156a99ddb6881f&scene=0&xtrack=1