# 论文组图工具 v2.0 - 更新亮点

## 🎯 核心新功能

### 1️⃣ 快捷自定义布局 ⭐⭐⭐⭐⭐
**彻底告别手动输入！**

- 🖱️ **纯鼠标操作**：无需输入×、[]等符号
- 📐 **规则网格**：点击调整行数×列数（1-10）
- 🎨 **不规则布局**：每行列数独立设置，自动居中
- ❓ **内置帮助**：点击帮助按钮查看详细示例

**示例**：5个图上3下2 → 选择"快捷自定义" → 不规则布局 → 2行 → 第1行3个，第2行2个 → 完成！

### 2️⃣ 子图宽高比统一调整 ⭐⭐⭐⭐⭐
**一键统一所有子图比例！**

- 📏 **7种预设**：正方形、4:3、16:9、3:4、9:16等
- ✏️ **自定义比例**：输入任意宽高值
- 🤖 **自动优化**：画布高度自动调整，布局紧凑美观
- 🎭 **智能禁用**：自定义模式下自动禁用（避免冲突）

**效果**：选择1:1后，所有框立即变正方形，画布高度自动调整，无空白！

### 3️⃣ 重大BUG修复 🔥
- ✅ 导入图片不再破坏布局
- ✅ 画布和预览完全同步显示
- ✅ 所有修改实时反映到预览
- ✅ 启动无错误信息

## 📸 功能演示

### 快捷自定义 - 不规则布局
```
5张图，上3下2居中：
┌─────────────────────────┐
│  □  □  □               │
│    □  □                │ <- 自动居中
└─────────────────────────┘
所有框完全一样大！
```

### 宽高比调整
```
设置1:1前（自动）：        设置1:1后（正方形）：
┌──────────────┐          ┌──────────────┐
│ □□□         │          │ ▢▢▢         │
│             │          │ ▢▢          │
│  □□         │          └──────────────┘
│             │          高度自动优化！
└──────────────┘
```

## 🚀 快速开始

```bash
# 安装依赖
pip install PySide6 Pillow

# 运行程序
python Figure_paper.py
```

## 📋 完整功能

### 布局方式
- ✅ 6种预定义模板（2×2、3×2、1+2等）
- ✅ **快捷自定义**（新！纯鼠标操作）
- ✅ 完全自定义模式（自由拖拽）

### 图片处理
- ✅ 拖拽导入/排序
- ✅ 3种适配模式
- ✅ **子图宽高比调整**（新！）
- ✅ 图片取景编辑（平移/缩放）

### 标注系统
- ✅ (a)(b)(c)自动标注
- ✅ 多种位置/颜色/样式
- ✅ 单个子图独立设置
- ✅ 子图边框自定义

### 导出选项
- ✅ PNG/JPEG/TIFF格式
- ✅ 300/600/900 DPI
- ✅ 自定义尺寸（mm）

## 🎨 使用场景

### 标准论文排图
1. 选择"快捷自定义" - [3,2]布局
2. 设置宽高比1:1（正方形）
3. 导入图片 → 自动完美排列
4. 调整标注、间距
5. 导出600DPI PNG

### 创意自由布局
1. 选择"自定义模式"
2. 手动拖拽调整每个框
3. 使用对齐、分布工具
4. 双击编辑图片取景
5. 导出

## 🔄 版本对比

| 功能 | v1.x | v2.0 |
|------|------|------|
| 自定义布局 | 手动输入"2x2"、"[3,2]" | 🖱️ 鼠标点击调整 |
| 子图比例 | 固定 | 🎚️ 7种预设+自定义 |
| 布局稳定性 | 导入图片会重建 | ✅ 智能更新不重建 |
| 实时预览 | 需手动刷新 | ✅ 自动同步 |
| 画布显示 | 有时不显示图片 | ✅ 完美同步 |
| 不规则布局 | 框大小不一致 | ✅ 完全统一 |

## 📖 详细文档

- [完整更新日志](CHANGELOG_v2.0.md)
- [常见问题](FAQ.md)（如有）
- [使用教程](TUTORIAL.md)（如有）

## 🐛 已知问题

目前没有已知的重大问题。如有疑问，请提Issue！

## 🙏 反馈与建议

欢迎在GitHub Issues中：
- 🐛 报告BUG
- 💡 提出新功能建议
- 📖 改进文档
- ⭐ 给项目加星！

---

**最新版本**: v2.0  
**发布日期**: 2026-01-14  
**license**: MIT（或您的许可证）
