/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.alter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddForeignKeyChange;
import org.jumpmind.db.alter.AddIndexChange;
import org.jumpmind.db.alter.AddPrimaryKeyChange;
import org.jumpmind.db.alter.AddTableChange;
import org.jumpmind.db.alter.ColumnAutoIncrementChange;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.ColumnDefaultValueChange;
import org.jumpmind.db.alter.ColumnGeneratedChange;
import org.jumpmind.db.alter.ColumnRequiredChange;
import org.jumpmind.db.alter.ColumnSizeChange;
import org.jumpmind.db.alter.GeneratedColumnDefinitionChange;
import org.jumpmind.db.alter.IModelChange;
import org.jumpmind.db.alter.PrimaryKeyChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.RemoveForeignKeyChange;
import org.jumpmind.db.alter.RemoveIndexChange;
import org.jumpmind.db.alter.RemovePrimaryKeyChange;
import org.jumpmind.db.alter.RemoveTableChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDdlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelComparator {
    private final Logger log = LoggerFactory.getLogger(ModelComparator.class);
    protected DatabaseInfo platformInfo;
    protected boolean caseSensitive;
    protected IDdlBuilder ddlBuilder;

    public ModelComparator(IDdlBuilder ddlBuilder, DatabaseInfo platformInfo, boolean caseSensitive) {
        this.ddlBuilder = ddlBuilder;
        this.platformInfo = platformInfo;
        this.caseSensitive = caseSensitive;
    }

    public List<IModelChange> compare(Database sourceModel, Database targetModel) {
        int fkIdx;
        int tableIdx;
        ArrayList<IModelChange> changes = new ArrayList<IModelChange>();
        for (tableIdx = 0; tableIdx < targetModel.getTableCount(); ++tableIdx) {
            Table targetTable = targetModel.getTable(tableIdx);
            Table sourceTable = sourceModel.findTable(targetTable.getName(), this.caseSensitive);
            if (sourceTable == null) {
                this.log.debug("Table {} needs to be added", (Object)targetTable.getName());
                changes.add(new AddTableChange(targetTable));
                if (!this.platformInfo.isForeignKeysSupported()) continue;
                for (fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
                    changes.add(new AddForeignKeyChange(targetTable, targetTable.getForeignKey(fkIdx)));
                }
                continue;
            }
            changes.addAll(this.compareTables(sourceModel, sourceTable, targetModel, targetTable));
        }
        for (tableIdx = 0; tableIdx < sourceModel.getTableCount(); ++tableIdx) {
            Table sourceTable = sourceModel.getTable(tableIdx);
            Table targetTable = targetModel.findTable(sourceTable.getName(), this.caseSensitive);
            if (targetTable != null || sourceTable.getName() == null || sourceTable.getName().length() <= 0) continue;
            this.log.debug("Table {} needs to be removed", (Object)sourceTable.getName());
            changes.add(new RemoveTableChange(sourceTable));
            if (!this.platformInfo.isForeignKeysSupported()) continue;
            for (fkIdx = 0; fkIdx < sourceTable.getForeignKeyCount(); ++fkIdx) {
                changes.add(new RemoveForeignKeyChange(sourceTable, sourceTable.getForeignKey(fkIdx)));
            }
        }
        return changes;
    }

    public List<IModelChange> compareTables(Database sourceModel, Table sourceTable, Database targetModel, Table targetTable) {
        AddColumnChange change;
        Column targetColumn;
        int columnIdx;
        ArrayList<IModelChange> changes = new ArrayList<IModelChange>();
        if (this.platformInfo.isForeignKeysSupported()) {
            int fkIdx;
            for (fkIdx = 0; fkIdx < sourceTable.getForeignKeyCount(); ++fkIdx) {
                ForeignKey sourceFk = sourceTable.getForeignKey(fkIdx);
                ForeignKey targetFk = this.findCorrespondingForeignKey(targetTable, sourceFk);
                if (targetFk != null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug(sourceFk + " needs to be removed from table " + sourceTable.getName());
                }
                changes.add(new RemoveForeignKeyChange(sourceTable, sourceFk));
            }
            for (fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
                ForeignKey targetFk = targetTable.getForeignKey(fkIdx);
                ForeignKey sourceFk = this.findCorrespondingForeignKey(sourceTable, targetFk);
                if (sourceFk != null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug(targetFk + " needs to be created for table " + sourceTable.getName());
                }
                changes.add(new AddForeignKeyChange(targetTable, targetFk));
            }
        }
        if (this.platformInfo.isIndicesSupported()) {
            int indexIdx;
            for (indexIdx = 0; indexIdx < sourceTable.getIndexCount(); ++indexIdx) {
                IIndex sourceIndex = sourceTable.getIndex(indexIdx);
                IIndex targetIndex = this.findCorrespondingIndex(targetTable, sourceIndex);
                if (targetIndex != null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Index " + sourceIndex.getName() + " needs to be removed from table " + sourceTable.getName());
                }
                changes.add(new RemoveIndexChange(sourceTable, sourceIndex));
            }
            for (indexIdx = 0; indexIdx < targetTable.getIndexCount(); ++indexIdx) {
                IIndex targetIndex = targetTable.getIndex(indexIdx);
                IIndex sourceIndex = this.findCorrespondingIndex(sourceTable, targetIndex);
                if (sourceIndex != null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Index " + targetIndex.getName() + " needs to be created for table " + sourceTable.getName());
                }
                changes.add(new AddIndexChange(targetTable, targetIndex));
            }
        }
        HashMap<Column, AddColumnChange> addColumnChanges = new HashMap<Column, AddColumnChange>();
        for (columnIdx = 0; columnIdx < targetTable.getColumnCount(); ++columnIdx) {
            targetColumn = targetTable.getColumn(columnIdx);
            Column sourceColumn = sourceTable.findColumn(targetColumn.getName(), this.caseSensitive);
            if (sourceColumn == null) {
                this.log.debug("Column {} needs to be created for table {}", new Object[]{targetColumn.getName(), sourceTable.getName()});
                AddColumnChange change2 = new AddColumnChange(sourceTable, targetColumn, columnIdx > 0 ? targetTable.getColumn(columnIdx - 1) : null, columnIdx < targetTable.getColumnCount() - 1 ? targetTable.getColumn(columnIdx + 1) : null);
                changes.add(change2);
                addColumnChanges.put(targetColumn, change2);
                continue;
            }
            changes.addAll(this.compareColumns(sourceTable, sourceColumn, targetTable, targetColumn));
        }
        for (columnIdx = targetTable.getColumnCount() - 1; columnIdx >= 0 && (change = (AddColumnChange)addColumnChanges.get(targetColumn = targetTable.getColumn(columnIdx))) != null; --columnIdx) {
            change.setAtEnd(true);
        }
        Column[] sourcePK = sourceTable.getPrimaryKeyColumnsInIndexOrder();
        Column[] targetPK = targetTable.getPrimaryKeyColumnsInIndexOrder();
        if (sourcePK.length == 0 && targetPK.length > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("A primary key needs to be added to the table " + sourceTable.getName());
            }
            changes.add(new AddPrimaryKeyChange(targetTable, targetPK));
        } else if (targetPK.length == 0 && sourcePK.length > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The primary key needs to be removed from the table " + sourceTable.getName());
            }
            changes.add(new RemovePrimaryKeyChange(sourceTable, sourcePK));
        } else if (sourcePK.length > 0 && targetPK.length > 0) {
            boolean changePK = false;
            if (sourcePK.length != targetPK.length) {
                changePK = true;
            } else {
                for (int pkColumnIdx = 0; pkColumnIdx < sourcePK.length && !changePK; ++pkColumnIdx) {
                    if ((!this.caseSensitive || sourcePK[pkColumnIdx].getName().equals(targetPK[pkColumnIdx].getName())) && (this.caseSensitive || sourcePK[pkColumnIdx].getName().equalsIgnoreCase(targetPK[pkColumnIdx].getName()))) continue;
                    changePK = true;
                }
            }
            if (changePK) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("The primary key of table " + sourceTable.getName() + " needs to be changed");
                }
                changes.add(new PrimaryKeyChange(sourceTable, sourcePK, targetPK));
            }
        }
        for (int columnIdx2 = 0; columnIdx2 < sourceTable.getColumnCount(); ++columnIdx2) {
            Column sourceColumn = sourceTable.getColumn(columnIdx2);
            Column targetColumn2 = targetTable.findColumn(sourceColumn.getName(), this.caseSensitive);
            if (targetColumn2 != null) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Column " + sourceColumn.getName() + " needs to be removed from table " + sourceTable.getName());
            }
            changes.add(new RemoveColumnChange(sourceTable, sourceColumn));
        }
        return changes;
    }

    public List<TableChange> compareColumns(Table sourceTable, Column sourceColumn, Table targetTable, Column targetColumn) {
        boolean compatible;
        ArrayList<TableChange> changes = new ArrayList<TableChange>();
        int actualTypeCode = sourceColumn.getMappedTypeCode();
        int desiredTypeCode = targetColumn.getMappedTypeCode();
        boolean sizeMatters = this.platformInfo.hasSize(targetColumn.getMappedTypeCode());
        boolean scaleMatters = this.platformInfo.hasPrecisionAndScale(targetColumn.getMappedTypeCode());
        boolean bl = compatible = !(actualTypeCode != 2 && actualTypeCode != 3 || desiredTypeCode != 4 && desiredTypeCode != -5);
        if (sourceColumn.isAutoIncrement() && targetColumn.isAutoIncrement() && (desiredTypeCode == 2 || desiredTypeCode == 3) && (actualTypeCode == 4 || actualTypeCode == -5)) {
            compatible = true;
            sizeMatters = false;
            scaleMatters = false;
        }
        if (sourceColumn.getMappedTypeCode() == 2004 && targetColumn.getMappedTypeCode() == -1) {
            compatible = true;
        }
        if (!compatible && !this.ddlBuilder.areMappedTypesTheSame(sourceColumn, targetColumn) && this.platformInfo.getTargetJdbcType(targetColumn.getMappedTypeCode()) != this.platformInfo.getTargetJdbcType(sourceColumn.getMappedTypeCode())) {
            this.log.debug("The {} column on the {} table changed type codes from {} to {} ", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.getMappedTypeCode(), targetColumn.getMappedTypeCode()});
            changes.add(new ColumnDataTypeChange(sourceTable, sourceColumn, targetColumn.getMappedTypeCode()));
        }
        if (!this.ddlBuilder.areColumnSizesTheSame(sourceColumn, targetColumn)) {
            if (sizeMatters) {
                int targetSize = targetColumn.getSizeAsInt();
                if (targetColumn.getSize() == null) {
                    Integer defaultSize = this.platformInfo.getDefaultSize(this.platformInfo.getTargetJdbcType(targetColumn.getMappedTypeCode()));
                    targetSize = defaultSize != null ? defaultSize : 0;
                }
                this.log.debug("The {} column on the {} table changed size from ({}) to ({})", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.getSizeAsInt(), targetSize});
                changes.add(new ColumnSizeChange(sourceTable, sourceColumn, targetSize, targetColumn.getScale()));
            } else if (scaleMatters) {
                this.log.debug("The {} column on the {} table changed scale from ({},{}) to ({},{})", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.getSizeAsInt(), sourceColumn.getScale(), targetColumn.getSizeAsInt(), targetColumn.getScale()});
                changes.add(new ColumnSizeChange(sourceTable, sourceColumn, targetColumn.getSizeAsInt(), targetColumn.getScale()));
            }
        }
        if (!this.defaultValuesAreEqual(sourceColumn, targetColumn)) {
            this.log.debug("The {} column on the {} table changed default value from {} to {} ", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.getDefaultValue(), targetColumn.getDefaultValue()});
            changes.add(new ColumnDefaultValueChange(sourceTable, sourceColumn, targetColumn.getDefaultValue()));
        }
        if (!targetColumn.isGenerated() && sourceColumn.isRequired() != targetColumn.isRequired()) {
            this.log.debug("The {} column on the {} table changed required status from {} to {}", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.isRequired(), targetColumn.isRequired()});
            changes.add(new ColumnRequiredChange(sourceTable, sourceColumn));
        }
        if (sourceColumn.isAutoIncrement() != targetColumn.isAutoIncrement()) {
            this.log.debug("The {} column on the {} table changed auto increment status from {} to {} ", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.isAutoIncrement(), targetColumn.isAutoIncrement()});
            changes.add(new ColumnAutoIncrementChange(sourceTable, sourceColumn));
        }
        if (sourceColumn.isGenerated() != targetColumn.isGenerated()) {
            this.log.debug("The {} column on the {} table changed generated status from {} to {} ", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.isGenerated(), targetColumn.isGenerated()});
            changes.add(new ColumnGeneratedChange(sourceTable, sourceColumn, targetColumn.getDefaultValue()));
        } else if (Boolean.valueOf(System.getProperty("compare.generated.column.definitions", "true")).booleanValue() && sourceColumn.isGenerated() && sourceColumn.getDefaultValue() != null && !sourceColumn.getDefaultValue().equals(targetColumn.getDefaultValue())) {
            this.log.debug("The {} generated column on the {} table changed definition from {} to {} ", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.getDefaultValue(), targetColumn.getDefaultValue()});
            changes.add(new GeneratedColumnDefinitionChange(sourceTable, sourceColumn, targetColumn.getDefaultValue()));
        }
        return changes;
    }

    private ForeignKey findCorrespondingForeignKey(Table table, ForeignKey fk) {
        for (int fkIdx = 0; fkIdx < table.getForeignKeyCount(); ++fkIdx) {
            ForeignKey curFk = table.getForeignKey(fkIdx);
            if ((!this.caseSensitive || !fk.equals(curFk)) && (this.caseSensitive || !fk.equalsIgnoreCase(curFk))) continue;
            return curFk;
        }
        return null;
    }

    private IIndex findCorrespondingIndex(Table table, IIndex index) {
        for (int indexIdx = 0; indexIdx < table.getIndexCount(); ++indexIdx) {
            IIndex curIndex = table.getIndex(indexIdx);
            if ((!this.caseSensitive || !index.equals(curIndex)) && (this.caseSensitive || !index.equalsIgnoreCase(curIndex))) continue;
            return curIndex;
        }
        return null;
    }

    private boolean defaultValuesAreEqual(Column sourceColumn, Column targetColumn) {
        Object sourceDefaultValue = sourceColumn.getParsedDefaultValue();
        Object targetDefaultValue = targetColumn.getParsedDefaultValue();
        if (!(targetColumn.isGenerated() || sourceDefaultValue == null && targetDefaultValue == null)) {
            String targetDefaultValueString;
            String sourceDefaultValueString;
            boolean isBigDecimal;
            if (sourceDefaultValue == null && targetDefaultValue != null || sourceDefaultValue != null && targetDefaultValue == null) {
                return false;
            }
            boolean bl = isBigDecimal = sourceDefaultValue instanceof BigDecimal && targetDefaultValue instanceof BigDecimal;
            if (isBigDecimal && ((BigDecimal)sourceDefaultValue).compareTo((BigDecimal)targetDefaultValue) != 0) {
                return false;
            }
            if (!isBigDecimal && !(sourceDefaultValueString = sourceDefaultValue.toString()).equals(targetDefaultValueString = this.ddlBuilder.mapDefaultValue(targetDefaultValue, targetColumn).toString())) {
                int typeCode = targetColumn.getMappedTypeCode();
                if (typeCode == 93 || typeCode == -101 || typeCode == -102) {
                    if (targetColumn.anyPlatformColumnNameContains("mysql") || targetColumn.anyPlatformColumnNameContains("maria")) {
                        while (targetDefaultValueString.startsWith("(") && targetDefaultValueString.endsWith(")")) {
                            targetDefaultValueString = targetDefaultValueString.substring(1, targetDefaultValueString.length() - 1);
                        }
                    }
                    if (targetColumn.anyPlatformColumnNameContains("postgres")) {
                        sourceDefaultValueString = sourceDefaultValueString.replace("::text", "");
                    }
                    return sourceDefaultValueString.equalsIgnoreCase(targetDefaultValueString);
                }
                return false;
            }
        }
        return true;
    }
}

