/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.ModelException;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Database
implements Serializable,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(Database.class);
    private static final long serialVersionUID = 1L;
    private String name;
    private String catalog;
    private String schema;
    private String idMethod;
    private String version;
    private ArrayList<Table> tables = new ArrayList();
    private Map<String, Integer> tableIndexCache = new HashMap<String, Integer>();

    public static List<Table> sortByForeignKeys(List<Table> tables, Map<String, Table> allTables, Map<Integer, Set<Table>> dependencyMap, Map<Table, Set<String>> missingDependencyMap) {
        if (allTables == null) {
            allTables = new HashMap<String, Table>();
            for (Table t : tables) {
                allTables.put(t.getName(), t);
            }
        }
        if (dependencyMap == null) {
            dependencyMap = new HashMap<Integer, Set<Table>>();
        }
        if (missingDependencyMap == null) {
            missingDependencyMap = new HashMap<Table, Set<String>>();
        }
        HashSet<Table> resolved = new HashSet<Table>();
        HashSet<Table> temporary = new HashSet<Table>();
        ArrayList<Table> finalList = new ArrayList<Table>();
        MutableInt depth = new MutableInt(1);
        MutableInt position = new MutableInt(1);
        MutableInt parentPosition = new MutableInt(-1);
        HashMap<Table, Integer> resolvedPosition = new HashMap<Table, Integer>();
        for (Table t : tables) {
            if (t == null) continue;
            depth.setValue(1);
            parentPosition.setValue(-1);
            Database.resolveForeignKeyOrder(t, allTables, resolved, temporary, finalList, null, missingDependencyMap, dependencyMap, depth, position, resolvedPosition, parentPosition);
        }
        Collections.reverse(finalList);
        return finalList;
    }

    public static void logMissingDependentTableNames(List<Table> tables) {
        Map<String, List<String>> missingTablesByChildTable = Database.findMissingDependentTableNames(tables);
        for (String childTableName : missingTablesByChildTable.keySet()) {
            List<String> missingTables = missingTablesByChildTable.get(childTableName);
            StringBuilder dependentTables = new StringBuilder();
            for (String missingTableName : missingTables) {
                if (dependentTables.length() > 0) {
                    dependentTables.append(", ");
                }
                dependentTables.append(missingTableName);
            }
            log.info("Unable to resolve foreign keys for table " + childTableName + " because the following dependent tables were not included [" + dependentTables.toString() + "].");
        }
    }

    public static Map<String, List<String>> findMissingDependentTableNames(List<Table> tables) {
        HashMap<String, List<String>> missingTablesByChildTable = new HashMap<String, List<String>>();
        HashMap<String, Table> allTables = new HashMap<String, Table>();
        for (Table t : tables) {
            allTables.put(t.getName(), t);
        }
        for (Table table : tables) {
            ArrayList<String> missingTables = (ArrayList<String>)missingTablesByChildTable.get(table.getName());
            for (ForeignKey fk : table.getForeignKeys()) {
                if (allTables.get(fk.getForeignTableName()) != null) continue;
                if (missingTables == null) {
                    missingTables = new ArrayList<String>();
                    missingTablesByChildTable.put(table.getName(), missingTables);
                }
                missingTables.add(fk.getForeignTableName());
            }
        }
        return missingTablesByChildTable;
    }

    public static void resolveForeignKeyOrder(Table t, Map<String, Table> allTables, Set<Table> resolved, Set<Table> temporary, List<Table> finalList, Table parentTable, Map<Table, Set<String>> missingDependencyMap, Map<Integer, Set<Table>> dependencyMap, MutableInt depth, MutableInt position, Map<Table, Integer> resolvedPosition, MutableInt parentPosition) {
        if (resolved.contains(t)) {
            parentPosition.setValue((Number)resolvedPosition.get(t));
            return;
        }
        if (!temporary.contains(t) && !resolved.contains(t)) {
            HashSet<Integer> parentTablesChannels = new HashSet<Integer>();
            if (t == null) {
                if (parentTable != null) {
                    for (ForeignKey fk : parentTable.getForeignKeys()) {
                        if (allTables.get(fk.getForeignTableName()) != null) continue;
                        if (missingDependencyMap.get(parentTable) == null) {
                            missingDependencyMap.put(parentTable, new HashSet());
                        }
                        missingDependencyMap.get(parentTable).add(fk.getForeignTableName());
                    }
                }
            } else {
                temporary.add(t);
                for (ForeignKey fk : t.getForeignKeys()) {
                    Table fkTable = allTables.get(fk.getForeignTableName());
                    if (fkTable == t) continue;
                    depth.increment();
                    Database.resolveForeignKeyOrder(fkTable, allTables, resolved, temporary, finalList, t, missingDependencyMap, dependencyMap, depth, position, resolvedPosition, parentPosition);
                    Integer resolvedParentTableChannel = resolvedPosition.get(fkTable);
                    if (resolvedParentTableChannel == null) continue;
                    parentTablesChannels.add(resolvedParentTableChannel);
                }
            }
            if (t != null) {
                if (parentPosition.intValue() > 0) {
                    if (dependencyMap.get(parentPosition.intValue()) == null) {
                        dependencyMap.put(parentPosition.intValue(), new HashSet());
                    }
                    if (parentTablesChannels.size() > 1) {
                        parentPosition.setValue((Number)Database.mergeChannels(parentTablesChannels, dependencyMap, resolvedPosition));
                    }
                    dependencyMap.get(parentPosition.intValue()).add(t);
                } else {
                    if (dependencyMap.get(position.intValue()) == null) {
                        dependencyMap.put(position.intValue(), new HashSet());
                    }
                    dependencyMap.get(position.intValue()).add(t);
                }
                resolved.add(t);
                resolvedPosition.put(t, parentPosition.intValue() > 0 ? parentPosition.intValue() : position.intValue());
                finalList.add(0, t);
                if (depth.intValue() == 1) {
                    if (parentPosition.intValue() < 0) {
                        position.increment();
                    }
                } else {
                    depth.decrement();
                }
            }
        }
    }

    protected static Integer mergeChannels(Set<Integer> parentTablesChannels, Map<Integer, Set<Table>> dependencyMap, Map<Table, Integer> resolvedPosition) {
        Iterator<Integer> i = parentTablesChannels.iterator();
        HashSet mergedTables = new HashSet();
        Integer minChannelId = null;
        HashSet<Integer> unusedChannels = new HashSet<Integer>();
        while (i.hasNext()) {
            Integer channelToMerge = i.next();
            if (dependencyMap.get(channelToMerge) == null) continue;
            mergedTables.addAll(dependencyMap.get(channelToMerge));
            if (minChannelId == null) {
                minChannelId = channelToMerge;
                continue;
            }
            if (channelToMerge < minChannelId) {
                unusedChannels.add(minChannelId);
                minChannelId = channelToMerge;
                continue;
            }
            unusedChannels.add(channelToMerge);
        }
        dependencyMap.put(minChannelId, mergedTables);
        for (Table t : mergedTables) {
            resolvedPosition.put(t, minChannelId);
        }
        for (Integer unusedChannel : unusedChannels) {
            dependencyMap.remove(unusedChannel);
        }
        return minChannelId;
    }

    public static String printTables(List<Table> tables) {
        StringBuilder sb = new StringBuilder();
        for (Table t : tables) {
            sb.append(t.getName() + ",");
        }
        return sb.toString();
    }

    public static Table[] sortByForeignKeys(Table ... tables) {
        if (tables != null) {
            List<Table> list = new ArrayList<Table>(tables.length);
            for (Table table : tables) {
                list.add(table);
            }
            list = Database.sortByForeignKeys(list, null, null, null);
            tables = list.toArray(new Table[list.size()]);
        }
        return tables;
    }

    public static List<Table> sortByForeignKeys(List<Table> tables) {
        return Database.sortByForeignKeys(tables, null, null, null);
    }

    public void mergeWith(Database otherDb) throws ModelException {
        for (Table table : otherDb.tables) {
            if (this.findTable(table.getName()) != null) {
                throw new ModelException("Cannot merge the models because table " + table.getName() + " already defined in this model");
            }
            try {
                this.addTable((Table)table.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getIdMethod() {
        return this.idMethod;
    }

    public void setIdMethod(String idMethod) {
        this.idMethod = idMethod;
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public Table[] getTables() {
        return this.tables.toArray(new Table[this.tables.size()]);
    }

    public Table getTable(int idx) {
        return this.tables.get(idx);
    }

    public void addTable(Table table) {
        if (table != null) {
            this.tables.add(table);
        }
    }

    public void addTable(int idx, Table table) {
        if (table != null) {
            this.tables.add(idx, table);
        }
    }

    public void addTables(Collection<Table> tables) {
        Iterator<Table> it = tables.iterator();
        while (it.hasNext()) {
            this.addTable(it.next());
        }
    }

    public void addTables(Table[] tables) {
        for (Table table : tables) {
            this.addTable(table);
        }
    }

    public void removeTable(Table table) {
        if (table != null) {
            this.tables.remove(table);
        }
    }

    public void removeTable(int idx) {
        this.tables.remove(idx);
    }

    public void initialize() throws ModelException {
        HashSet<String> namesOfProcessedTables = new HashSet<String>();
        HashSet<String> namesOfProcessedColumns = new HashSet<String>();
        HashSet<String> namesOfProcessedFks = new HashSet<String>();
        HashSet<String> namesOfProcessedIndices = new HashSet<String>();
        int tableIdx = 0;
        for (Table curTable : this.tables) {
            int idx;
            if (curTable.getName() == null || curTable.getName().length() == 0) {
                throw new ModelException("The table nr. " + tableIdx + " has no name");
            }
            if (namesOfProcessedTables.contains(curTable.getFullyQualifiedTableName())) {
                throw new ModelException("There are multiple tables with the name " + curTable.getName());
            }
            namesOfProcessedTables.add(curTable.getFullyQualifiedTableName());
            namesOfProcessedColumns.clear();
            namesOfProcessedFks.clear();
            namesOfProcessedIndices.clear();
            for (idx = 0; idx < curTable.getColumnCount(); ++idx) {
                Column column = curTable.getColumn(idx);
                if (column.getName() == null || column.getName().length() == 0) {
                    throw new ModelException("The column nr. " + idx + " in table " + curTable.getName() + " has no name");
                }
                if (namesOfProcessedColumns.contains(column.getName())) {
                    throw new ModelException("There are multiple column with the name " + column.getName() + " in the table " + curTable.getName());
                }
                namesOfProcessedColumns.add(column.getName());
                if (column.getMappedType() == null || column.getMappedType().length() == 0) {
                    throw new ModelException("The column nr. " + idx + " in table " + curTable.getName() + " has no type");
                }
                if (column.getMappedTypeCode() == 1111 && !"OTHER".equalsIgnoreCase(column.getMappedType())) {
                    throw new ModelException("The column nr. " + idx + " in table " + curTable.getName() + " has an unknown type " + column.getMappedType());
                }
                namesOfProcessedColumns.add(column.getName());
            }
            for (idx = 0; idx < curTable.getForeignKeyCount(); ++idx) {
                String fkDesc;
                ForeignKey fk = curTable.getForeignKey(idx);
                String fkName = fk.getName() == null ? "" : fk.getName();
                String string = fkDesc = fkName.length() == 0 ? "nr. " + idx : fkName;
                if (fkName.length() > 0) {
                    if (namesOfProcessedFks.contains(fkName)) {
                        throw new ModelException("There are multiple foreign keys in table " + curTable.getName() + " with the name " + fkName);
                    }
                    namesOfProcessedFks.add(fkName);
                }
                if (fk.getForeignTable() == null) {
                    Table targetTable = this.findTable(fk.getForeignTableName(), true);
                    if (targetTable != null) {
                        fk.setForeignTable(targetTable);
                        fk.setForeignTableCatalog(targetTable.getCatalog());
                        fk.setForeignTableSchema(targetTable.getSchema());
                    } else {
                        log.debug("The foreignkey " + fkDesc + " in table " + curTable.getName() + " references the undefined table " + fk.getForeignTableName() + ".  This could be because the foreign key table was in another schema which is a bug that should be fixed in the future.");
                    }
                }
                if (fk.getForeignTable() == null) continue;
                for (int refIdx = 0; refIdx < fk.getReferenceCount(); ++refIdx) {
                    Reference ref = fk.getReference(refIdx);
                    if (ref.getLocalColumn() == null) {
                        Column localColumn = curTable.findColumn(ref.getLocalColumnName(), true);
                        if (localColumn == null) {
                            throw new ModelException("The foreignkey " + fkDesc + " in table " + curTable.getName() + " references the undefined local column " + ref.getLocalColumnName());
                        }
                        ref.setLocalColumn(localColumn);
                    }
                    if (ref.getForeignColumn() != null) continue;
                    Column foreignColumn = fk.getForeignTable().findColumn(ref.getForeignColumnName(), true);
                    if (foreignColumn == null) {
                        throw new ModelException("The foreignkey " + fkDesc + " in table " + curTable.getName() + " references the undefined local column " + ref.getForeignColumnName() + " in table " + fk.getForeignTable().getName());
                    }
                    ref.setForeignColumn(foreignColumn);
                }
            }
            for (idx = 0; idx < curTable.getIndexCount(); ++idx) {
                String indexName;
                IIndex index = curTable.getIndex(idx);
                String string = indexName = index.getName() == null ? "" : index.getName();
                if (indexName.length() > 0) {
                    if (namesOfProcessedIndices.contains(indexName)) {
                        throw new ModelException("There are multiple indices in table " + curTable.getName() + " with the name " + indexName);
                    }
                    namesOfProcessedIndices.add(indexName);
                }
                for (int indexColumnIdx = 0; indexColumnIdx < index.getColumnCount(); ++indexColumnIdx) {
                    IndexColumn indexColumn = index.getColumn(indexColumnIdx);
                    Column column = curTable.findColumn(indexColumn.getName(), true);
                    indexColumn.setColumn(column);
                }
            }
            ++tableIdx;
        }
    }

    public Table findTable(String name) {
        return this.findTable(name, false);
    }

    public Table findTable(String name, boolean caseSensitive) {
        for (Table table : this.tables) {
            if (!(caseSensitive ? table.getName().equals(name) : table.getName().equalsIgnoreCase(name))) continue;
            return table;
        }
        return null;
    }

    public Table findTable(String catalogName, String schemaName, String tableName, boolean caseSensitive) {
        Table table;
        String cacheKey = catalogName + "." + schemaName + "." + tableName + "." + caseSensitive;
        Integer tableIndex = this.tableIndexCache.get(cacheKey);
        if (tableIndex != null && tableIndex < this.getTableCount() && this.doesMatch(table = this.getTable(tableIndex), catalogName, schemaName, tableName, caseSensitive)) {
            return table;
        }
        Table[] tables = this.getTables();
        for (int i = 0; i < tables.length; ++i) {
            Table table2 = tables[i];
            if (!this.doesMatch(table2, catalogName, schemaName, tableName, caseSensitive)) continue;
            this.tableIndexCache.put(cacheKey, i);
            return table2;
        }
        return null;
    }

    private boolean doesMatch(Table table, String catalogName, String schemaName, String tableName, boolean caseSensitive) {
        if (caseSensitive) {
            return (catalogName == null || catalogName != null && catalogName.equals(table.getCatalog())) && (schemaName == null || schemaName != null && schemaName.equals(table.getSchema())) && table.getName().equals(tableName);
        }
        return (catalogName == null || catalogName != null && catalogName.equalsIgnoreCase(table.getCatalog())) && (schemaName == null || schemaName != null && schemaName.equalsIgnoreCase(table.getSchema())) && table.getName().equalsIgnoreCase(tableName);
    }

    public Table findTable(String catalogName, String schemaName, String tableName) {
        return this.findTable(catalogName, schemaName, tableName, false);
    }

    public void resetTableIndexCache() {
        this.tableIndexCache.clear();
    }

    public void removeAllTablesExcept(String ... tableNames) {
        Iterator<Table> tableIterator = this.tables.iterator();
        while (tableIterator.hasNext()) {
            Table table = tableIterator.next();
            boolean foundTable = false;
            for (String tableName : tableNames) {
                if (!tableName.equals(table.getName())) continue;
                foundTable = true;
                break;
            }
            if (foundTable) continue;
            tableIterator.remove();
        }
    }

    public Database copy() {
        try {
            return (Database)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Database result = (Database)super.clone();
        result.name = this.name;
        result.catalog = this.catalog;
        result.schema = this.schema;
        result.idMethod = this.idMethod;
        result.version = this.version;
        result.tables = new ArrayList(this.tables.size());
        for (Table table : this.tables) {
            result.tables.add((Table)table.clone());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Database) {
            Database other = (Database)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.catalog, (Object)other.catalog).append((Object)this.schema, (Object)other.schema).append(this.tables, other.tables).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append(this.tables).toHashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Database [name=").append(this.name);
        result.append("; catalog=").append(this.catalog);
        result.append("; schema=").append(this.schema);
        result.append("; tableCount=").append(this.getTableCount());
        result.append("]");
        return result.toString();
    }

    public String toVerboseString() {
        StringBuilder result = new StringBuilder();
        result.append("Database [");
        result.append(this.getName());
        result.append("] tables:");
        for (int idx = 0; idx < this.getTableCount(); ++idx) {
            result.append(" ");
            result.append(this.getTable(idx).toVerboseString());
        }
        return result.toString();
    }
}

