/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.util.ArrayList;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexImpBase;

public class NonUniqueIndex
extends IndexImpBase {
    private static final long serialVersionUID = 1L;

    public NonUniqueIndex() {
    }

    public NonUniqueIndex(String name) {
        this.setName(name);
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NonUniqueIndex result = new NonUniqueIndex();
        result.name = this.name;
        result.columns = (ArrayList)this.columns.clone();
        this.clonePlatformIndexes(result);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NonUniqueIndex) {
            NonUniqueIndex other = (NonUniqueIndex)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.columns, (Object)other.columns).append((Object)this.platformIndexes, (Object)other.platformIndexes).isEquals();
        }
        return false;
    }

    @Override
    public boolean equalsIgnoreCase(IIndex other) {
        if (other instanceof NonUniqueIndex) {
            boolean checkName;
            NonUniqueIndex otherIndex = (NonUniqueIndex)other;
            boolean bl = checkName = this.name != null && this.name.length() > 0 && otherIndex.name != null && otherIndex.name.length() > 0;
            if ((!checkName || this.name.equalsIgnoreCase(otherIndex.name)) && this.getColumnCount() == otherIndex.getColumnCount()) {
                for (int idx = 0; idx < this.getColumnCount(); ++idx) {
                    if (this.getColumn(idx).equalsIgnoreCase(otherIndex.getColumn(idx))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.columns).toHashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Index [name=");
        result.append(this.getName());
        result.append("; ");
        result.append(this.getColumnCount());
        result.append(" columns]");
        return result.toString();
    }

    @Override
    public String toVerboseString() {
        StringBuilder result = new StringBuilder();
        result.append("Index [");
        result.append(this.getName());
        result.append("] columns:");
        for (int idx = 0; idx < this.getColumnCount(); ++idx) {
            result.append(" ");
            result.append(this.getColumn(idx));
        }
        return result.toString();
    }
}

