/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.io.Serializable;

public class PlatformColumn
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String type;
    private int size = -1;
    private int decimalDigits = -1;
    private String defaultValue;
    private String[] enumValues;

    public PlatformColumn(String name, String type, int size, int decimalDigits, String defaultValue) {
        this.name = name;
        this.type = type;
        this.size = size;
        this.decimalDigits = decimalDigits;
        this.defaultValue = defaultValue;
    }

    public PlatformColumn(String name, String sqlType, String defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        String spec = null;
        int startIndex = sqlType.indexOf("(");
        if (startIndex == -1) {
            this.type = sqlType;
        } else {
            this.type = sqlType.substring(0, startIndex).trim();
            int endIndex = sqlType.indexOf(")", startIndex);
            if (endIndex != -1) {
                spec = sqlType.substring(startIndex + 1, endIndex);
                if (++endIndex < sqlType.length()) {
                    this.type = this.type + sqlType.substring(endIndex);
                }
            }
        }
        if (spec != null && !spec.trim().equals("")) {
            int index = spec.indexOf(",");
            if (index == -1) {
                this.size = spec.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.valueOf(spec.trim());
            } else {
                this.size = Integer.valueOf(spec.substring(0, index).trim());
                if (++index < spec.length()) {
                    this.decimalDigits = Integer.valueOf(spec.substring(index).trim());
                }
            }
        }
    }

    public PlatformColumn() {
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setEnumValues(String[] enumValues) {
        this.enumValues = enumValues;
    }

    public String[] getEnumValues() {
        return this.enumValues;
    }

    public boolean isEnum() {
        return this.enumValues != null && this.enumValues.length > 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

