/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.util.HashMap;
import java.util.Map;

public class Trigger {
    String triggerName;
    String catalogName;
    String schemaName;
    String tableName;
    String source;
    TriggerType triggerType;
    boolean enabled;
    Map<String, Object> metaData = new HashMap<String, Object>();

    public Trigger(String name, String catalogName, String schemaName, String tableName, TriggerType triggerType) {
        this(name, catalogName, schemaName, tableName, triggerType, true);
    }

    public Trigger(String name, String catalogName, String schemaName, String tableName, TriggerType triggerType, boolean enabled) {
        this.triggerName = name;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.triggerType = triggerType;
        this.enabled = enabled;
    }

    public Trigger() {
    }

    public String getName() {
        return this.triggerName;
    }

    public void setName(String name) {
        this.triggerName = name;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public String getFullyQualifiedName() {
        return Trigger.getFullyQualifiedName(this.catalogName, this.schemaName, this.tableName, this.triggerName);
    }

    public static String getFullyQualifiedName(String catalog, String schema, String tableName, String triggerName) {
        String fullName = "";
        if (catalog != null) {
            fullName = fullName + catalog + ".";
        }
        if (schema != null) {
            fullName = fullName + schema + ".";
        }
        fullName = fullName + tableName + "." + triggerName;
        return fullName;
    }

    public static enum TriggerType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

