/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.JdbcTypeCategory;
import org.jumpmind.db.platform.PlatformUtils;

public abstract class TypeMap {
    public static final String ARRAY = "ARRAY";
    public static final String BIGINT = "BIGINT";
    public static final String BINARY = "BINARY";
    public static final String BIT = "BIT";
    public static final String BLOB = "BLOB";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String CHAR = "CHAR";
    public static final String CLOB = "CLOB";
    public static final String DATALINK = "DATALINK";
    public static final String DATE = "DATE";
    public static final String DECIMAL = "DECIMAL";
    public static final String DISTINCT = "DISTINCT";
    public static final String DOUBLE = "DOUBLE";
    public static final String FLOAT = "FLOAT";
    public static final String INTEGER = "INTEGER";
    public static final String JAVA_OBJECT = "JAVA_OBJECT";
    public static final String LONGVARBINARY = "LONGVARBINARY";
    public static final String LONGVARCHAR = "LONGVARCHAR";
    public static final String NULL = "NULL";
    public static final String NUMERIC = "NUMERIC";
    public static final String OTHER = "OTHER";
    public static final String REAL = "REAL";
    public static final String REF = "REF";
    public static final String SMALLINT = "SMALLINT";
    public static final String STRUCT = "STRUCT";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String TIMESTAMPTZ = "TIMESTAMPTZ";
    public static final String TIMESTAMPLTZ = "TIMESTAMPLTZ";
    public static final String TIMETZ = "TIMETZ";
    public static final String TINYINT = "TINYINT";
    public static final String VARBINARY = "VARBINARY";
    public static final String VARCHAR = "VARCHAR";
    public static final String SQLXML = "SQLXML";
    public static final String GEOMETRY = "GEOMETRY";
    public static final String GEOGRAPHY = "GEOGRAPHY";
    public static final String POINT = "POINT";
    public static final String LINESTRING = "LINESTRING";
    public static final String POLYGON = "POLYGON";
    public static final String UUID = "UUID";
    public static final String VARBIT = "VARBIT";
    public static final String INTERVAL = "INTERVAL";
    public static final String NCHAR = "NCHAR";
    public static final String NVARCHAR = "NVARCHAR";
    public static final String LONGNVARCHAR = "LONGNVARCHAR";
    public static final String NCLOB = "NCLOB";
    public static final String IMAGE = "IMAGE";
    public static final String DATETIME2 = "DATETIME2";
    public static final String TSVECTOR = "TSVECTOR";
    public static final String JSONB = "JSONB";
    public static final String JSON = "JSON";
    public static final String INET = "INET";
    public static final String CIDR = "CIDR";
    public static final String MACADDR = "MACADDR";
    public static final String MACADDR8 = "MACADDR8";
    public static final String UNITEXT = "UNITEXT";
    private static HashMap<String, Integer> _typeNameToTypeCode = new HashMap();
    private static HashMap<Integer, String> _typeCodeToTypeName = new HashMap();
    private static HashMap<JdbcTypeCategory, Set<Integer>> _typesPerCategory = new HashMap();

    public static Integer getJdbcTypeCode(String typeName) {
        return _typeNameToTypeCode.get(typeName.toUpperCase());
    }

    public static String getJdbcTypeDescriptions(int[] types) {
        StringBuilder buff = new StringBuilder(32);
        for (int type : types) {
            buff.append(TypeMap.getJdbcTypeName(type)).append(", ");
        }
        if (buff.length() > 0) {
            buff.setLength(buff.length() - 2);
        }
        return buff.toString();
    }

    public static String getJdbcTypeName(int typeCode) {
        String description = _typeCodeToTypeName.get(typeCode);
        if (StringUtils.isEmpty((CharSequence)description)) {
            description = String.valueOf(typeCode);
        }
        return description;
    }

    protected static void registerJdbcType(int typeCode, String typeName, JdbcTypeCategory category) {
        Integer typeId = typeCode;
        _typeNameToTypeCode.put(typeName.toUpperCase(), typeId);
        _typeCodeToTypeName.put(typeId, typeName.toUpperCase());
        Set<Integer> typesInCategory = _typesPerCategory.get((Object)category);
        if (typesInCategory == null) {
            typesInCategory = new HashSet<Integer>();
            _typesPerCategory.put(category, typesInCategory);
        }
        typesInCategory.add(typeId);
    }

    public static boolean isNumericType(int jdbcTypeCode) {
        Set<Integer> typesInCategory = _typesPerCategory.get((Object)JdbcTypeCategory.NUMERIC);
        return typesInCategory == null ? false : typesInCategory.contains(jdbcTypeCode);
    }

    public static boolean isDateTimeType(int jdbcTypeCode) {
        Set<Integer> typesInCategory = _typesPerCategory.get((Object)JdbcTypeCategory.DATETIME);
        return typesInCategory == null ? false : typesInCategory.contains(jdbcTypeCode);
    }

    public static boolean isTextType(int jdbcTypeCode) {
        Set<Integer> typesInCategory = _typesPerCategory.get((Object)JdbcTypeCategory.TEXTUAL);
        return typesInCategory == null ? false : typesInCategory.contains(jdbcTypeCode);
    }

    public static boolean isBinaryType(int jdbcTypeCode) {
        Set<Integer> typesInCategory = _typesPerCategory.get((Object)JdbcTypeCategory.BINARY);
        return typesInCategory == null ? false : typesInCategory.contains(jdbcTypeCode);
    }

    public static boolean isSpecialType(int jdbcTypeCode) {
        Set<Integer> typesInCategory = _typesPerCategory.get((Object)JdbcTypeCategory.SPECIAL);
        return typesInCategory == null ? false : typesInCategory.contains(jdbcTypeCode);
    }

    static {
        TypeMap.registerJdbcType(2003, ARRAY, JdbcTypeCategory.SPECIAL);
        TypeMap.registerJdbcType(-5, BIGINT, JdbcTypeCategory.NUMERIC);
        TypeMap.registerJdbcType(-2, BINARY, JdbcTypeCategory.BINARY);
        TypeMap.registerJdbcType(-7, BIT, JdbcTypeCategory.NUMERIC);
        TypeMap.registerJdbcType(2004, BLOB, JdbcTypeCategory.BINARY);
        TypeMap.registerJdbcType(1, CHAR, JdbcTypeCategory.TEXTUAL);
        TypeMap.registerJdbcType(2005, CLOB, JdbcTypeCategory.TEXTUAL);
        TypeMap.registerJdbcType(91, DATE, JdbcTypeCategory.DATETIME);
        TypeMap.registerJdbcType(3, DECIMAL, JdbcTypeCategory.NUMERIC);
        TypeMap.registerJdbcType(2001, DISTINCT, JdbcTypeCategory.SPECIAL);
        TypeMap.registerJdbcType(8, DOUBLE, JdbcTypeCategory.NUMERIC);
        TypeMap.registerJdbcType(6, FLOAT, JdbcTypeCategory.NUMERIC);
        TypeMap.registerJdbcType(4, INTEGER, JdbcTypeCategory.NUMERIC);
        TypeMap.registerJdbcType(2000, JAVA_OBJECT, JdbcTypeCategory.SPECIAL);
        TypeMap.registerJdbcType(-4, LONGVARBINARY, JdbcTypeCategory.BINARY);
        TypeMap.registerJdbcType(-1, LONGVARCHAR, JdbcTypeCategory.TEXTUAL);
        TypeMap.registerJdbcType(0, NULL, JdbcTypeCategory.SPECIAL);
        TypeMap.registerJdbcType(2, NUMERIC, JdbcTypeCategory.NUMERIC);
        TypeMap.registerJdbcType(1111, OTHER, JdbcTypeCategory.SPECIAL);
        TypeMap.registerJdbcType(7, REAL, JdbcTypeCategory.NUMERIC);
        TypeMap.registerJdbcType(2006, REF, JdbcTypeCategory.SPECIAL);
        TypeMap.registerJdbcType(5, SMALLINT, JdbcTypeCategory.NUMERIC);
        TypeMap.registerJdbcType(2002, STRUCT, JdbcTypeCategory.SPECIAL);
        TypeMap.registerJdbcType(92, TIME, JdbcTypeCategory.DATETIME);
        TypeMap.registerJdbcType(93, TIMESTAMP, JdbcTypeCategory.DATETIME);
        TypeMap.registerJdbcType(-6, TINYINT, JdbcTypeCategory.NUMERIC);
        TypeMap.registerJdbcType(-3, VARBINARY, JdbcTypeCategory.BINARY);
        TypeMap.registerJdbcType(12, VARCHAR, JdbcTypeCategory.TEXTUAL);
        TypeMap.registerJdbcType(-101, TIMESTAMPTZ, JdbcTypeCategory.DATETIME);
        TypeMap.registerJdbcType(-102, TIMESTAMPLTZ, JdbcTypeCategory.DATETIME);
        TypeMap.registerJdbcType(-103, TIMETZ, JdbcTypeCategory.DATETIME);
        TypeMap.registerJdbcType(2009, SQLXML, JdbcTypeCategory.TEXTUAL);
        TypeMap.registerJdbcType(-15, NCHAR, JdbcTypeCategory.TEXTUAL);
        TypeMap.registerJdbcType(2011, NCLOB, JdbcTypeCategory.TEXTUAL);
        TypeMap.registerJdbcType(-9, NVARCHAR, JdbcTypeCategory.TEXTUAL);
        TypeMap.registerJdbcType(-16, LONGNVARCHAR, JdbcTypeCategory.TEXTUAL);
        if (PlatformUtils.supportsJava14JdbcTypes()) {
            TypeMap.registerJdbcType(PlatformUtils.determineBooleanTypeCode(), BOOLEAN, JdbcTypeCategory.NUMERIC);
            TypeMap.registerJdbcType(PlatformUtils.determineDatalinkTypeCode(), DATALINK, JdbcTypeCategory.SPECIAL);
        }
        _typeNameToTypeCode.put("BOOLEANINT", -6);
        _typeNameToTypeCode.put("BOOLEANCHAR", 1);
    }
}

