/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseInfo {
    private final Logger log = LoggerFactory.getLogger(DatabaseInfo.class);
    private boolean nullAsDefaultValueRequired = false;
    private boolean defaultValuesForLongTypesSupported = true;
    private boolean primaryKeyEmbedded = true;
    private boolean foreignKeysEmbedded = false;
    private boolean embeddedForeignKeysNamed = false;
    private boolean indicesSupported = true;
    private boolean foreignKeysSupported = true;
    private boolean indicesEmbedded = false;
    private boolean uniqueEmbedded = true;
    private boolean triggersSupported = true;
    private boolean triggersCreateOrReplaceSupported = false;
    private boolean nonPKIdentityColumnsSupported = true;
    private boolean generatedColumnsSupported = false;
    private boolean expressionsAsDefaultValuesSupported = false;
    private boolean functionalIndicesSupported = false;
    private boolean defaultValueUsedForIdentitySpec = false;
    private boolean systemIndicesReturned = true;
    private boolean systemForeignKeyIndicesAlwaysNonUnique = false;
    private boolean syntheticDefaultValueForRequiredReturned = false;
    private boolean identityStatusReadingSupported = true;
    private boolean sqlCommentsSupported = true;
    private boolean delimitedIdentifiersSupported = true;
    private boolean alterTableForDropUsed = false;
    private boolean identityOverrideAllowed = true;
    private boolean lastIdentityValueReadable = true;
    private boolean autoCommitModeForLastIdentityValueReading = true;
    private int maxTableNameLength = -1;
    private int maxColumnNameLength = -1;
    private int maxConstraintNameLength = -1;
    private int maxForeignKeyNameLength = -1;
    private String delimiterToken = "\"";
    private String valueQuoteToken = "'";
    private String binaryQuoteStart = "'";
    private String binaryQuoteEnd = "'";
    private String commentPrefix = "--";
    private String commentSuffix = "";
    private String sqlCommandDelimiter = ";";
    private boolean dateOverridesToTimestamp;
    private boolean emptyStringNulled = false;
    private boolean autoIncrementUpdateAllowed = true;
    private boolean blankCharColumnSpacePadded;
    private boolean nonBlankCharColumnSpacePadded;
    private boolean charColumnSpaceTrimmed;
    private boolean requiresAutoCommitForDdl = false;
    private boolean requiresSavePointsInTransaction = false;
    private String catalogSeparator = ".";
    private String schemaSeparator = ".";
    private Map<Integer, String> nativeTypes = new HashMap<Integer, String>();
    private Map<Integer, Integer> targetJdbcTypes = new HashMap<Integer, Integer>();
    private Set<Integer> typesWithNullDefault = new HashSet<Integer>();
    private Set<Integer> typesWithSize = new HashSet<Integer>();
    private Map<Integer, Integer> typesDefaultSizes = new HashMap<Integer, Integer>();
    private Map<String, Integer> nativeTypeMaxSizes = new HashMap<String, Integer>();
    private HashSet<Integer> typesWithPrecisionAndScale = new HashSet();
    private Supplier<Set<String>> defaultValuesToLeaveUnquotedSupplier;
    private Supplier<Map<String, String>> defaultValuesToTranslateSupplier;
    private int minIsolationLevelToPreventPhantomReads = 2;
    private boolean requiredCharColumnEmptyStringSameAsNull;
    private boolean notNullColumnsSupported = true;
    private boolean zeroDateAllowed;
    private String cteExpression;
    private boolean logBased;
    private boolean triggersContainJava = false;

    public DatabaseInfo() {
        this.typesWithNullDefault.add(1);
        this.typesWithNullDefault.add(12);
        this.typesWithNullDefault.add(-1);
        this.typesWithNullDefault.add(2005);
        this.typesWithNullDefault.add(-2);
        this.typesWithNullDefault.add(-3);
        this.typesWithNullDefault.add(-4);
        this.typesWithNullDefault.add(2004);
        this.typesWithSize.add(1);
        this.typesWithSize.add(12);
        this.typesWithSize.add(-2);
        this.typesWithSize.add(-3);
        this.typesWithSize.add(-15);
        this.typesWithSize.add(-9);
        this.typesWithPrecisionAndScale.add(3);
        this.typesWithPrecisionAndScale.add(2);
        this.nativeTypes.put(-101, "TIMESTAMP");
        this.nativeTypes.put(-102, "TIMESTAMP");
        this.nativeTypes.put(-103, "TIME");
        this.targetJdbcTypes.put(-101, 93);
        this.targetJdbcTypes.put(-102, 93);
        this.targetJdbcTypes.put(-103, 92);
    }

    public boolean isNullAsDefaultValueRequired() {
        return this.nullAsDefaultValueRequired;
    }

    public void setNullAsDefaultValueRequired(boolean requiresNullAsDefaultValue) {
        this.nullAsDefaultValueRequired = requiresNullAsDefaultValue;
    }

    public boolean isDefaultValuesForLongTypesSupported() {
        return this.defaultValuesForLongTypesSupported;
    }

    public void setDefaultValuesForLongTypesSupported(boolean isSupported) {
        this.defaultValuesForLongTypesSupported = isSupported;
    }

    public boolean isPrimaryKeyEmbedded() {
        return this.primaryKeyEmbedded;
    }

    public void setPrimaryKeyEmbedded(boolean primaryKeyEmbedded) {
        this.primaryKeyEmbedded = primaryKeyEmbedded;
    }

    public boolean isForeignKeysEmbedded() {
        return this.foreignKeysEmbedded;
    }

    public void setForeignKeysEmbedded(boolean foreignKeysEmbedded) {
        this.foreignKeysEmbedded = foreignKeysEmbedded;
    }

    public boolean isEmbeddedForeignKeysNamed() {
        return this.embeddedForeignKeysNamed;
    }

    public void setEmbeddedForeignKeysNamed(boolean embeddedForeignKeysNamed) {
        this.embeddedForeignKeysNamed = embeddedForeignKeysNamed;
    }

    public boolean isIndicesSupported() {
        return this.indicesSupported;
    }

    public void setIndicesSupported(boolean supportingIndices) {
        this.indicesSupported = supportingIndices;
    }

    public boolean isForeignKeysSupported() {
        return this.foreignKeysSupported;
    }

    public void setForeignKeysSupported(boolean foreignKeysSupported) {
        this.foreignKeysSupported = foreignKeysSupported;
    }

    public boolean isIndicesEmbedded() {
        return this.indicesEmbedded;
    }

    public void setIndicesEmbedded(boolean indicesEmbedded) {
        this.indicesEmbedded = indicesEmbedded;
    }

    public boolean isUniqueEmbedded() {
        return this.uniqueEmbedded;
    }

    public void setUniqueEmbedded(boolean unique) {
        this.uniqueEmbedded = unique;
    }

    public boolean isNonPKIdentityColumnsSupported() {
        return this.nonPKIdentityColumnsSupported;
    }

    public void setNonPKIdentityColumnsSupported(boolean supportingNonPKIdentityColumns) {
        this.nonPKIdentityColumnsSupported = supportingNonPKIdentityColumns;
    }

    public boolean isGeneratedColumnsSupported() {
        return this.generatedColumnsSupported;
    }

    public void setGeneratedColumnsSupported(boolean generatedColumnsSupported) {
        this.generatedColumnsSupported = generatedColumnsSupported;
    }

    public boolean isExpressionsAsDefaultValuesSupported() {
        return this.expressionsAsDefaultValuesSupported;
    }

    public void setExpressionsAsDefaultValuesSupported(boolean expressionsAsDefaultValuesSupported) {
        this.expressionsAsDefaultValuesSupported = expressionsAsDefaultValuesSupported;
    }

    public boolean isDefaultValueUsedForIdentitySpec() {
        return this.defaultValueUsedForIdentitySpec;
    }

    public void setDefaultValueUsedForIdentitySpec(boolean identitySpecUsesDefaultValue) {
        this.defaultValueUsedForIdentitySpec = identitySpecUsesDefaultValue;
    }

    public boolean isSystemIndicesReturned() {
        return this.systemIndicesReturned;
    }

    public void setSystemIndicesReturned(boolean returningSystemIndices) {
        this.systemIndicesReturned = returningSystemIndices;
    }

    public boolean isSystemForeignKeyIndicesAlwaysNonUnique() {
        return this.systemForeignKeyIndicesAlwaysNonUnique;
    }

    public void setSystemForeignKeyIndicesAlwaysNonUnique(boolean alwaysNonUnique) {
        this.systemForeignKeyIndicesAlwaysNonUnique = alwaysNonUnique;
    }

    public boolean isSyntheticDefaultValueForRequiredReturned() {
        return this.syntheticDefaultValueForRequiredReturned;
    }

    public void setSyntheticDefaultValueForRequiredReturned(boolean returningDefaultValue) {
        this.syntheticDefaultValueForRequiredReturned = returningDefaultValue;
    }

    public boolean getIdentityStatusReadingSupported() {
        return this.identityStatusReadingSupported;
    }

    public void setIdentityStatusReadingSupported(boolean canReadAutoIncrementStatus) {
        this.identityStatusReadingSupported = canReadAutoIncrementStatus;
    }

    public boolean isSqlCommentsSupported() {
        return this.sqlCommentsSupported;
    }

    public void setSqlCommentsSupported(boolean commentsSupported) {
        this.sqlCommentsSupported = commentsSupported;
    }

    public boolean isDelimitedIdentifiersSupported() {
        return this.delimitedIdentifiersSupported;
    }

    public void setDelimitedIdentifiersSupported(boolean areSupported) {
        this.delimitedIdentifiersSupported = areSupported;
    }

    public boolean isAlterTableForDropUsed() {
        return this.alterTableForDropUsed;
    }

    public void setAlterTableForDropUsed(boolean useAlterTableForDrop) {
        this.alterTableForDropUsed = useAlterTableForDrop;
    }

    public boolean isIdentityOverrideAllowed() {
        return this.identityOverrideAllowed;
    }

    public void setIdentityOverrideAllowed(boolean identityOverrideAllowed) {
        this.identityOverrideAllowed = identityOverrideAllowed;
    }

    public boolean isLastIdentityValueReadable() {
        return this.lastIdentityValueReadable;
    }

    public void setLastIdentityValueReadable(boolean lastIdentityValueReadable) {
        this.lastIdentityValueReadable = lastIdentityValueReadable;
    }

    public boolean isAutoCommitModeForLastIdentityValueReading() {
        return this.autoCommitModeForLastIdentityValueReading;
    }

    public void setAutoCommitModeForLastIdentityValueReading(boolean autoCommitModeForLastIdentityValueReading) {
        this.autoCommitModeForLastIdentityValueReading = autoCommitModeForLastIdentityValueReading;
    }

    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    public int getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }

    public int getMaxConstraintNameLength() {
        return this.maxConstraintNameLength;
    }

    public int getMaxForeignKeyNameLength() {
        return this.maxForeignKeyNameLength;
    }

    public void setMaxIdentifierLength(int maxIdentifierLength) {
        this.maxTableNameLength = maxIdentifierLength;
        this.maxColumnNameLength = maxIdentifierLength;
        this.maxConstraintNameLength = maxIdentifierLength;
        this.maxForeignKeyNameLength = maxIdentifierLength;
    }

    public void setMaxTableNameLength(int maxTableNameLength) {
        this.maxTableNameLength = maxTableNameLength;
    }

    public void setMaxColumnNameLength(int maxColumnNameLength) {
        this.maxColumnNameLength = maxColumnNameLength;
    }

    public void setMaxConstraintNameLength(int maxConstraintNameLength) {
        this.maxConstraintNameLength = maxConstraintNameLength;
    }

    public void setMaxForeignKeyNameLength(int maxForeignKeyNameLength) {
        this.maxForeignKeyNameLength = maxForeignKeyNameLength;
    }

    public String getDelimiterToken() {
        return this.delimiterToken;
    }

    public void setDelimiterToken(String delimiterToken) {
        this.delimiterToken = delimiterToken;
    }

    public String getValueQuoteToken() {
        return this.valueQuoteToken;
    }

    public void setValueQuoteToken(String valueQuoteChar) {
        this.valueQuoteToken = valueQuoteChar;
    }

    public String getCommentPrefix() {
        return this.commentPrefix;
    }

    public void setCommentPrefix(String commentPrefix) {
        this.commentPrefix = commentPrefix == null ? "" : commentPrefix;
    }

    public String getCommentSuffix() {
        return this.commentSuffix;
    }

    public void setCommentSuffix(String commentSuffix) {
        this.commentSuffix = commentSuffix == null ? "" : commentSuffix;
    }

    public String getSqlCommandDelimiter() {
        return this.sqlCommandDelimiter;
    }

    public void setSqlCommandDelimiter(String sqlCommandDelimiter) {
        this.sqlCommandDelimiter = sqlCommandDelimiter;
    }

    public String getNativeType(int typeCode) {
        return this.nativeTypes.get(typeCode);
    }

    public int getTargetJdbcType(int typeCode) {
        Integer targetJdbcType = this.targetJdbcTypes.get(typeCode);
        return targetJdbcType == null ? typeCode : targetJdbcType;
    }

    public void addNativeTypeMapping(int jdbcTypeCode, String nativeType) {
        this.nativeTypes.put(jdbcTypeCode, nativeType);
    }

    public void addNativeTypeMapping(int jdbcTypeCode, String nativeType, int targetJdbcTypeCode) {
        this.addNativeTypeMapping(jdbcTypeCode, nativeType);
        this.targetJdbcTypes.put(jdbcTypeCode, targetJdbcTypeCode);
    }

    public void addNativeTypeMapping(String jdbcTypeName, String nativeType) {
        try {
            Field constant = Types.class.getField(jdbcTypeName);
            if (constant != null) {
                this.addNativeTypeMapping(constant.getInt(null), nativeType);
            }
        }
        catch (Exception ex) {
            this.log.warn("Cannot add native type mapping for undefined jdbc type " + jdbcTypeName, (Throwable)ex);
        }
    }

    public void addNativeTypeMapping(String jdbcTypeName, String nativeType, String targetJdbcTypeName) {
        try {
            Field sourceType = Types.class.getField(jdbcTypeName);
            Field targetType = Types.class.getField(targetJdbcTypeName);
            if (sourceType != null && targetType != null) {
                this.addNativeTypeMapping(sourceType.getInt(null), nativeType, targetType.getInt(null));
            }
        }
        catch (Exception ex) {
            this.log.warn("Cannot add native type mapping for undefined jdbc type " + jdbcTypeName + ", target jdbc type " + targetJdbcTypeName, (Throwable)ex);
        }
    }

    public boolean hasNullDefault(int sqlTypeCode) {
        return this.typesWithNullDefault.contains(sqlTypeCode);
    }

    public void setHasNullDefault(int sqlTypeCode, boolean hasNullDefault) {
        if (hasNullDefault) {
            this.typesWithNullDefault.add(sqlTypeCode);
        } else {
            this.typesWithNullDefault.remove(sqlTypeCode);
        }
    }

    public boolean hasSize(int sqlTypeCode) {
        return this.typesWithSize.contains(sqlTypeCode);
    }

    public void setHasSize(int sqlTypeCode, boolean hasSize) {
        if (hasSize) {
            this.typesWithSize.add(sqlTypeCode);
        } else {
            this.typesWithSize.remove(sqlTypeCode);
        }
    }

    public Integer getDefaultSize(int jdbcTypeCode) {
        return this.typesDefaultSizes.get(jdbcTypeCode);
    }

    public void setDefaultSize(int jdbcTypeCode, int defaultSize) {
        this.typesDefaultSizes.put(jdbcTypeCode, defaultSize);
    }

    public void setDefaultSize(String jdbcTypeName, int defaultSize) {
        try {
            Field constant = Types.class.getField(jdbcTypeName);
            if (constant != null) {
                this.setDefaultSize(constant.getInt(null), defaultSize);
            }
        }
        catch (Exception ex) {
            this.log.warn("Cannot add default size for undefined jdbc type " + jdbcTypeName, (Throwable)ex);
        }
    }

    public int getMaxSize(String nativeType) {
        Integer maxSize = this.nativeTypeMaxSizes.get(nativeType);
        return maxSize == null ? 0 : maxSize;
    }

    public void setMaxSize(String nativeType, int defaultSize) {
        this.nativeTypeMaxSizes.put(nativeType, defaultSize);
    }

    public boolean hasPrecisionAndScale(int sqlTypeCode) {
        return this.typesWithPrecisionAndScale.contains(sqlTypeCode);
    }

    public void setHasPrecisionAndScale(int sqlTypeCode, boolean hasPrecisionAndScale) {
        if (hasPrecisionAndScale) {
            this.typesWithPrecisionAndScale.add(sqlTypeCode);
        } else {
            this.typesWithPrecisionAndScale.remove(sqlTypeCode);
        }
    }

    public Set<String> getDefaultValuesToLeaveUnquoted() {
        if (this.defaultValuesToLeaveUnquotedSupplier != null) {
            return this.defaultValuesToLeaveUnquotedSupplier.get();
        }
        return new HashSet<String>();
    }

    public void setDefaultValuesToLeaveUnquotedSupplier(Supplier<Set<String>> defaultValuesToLeaveUnquotedSupplier) {
        this.defaultValuesToLeaveUnquotedSupplier = defaultValuesToLeaveUnquotedSupplier;
    }

    public Map<String, String> getDefaultValuesToTranslate() {
        if (this.defaultValuesToTranslateSupplier != null) {
            return this.defaultValuesToTranslateSupplier.get();
        }
        return new HashMap<String, String>();
    }

    public void setDefaultValuesToTranslateSupplier(Supplier<Map<String, String>> defaultValuesToTranslateSupplier) {
        this.defaultValuesToTranslateSupplier = defaultValuesToTranslateSupplier;
    }

    public void setTriggersSupported(boolean triggersSupported) {
        this.triggersSupported = triggersSupported;
    }

    public boolean isTriggersSupported() {
        return this.triggersSupported;
    }

    public boolean isDateOverridesToTimestamp() {
        return this.dateOverridesToTimestamp;
    }

    public void setDateOverridesToTimestamp(boolean dateOverridesToTimestamp) {
        this.dateOverridesToTimestamp = dateOverridesToTimestamp;
    }

    public boolean isEmptyStringNulled() {
        return this.emptyStringNulled;
    }

    public void setEmptyStringNulled(boolean emptyStringNulled) {
        this.emptyStringNulled = emptyStringNulled;
    }

    public void setBlankCharColumnSpacePadded(boolean blankCharColumnSpacePadded) {
        this.blankCharColumnSpacePadded = blankCharColumnSpacePadded;
    }

    public boolean isBlankCharColumnSpacePadded() {
        return this.blankCharColumnSpacePadded;
    }

    public void setCharColumnSpaceTrimmed(boolean charColumnSpaceTrimmed) {
        this.charColumnSpaceTrimmed = charColumnSpaceTrimmed;
    }

    public boolean isCharColumnSpaceTrimmed() {
        return this.charColumnSpaceTrimmed;
    }

    public void setNonBlankCharColumnSpacePadded(boolean nonBlankCharColumnSpacePadded) {
        this.nonBlankCharColumnSpacePadded = nonBlankCharColumnSpacePadded;
    }

    public boolean isNonBlankCharColumnSpacePadded() {
        return this.nonBlankCharColumnSpacePadded;
    }

    public boolean isAutoIncrementUpdateAllowed() {
        return this.autoIncrementUpdateAllowed;
    }

    public void setAutoIncrementUpdateAllowed(boolean autoIncrementUpdateAllowed) {
        this.autoIncrementUpdateAllowed = autoIncrementUpdateAllowed;
    }

    public void setRequiresAutoCommitForDdl(boolean requireAutoCommitForDdl) {
        this.requiresAutoCommitForDdl = requireAutoCommitForDdl;
    }

    public boolean isRequiresAutoCommitForDdl() {
        return this.requiresAutoCommitForDdl;
    }

    public void setRequiresSavePointsInTransaction(boolean requiresSavePointsInTransaction) {
        this.requiresSavePointsInTransaction = requiresSavePointsInTransaction;
    }

    public boolean isRequiresSavePointsInTransaction() {
        return this.requiresSavePointsInTransaction;
    }

    public int getMinIsolationLevelToPreventPhantomReads() {
        return this.minIsolationLevelToPreventPhantomReads;
    }

    public void setMinIsolationLevelToPreventPhantomReads(int minIsolationLevelToPreventPhantomReads) {
        this.minIsolationLevelToPreventPhantomReads = minIsolationLevelToPreventPhantomReads;
    }

    public boolean isRequiredCharColumnEmptyStringSameAsNull() {
        return this.requiredCharColumnEmptyStringSameAsNull;
    }

    public void setRequiredCharColumnEmptyStringSameAsNull(boolean requiredCharColumnEmptyStringSameAsNull) {
        this.requiredCharColumnEmptyStringSameAsNull = requiredCharColumnEmptyStringSameAsNull;
    }

    public String getBinaryQuoteStart() {
        return this.binaryQuoteStart;
    }

    public void setBinaryQuoteStart(String binaryQuoteStart) {
        this.binaryQuoteStart = binaryQuoteStart;
    }

    public String getBinaryQuoteEnd() {
        return this.binaryQuoteEnd;
    }

    public void setBinaryQuoteEnd(String binaryQuoteEnd) {
        this.binaryQuoteEnd = binaryQuoteEnd;
    }

    public void setCatalogSeparator(String catalogSeparator) {
        this.catalogSeparator = catalogSeparator;
    }

    public String getCatalogSeparator() {
        return this.catalogSeparator;
    }

    public void setSchemaSeparator(String schemaSeparator) {
        this.schemaSeparator = schemaSeparator;
    }

    public String getSchemaSeparator() {
        return this.schemaSeparator;
    }

    public boolean isNotNullColumnsSupported() {
        return this.notNullColumnsSupported;
    }

    public void setNotNullColumnsSupported(boolean notNullColumnsSupported) {
        this.notNullColumnsSupported = notNullColumnsSupported;
    }

    public boolean isZeroDateAllowed() {
        return this.zeroDateAllowed;
    }

    public void setZeroDateAllowed(boolean zeroDateAllowed) {
        this.zeroDateAllowed = zeroDateAllowed;
    }

    public boolean isTriggersCreateOrReplaceSupported() {
        return this.triggersCreateOrReplaceSupported;
    }

    public void setTriggersCreateOrReplaceSupported(boolean triggersCreateOrReplaceSupported) {
        this.triggersCreateOrReplaceSupported = triggersCreateOrReplaceSupported;
    }

    public String getCteExpression() {
        return this.cteExpression;
    }

    public void setCteExpression(String cteExpression) {
        this.cteExpression = cteExpression;
    }

    public boolean isLogBased() {
        return this.logBased;
    }

    public void setLogBased(boolean logBased) {
        this.logBased = logBased;
    }

    public boolean isTriggersContainJava() {
        return this.triggersContainJava;
    }

    public void setTriggersContainJava(boolean triggersContainJava) {
        this.triggersContainJava = triggersContainJava;
    }

    public boolean isFunctionalIndicesSupported() {
        return this.functionalIndicesSupported;
    }

    public void setFunctionalIndicesSupported(boolean functionalIndicesSupported) {
        this.functionalIndicesSupported = functionalIndicesSupported;
    }
}

