/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.h2;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.ColumnAutoIncrementChange;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.ColumnDefaultValueChange;
import org.jumpmind.db.alter.ColumnRequiredChange;
import org.jumpmind.db.alter.ColumnSizeChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.alter.TableChangeImplBase;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.ModelException;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;

public class H2DdlBuilder
extends AbstractDdlBuilder {
    private boolean isVersion2;

    public H2DdlBuilder() {
        super("h2");
        this.databaseInfo.setNonPKIdentityColumnsSupported(false);
        this.databaseInfo.setIdentityOverrideAllowed(false);
        this.databaseInfo.setSystemForeignKeyIndicesAlwaysNonUnique(true);
        this.databaseInfo.setNullAsDefaultValueRequired(false);
        this.databaseInfo.addNativeTypeMapping(2003, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(2001, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(0, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(2006, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(2002, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(70, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(-7, "BOOLEAN", -7);
        this.databaseInfo.addNativeTypeMapping(2, "DECIMAL", 3);
        this.databaseInfo.addNativeTypeMapping(-2, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(2004, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(2005, "CLOB", 2005);
        this.databaseInfo.addNativeTypeMapping(6, "DOUBLE", 8);
        this.databaseInfo.addNativeTypeMapping(2000, "OTHER");
        this.databaseInfo.setDefaultSize(1, Integer.MAX_VALUE);
        this.databaseInfo.setDefaultSize(12, Integer.MAX_VALUE);
        this.databaseInfo.setDefaultSize(-2, Integer.MAX_VALUE);
        this.databaseInfo.setDefaultSize(-3, Integer.MAX_VALUE);
        this.databaseInfo.setDefaultSize(93, 9);
        this.databaseInfo.setHasSize(93, true);
        this.databaseInfo.setHasSize(-101, true);
        this.databaseInfo.setHasSize(-102, true);
        this.databaseInfo.setMaxSize("TIMESTAMP", 9);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(false);
        this.databaseInfo.setBlankCharColumnSpacePadded(false);
        this.databaseInfo.setCharColumnSpaceTrimmed(true);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setNullAsDefaultValueRequired(true);
        this.databaseInfo.setGeneratedColumnsSupported(true);
    }

    @Override
    protected void createTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        if (this.isVersion2 && !temporary && !recreate) {
            for (int idx = 0; idx < table.getColumnCount(); ++idx) {
                Column column = table.getColumn(idx);
                if (!column.isAutoIncrement()) continue;
                this.createAutoIncrementSequence(table, column, ddl);
            }
        }
        super.createTable(table, ddl, temporary, recreate);
    }

    private void createAutoIncrementSequence(Table table, Column column, StringBuilder ddl) {
        ddl.append("CREATE SEQUENCE ");
        if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
            this.printIdentifier(table.getSchema(), ddl);
            ddl.append(".");
        }
        this.printIdentifier(this.getConstraintName(null, table, column.getName(), "SEQ"), ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void dropTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        super.dropTable(table, ddl, temporary, recreate);
        if (this.isVersion2 && !temporary && !recreate) {
            Column[] columns = table.getAutoIncrementColumns();
            for (int idx = 0; idx < columns.length; ++idx) {
                this.dropAutoIncrementSequence(table, columns[idx], ddl);
            }
        }
    }

    private void dropAutoIncrementSequence(Table table, Column column, StringBuilder ddl) {
        ddl.append("DROP SEQUENCE ");
        if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
            this.printIdentifier(table.getSchema(), ddl);
            ddl.append(".");
        }
        this.printIdentifier(this.getConstraintName(null, table, column.getName(), "SEQ"), ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            TableChangeImplBase defaultChange;
            TableChange change = changeIt.next();
            if (change instanceof AddColumnChange) {
                AddColumnChange addColumnChange = (AddColumnChange)change;
                this.processChange(currentModel, desiredModel, addColumnChange, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof CopyColumnValueChange) {
                CopyColumnValueChange copyColumnChange = (CopyColumnValueChange)change;
                this.processChange(currentModel, desiredModel, copyColumnChange, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof RemoveColumnChange) {
                this.processChange(currentModel, desiredModel, (RemoveColumnChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnDefaultValueChange) {
                defaultChange = (ColumnDefaultValueChange)change;
                ((ColumnDefaultValueChange)defaultChange).getChangedColumn().setDefaultValue(((ColumnDefaultValueChange)defaultChange).getNewDefaultValue());
                this.writeAlterColumn(change.getChangedTable(), ((ColumnDefaultValueChange)defaultChange).getChangedColumn(), ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnRequiredChange) {
                defaultChange = (ColumnRequiredChange)change;
                ((ColumnRequiredChange)defaultChange).getChangedColumn().setRequired(!((ColumnRequiredChange)defaultChange).getChangedColumn().isRequired());
                this.writeAlterColumn(change.getChangedTable(), ((ColumnRequiredChange)defaultChange).getChangedColumn(), ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnSizeChange) {
                ColumnSizeChange sizeChange = (ColumnSizeChange)change;
                sizeChange.getChangedColumn().setSizeAndScale(sizeChange.getNewSize(), sizeChange.getNewScale());
                this.writeAlterColumn(change.getChangedTable(), sizeChange.getChangedColumn(), ddl);
                changeIt.remove();
                continue;
            }
            if (!(change instanceof ColumnAutoIncrementChange)) continue;
            defaultChange = (ColumnAutoIncrementChange)change;
            ((ColumnAutoIncrementChange)defaultChange).getColumn().setAutoIncrement(!((ColumnAutoIncrementChange)defaultChange).getColumn().isAutoIncrement());
            this.writeAlterColumn(change.getChangedTable(), ((ColumnAutoIncrementChange)defaultChange).getColumn(), ddl);
            changeIt.remove();
        }
        super.processTableStructureChanges(currentModel, desiredModel, sourceTable, targetTable, changes, ddl);
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("ADD COLUMN ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn(), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()), ddl);
        this.printEndOfStatement(ddl);
        if (this.isVersion2 && change.getColumn().isAutoIncrement()) {
            this.dropAutoIncrementSequence(change.getChangedTable(), change.getColumn(), ddl);
        }
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    @Override
    protected void writeColumnDefaultValueStmt(Table table, Column column, StringBuilder ddl) {
        Object parsedDefault = column.getParsedDefaultValue();
        if (parsedDefault != null) {
            if (!(this.databaseInfo.isDefaultValuesForLongTypesSupported() || column.getMappedTypeCode() != -4 && column.getMappedTypeCode() != -1)) {
                throw new ModelException("The platform does not support default values for LONGVARCHAR or LONGVARBINARY columns");
            }
            if (this.isValidDefaultValue(column.getDefaultValue(), column.getMappedTypeCode())) {
                ddl.append(" DEFAULT ");
                this.writeColumnDefaultValue(table, column, ddl);
            }
        } else if (this.databaseInfo.isDefaultValueUsedForIdentitySpec() && column.isAutoIncrement()) {
            ddl.append(" DEFAULT ");
            this.writeColumnDefaultValue(table, column, ddl);
        } else if (!StringUtils.isBlank((CharSequence)column.getDefaultValue())) {
            ddl.append(" DEFAULT ");
            this.writeColumnDefaultValue(table, column, ddl);
        }
    }

    @Override
    public void writeExternalIndexDropStmt(Table table, IIndex index, StringBuilder ddl) {
        ddl.append("DROP INDEX IF EXISTS ");
        this.printIdentifier(this.getIndexName(index), ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
        if (this.isVersion2) {
            ddl.append("DEFAULT nextval('");
            if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
                ddl.append(table.getSchema()).append(".");
            }
            ddl.append(this.getConstraintName(null, table, column.getName(), "SEQ")).append("')");
        } else {
            ddl.append("AUTO_INCREMENT");
        }
    }

    @Override
    protected boolean writeAlterColumnDataTypeToBigInt(ColumnDataTypeChange change, StringBuilder ddl) {
        change.getChangedColumn().setTypeCode(change.getNewTypeCode());
        this.writeAlterColumn(change.getChangedTable(), change.getChangedColumn(), ddl);
        return true;
    }

    protected void writeAlterColumn(Table table, Column column, StringBuilder ddl) {
        this.writeTableAlterStmt(table, ddl);
        ddl.append("ALTER COLUMN ");
        this.writeColumn(table, column, ddl);
        this.printEndOfStatement(ddl);
    }

    public void setVersion2(boolean isVersion2) {
        this.isVersion2 = isVersion2;
    }
}

