/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mssql;

import org.jumpmind.db.model.Column;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;

public class MsSqlDmlStatement
extends DmlStatement {
    public MsSqlDmlStatement(DmlStatementOptions options) {
        super(options);
    }

    @Override
    protected String buildInsertSql(String tableName, Column[] keys, Column[] columns) {
        return this.databaseInfo.getCteExpression() != null ? this.databaseInfo.getCteExpression() + super.buildInsertSql(tableName, keys, columns) : super.buildInsertSql(tableName, keys, columns);
    }

    @Override
    protected String buildUpdateSql(String tableName, Column[] keyColumns, Column[] columns) {
        return this.databaseInfo.getCteExpression() != null ? this.databaseInfo.getCteExpression() + super.buildUpdateSql(tableName, keyColumns, columns) : super.buildUpdateSql(tableName, keyColumns, columns);
    }

    @Override
    protected String buildDeleteSql(String tableName, Column[] keyColumns) {
        return this.databaseInfo.getCteExpression() != null ? this.databaseInfo.getCteExpression() + super.buildDeleteSql(tableName, keyColumns) : super.buildDeleteSql(tableName, keyColumns);
    }

    @Override
    protected int getTypeCode(Column column, boolean isDateOverrideToTimestamp) {
        int type = column.getMappedTypeCode();
        if (type == 6) {
            return 12;
        }
        return super.getTypeCode(column, isDateOverrideToTimestamp);
    }

    @Override
    protected void appendColumnParameter(StringBuilder sql, Column column) {
        if (column.getJdbcTypeName() != null && column.getJdbcTypeName().equals("datetime2") && column.getMappedTypeCode() == 12) {
            sql.append("cast(? AS datetime2(6))").append(",");
        } else if ("datetimeoffset".equalsIgnoreCase(column.getJdbcTypeName())) {
            sql.append("cast(? AS datetimeoffset(7))").append(",");
        } else {
            super.appendColumnParameter(sql, column);
        }
    }

    @Override
    protected void appendColumnEquals(StringBuilder sql, Column column) {
        if (column.getJdbcTypeName() != null && column.getJdbcTypeName().equals("datetime2") && column.getMappedTypeCode() == 12) {
            sql.append(this.quote).append(column.getName()).append(this.quote).append(" = cast(? AS datetime2(6))");
        } else if ("datetimeoffset".equalsIgnoreCase(column.getJdbcTypeName())) {
            sql.append(this.quote).append(column.getName()).append(this.quote).append(" = cast(? AS datetimeoffset(7))");
        } else {
            super.appendColumnEquals(sql, column);
        }
    }
}

