/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mysql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddPrimaryKeyChange;
import org.jumpmind.db.alter.ColumnAutoIncrementChange;
import org.jumpmind.db.alter.ColumnChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.PrimaryKeyChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.RemovePrimaryKeyChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractDdlBuilder;

public class MySqlDdlBuilder
extends AbstractDdlBuilder {
    public MySqlDdlBuilder(String databaseName) {
        super(databaseName);
        this.init();
    }

    public MySqlDdlBuilder() {
        super("mysql");
        this.init();
    }

    protected void init() {
        this.databaseInfo.setSystemForeignKeyIndicesAlwaysNonUnique(true);
        this.databaseInfo.setMaxIdentifierLength(64);
        this.databaseInfo.setNullAsDefaultValueRequired(true);
        this.databaseInfo.setDefaultValuesForLongTypesSupported(false);
        this.databaseInfo.setNonPKIdentityColumnsSupported(false);
        this.databaseInfo.setSyntheticDefaultValueForRequiredReturned(true);
        this.databaseInfo.setCommentPrefix("#");
        this.databaseInfo.setDelimiterToken("`");
        this.databaseInfo.setZeroDateAllowed(true);
        this.databaseInfo.addNativeTypeMapping(2003, "LONGBLOB", -4);
        this.databaseInfo.addNativeTypeMapping(-7, "BIT");
        this.databaseInfo.addNativeTypeMapping(2004, "LONGBLOB", -4);
        this.databaseInfo.addNativeTypeMapping(2005, "LONGTEXT", -1);
        this.databaseInfo.addNativeTypeMapping(2001, "LONGBLOB", -4);
        this.databaseInfo.addNativeTypeMapping(6, "DOUBLE", 8);
        this.databaseInfo.addNativeTypeMapping(2000, "LONGBLOB", -4);
        this.databaseInfo.addNativeTypeMapping(-4, "MEDIUMBLOB");
        this.databaseInfo.addNativeTypeMapping(-1, "MEDIUMTEXT", -1);
        this.databaseInfo.addNativeTypeMapping(0, "MEDIUMBLOB", -4);
        this.databaseInfo.addNativeTypeMapping(2, "DECIMAL", 3);
        this.databaseInfo.addNativeTypeMapping(1111, "LONGBLOB", -4);
        this.databaseInfo.addNativeTypeMapping(7, "FLOAT");
        this.databaseInfo.addNativeTypeMapping(2006, "MEDIUMBLOB", -4);
        this.databaseInfo.addNativeTypeMapping(2002, "LONGBLOB", -4);
        this.databaseInfo.addNativeTypeMapping(93, "DATETIME");
        this.databaseInfo.addNativeTypeMapping(-101, "DATETIME", 93);
        this.databaseInfo.addNativeTypeMapping(-102, "DATETIME", 93);
        this.databaseInfo.addNativeTypeMapping(-6, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping("BOOLEAN", "BIT", "BIT");
        this.databaseInfo.addNativeTypeMapping("DATALINK", "MEDIUMBLOB", "LONGVARBINARY");
        this.databaseInfo.addNativeTypeMapping(-9, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-16, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-15, "CHAR", 1);
        this.databaseInfo.setDefaultSize(1, 254);
        this.databaseInfo.setDefaultSize(12, 254);
        this.databaseInfo.setDefaultSize(-2, 254);
        this.databaseInfo.setDefaultSize(-3, 254);
        this.databaseInfo.setHasSize(93, true);
        this.databaseInfo.setHasSize(-101, true);
        this.databaseInfo.setHasSize(-102, true);
        this.databaseInfo.setHasSize(92, true);
        this.databaseInfo.setHasSize(-103, true);
        this.databaseInfo.setMaxSize("DATETIME", 6);
        this.databaseInfo.setMaxSize("TIMESTAMP", 6);
        this.databaseInfo.setMaxSize("TIME", 6);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(false);
        this.databaseInfo.setBlankCharColumnSpacePadded(false);
        this.databaseInfo.setCharColumnSpaceTrimmed(true);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setBinaryQuoteStart("0x");
        this.databaseInfo.setBinaryQuoteEnd("");
        this.databaseInfo.setSyntheticDefaultValueForRequiredReturned(false);
        this.addEscapedCharSequence("\\", "\\\\");
        this.addEscapedCharSequence("\u0000", "\\0");
        this.addEscapedCharSequence("\"", "\\\"");
        this.addEscapedCharSequence("\b", "\\b");
        this.addEscapedCharSequence("\n", "\\n");
        this.addEscapedCharSequence("\r", "\\r");
        this.addEscapedCharSequence("\t", "\\t");
        this.addEscapedCharSequence("\u001a", "\\Z");
    }

    @Override
    public String mapDefaultValue(Object defaultValue, Column column) {
        String newValue = super.mapDefaultValue(defaultValue, column);
        if (this.databaseInfo.getDefaultValuesToTranslate().containsKey(defaultValue.toString())) {
            return newValue;
        }
        int typeCode = column.getMappedTypeCode();
        if (!(typeCode != 93 && typeCode != -101 && typeCode != -102 || column.allPlatformColumnNamesContain("mysql") || column.allPlatformColumnNamesContain("maria"))) {
            String uppercaseValue = defaultValue.toString().trim().toUpperCase();
            if (uppercaseValue.startsWith("SYSDATE")) {
                newValue = "SYSDATE()";
            } else if (uppercaseValue.startsWith("CURRENT_DATE") || uppercaseValue.startsWith("CURRENT DATE")) {
                newValue = "NOW()";
            } else if (column.anyPlatformColumnNameContains("mssql") && (uppercaseValue.startsWith("GETDATE(") || uppercaseValue.startsWith("CURRENT_TIMESTAMP"))) {
                newValue = "NOW(3)";
            } else if (uppercaseValue.startsWith("SYSTIMESTAMP") || uppercaseValue.startsWith("SYSDATETIME") || uppercaseValue.startsWith("TRANSACTION_TIMESTAMP(") || uppercaseValue.startsWith("STATEMENT_TIMESTAMP(") || uppercaseValue.startsWith("CLOCK_TIMESTAMP(") || column.anyPlatformColumnNameContains("oracle") && uppercaseValue.startsWith("CURRENT_TIMESTAMP") || uppercaseValue.startsWith("LOCALTIMESTAMP") || column.anyPlatformColumnNameContains("postgres") && !uppercaseValue.matches(".*\\d.*") && (uppercaseValue.startsWith("NOW") || uppercaseValue.startsWith("CURRENT_TIMESTAMP") || uppercaseValue.startsWith("LOCALTIMESTAMP"))) {
                newValue = "NOW(6)";
            } else if (uppercaseValue.startsWith("GETUTCDATE(")) {
                newValue = "UTC_TIMESTAMP(3)";
            } else if (uppercaseValue.startsWith("SYSUTCDATETIME(")) {
                newValue = "UTC_TIMESTAMP(6)";
            }
            if (!(!newValue.matches(".*[A-Za-z].*") || newValue.startsWith("(") && newValue.endsWith(")"))) {
                newValue = "(" + newValue + ")";
            }
        }
        return newValue;
    }

    @Override
    protected void dropTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        ddl.append("DROP TABLE IF EXISTS ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
        ddl.append("AUTO_INCREMENT");
    }

    @Override
    protected void writeColumnDefaultValueStmt(Table table, Column column, StringBuilder ddl) {
        super.writeColumnDefaultValueStmt(table, column, ddl);
        if (column.getParsedDefaultValue() == null && (!this.databaseInfo.isDefaultValueUsedForIdentitySpec() || !column.isAutoIncrement()) && StringUtils.isBlank((CharSequence)column.getDefaultValue()) && column.findPlatformColumn(this.databaseName) != null && "0000-00-00".equals(column.findPlatformColumn(this.databaseName).getDefaultValue())) {
            ddl.append(" DEFAULT ");
            this.writeColumnDefaultValue(table, column, ddl);
        }
    }

    @Override
    protected void writeColumnDefaultValue(Table table, Column column, StringBuilder ddl) {
        int typeCode = column.getMappedTypeCode();
        String defaultValue = this.getNativeDefaultValue(column);
        String defaultValueStr = this.mapDefaultValue(defaultValue, column);
        PlatformColumn platformColumn = column.findPlatformColumn(this.databaseName);
        if (TypeMap.isDateTimeType(typeCode) && defaultValueStr.toUpperCase().equals("CURRENT_TIMESTAMP") && this.hasSize(column)) {
            String nativeType = this.getNativeType(column);
            if (platformColumn != null) {
                nativeType = platformColumn.getType();
            }
            if (nativeType.startsWith("DATETIME") || nativeType.startsWith("TIMESTAMP")) {
                Integer size = column.getSizeAsInt();
                if (platformColumn != null) {
                    size = platformColumn.getSize();
                } else if (column.getSize() == null) {
                    size = this.databaseInfo.getDefaultSize(column.getMappedTypeCode());
                }
                if (size != null && size >= 0) {
                    int maxSize = this.databaseInfo.getMaxSize(nativeType);
                    if (maxSize > 0 && size > maxSize) {
                        size = maxSize;
                    }
                    ddl.append(defaultValueStr).append("(").append(size).append(")");
                    return;
                }
            }
        } else if (this.databaseInfo.isExpressionsAsDefaultValuesSupported() && platformColumn != null && column.isExpressionAsDefaultValue()) {
            if (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
                ddl.append(defaultValueStr);
            } else {
                ddl.append("(").append(defaultValueStr).append(")");
            }
            return;
        }
        this.printDefaultValue(defaultValue, column, ddl);
    }

    @Override
    protected boolean shouldUseQuotes(String defaultValue, Column column) {
        String defaultValueStr;
        for (defaultValueStr = this.mapDefaultValue(defaultValue, column); defaultValueStr != null && defaultValueStr.startsWith("(") && defaultValueStr.endsWith(")"); defaultValueStr = defaultValueStr.substring(1, defaultValueStr.length() - 1)) {
        }
        return super.shouldUseQuotes(defaultValue, column) && !defaultValueStr.trim().toUpperCase().startsWith("UTC_TIMESTAMP");
    }

    @Override
    protected boolean shouldGeneratePrimaryKeys(Column[] primaryKeyColumns) {
        return true;
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        String autoIncrementKeyName = "";
        if (table.getAutoIncrementColumns().length > 0) {
            autoIncrementKeyName = table.getAutoIncrementColumns()[0].getName();
        }
        return "SELECT LAST_INSERT_ID() " + autoIncrementKeyName;
    }

    @Override
    protected void writeExternalForeignKeyDropStmt(Table table, ForeignKey foreignKey, StringBuilder ddl) {
        this.writeTableAlterStmt(table, ddl);
        ddl.append("DROP FOREIGN KEY ");
        this.printIdentifier(this.getForeignKeyName(table, foreignKey), ddl);
        this.printEndOfStatement(ddl);
        if (foreignKey.isAutoIndexPresent()) {
            this.writeTableAlterStmt(table, ddl);
            ddl.append("DROP INDEX ");
            this.printIdentifier(this.getForeignKeyName(table, foreignKey), ddl);
            this.printEndOfStatement(ddl);
        }
    }

    @Override
    protected boolean isFullTextIndex(IIndex index) {
        for (int idx = 0; idx < index.getColumnCount(); ++idx) {
            Column column;
            IndexColumn indexColumn = index.getColumn(idx);
            if (indexColumn == null || (column = indexColumn.getColumn()) == null || column.getMappedTypeCode() != -1) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        Column targetColumn;
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            TableChange change = changeIt.next();
            if (change instanceof AddColumnChange) {
                this.processChange(currentModel, desiredModel, (AddColumnChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change instanceof ColumnAutoIncrementChange)) continue;
            try {
                Column sourceColumn = ((ColumnAutoIncrementChange)change).getColumn();
                targetColumn = (Column)sourceColumn.clone();
                targetColumn.setAutoIncrement(!sourceColumn.isAutoIncrement());
                this.processColumnChange(sourceTable, targetTable, sourceColumn, targetColumn, ddl);
                changeIt.remove();
            }
            catch (CloneNotSupportedException e) {
                this.log.error("", (Throwable)e);
            }
        }
        ArrayList<Column> changedColumns = new ArrayList<Column>();
        Iterator<TableChange> changeIt2 = changes.iterator();
        while (changeIt2.hasNext()) {
            TableChange change = changeIt2.next();
            if (change instanceof RemoveColumnChange) {
                this.processChange(currentModel, desiredModel, (RemoveColumnChange)change, ddl);
                changeIt2.remove();
                continue;
            }
            if (change instanceof CopyColumnValueChange) {
                CopyColumnValueChange copyColumnChange = (CopyColumnValueChange)change;
                this.processChange(currentModel, desiredModel, copyColumnChange, ddl);
                changeIt2.remove();
                continue;
            }
            if (change instanceof AddPrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (AddPrimaryKeyChange)change, ddl);
                changeIt2.remove();
                continue;
            }
            if (change instanceof PrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (PrimaryKeyChange)change, ddl);
                changeIt2.remove();
                continue;
            }
            if (change instanceof RemovePrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (RemovePrimaryKeyChange)change, ddl);
                changeIt2.remove();
                continue;
            }
            if (!(change instanceof ColumnChange)) continue;
            Column column = ((ColumnChange)change).getChangedColumn();
            if (!changedColumns.contains(column)) {
                changedColumns.add(column);
            }
            changeIt2.remove();
        }
        for (Column sourceColumn : changedColumns) {
            targetColumn = targetTable.findColumn(sourceColumn.getName(), false);
            this.processColumnChange(sourceTable, targetTable, sourceColumn, targetColumn, ddl);
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("ADD COLUMN ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn(), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemovePrimaryKeyChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP PRIMARY KEY");
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, PrimaryKeyChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP PRIMARY KEY");
        this.printEndOfStatement(ddl);
        this.writeExternalPrimaryKeysCreateStmt(change.getChangedTable(), change.getNewPrimaryKeyColumns(), ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processColumnChange(Table sourceTable, Table targetTable, Column sourceColumn, Column targetColumn, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(sourceTable));
        this.printIndent(ddl);
        ddl.append("MODIFY COLUMN ");
        this.writeColumn(targetTable, targetColumn, ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    public String getSqlType(Column column) {
        String[] enumValues;
        PlatformColumn pc;
        String sqlType = super.getSqlType(column);
        if (column.isAutoIncrement() && (column.getMappedTypeCode() == 3 || column.getMappedTypeCode() == 2)) {
            sqlType = "BIGINT";
        }
        if (column.getMappedTypeCode() == 93 && column.getScale() > 0) {
            sqlType = "DATETIME(" + column.getScale() + ")";
        }
        PlatformColumn platformColumn = pc = column.getPlatformColumns() == null ? null : column.getPlatformColumns().get("mysql");
        if (pc != null && ("ENUM".equalsIgnoreCase(column.getJdbcTypeName()) || "ENUM".equalsIgnoreCase(pc.getType())) && (enumValues = pc.getEnumValues()) != null && enumValues.length > 0) {
            StringBuilder tmpSqlType = new StringBuilder();
            tmpSqlType.append("ENUM");
            tmpSqlType.append("(");
            boolean appendComma = false;
            for (String s : enumValues) {
                if (appendComma) {
                    tmpSqlType.append(",");
                }
                tmpSqlType.append("'").append(s).append("'");
                appendComma = true;
            }
            tmpSqlType.append(")");
            sqlType = tmpSqlType.toString();
        }
        if ("TINYBLOB".equalsIgnoreCase(column.getJdbcTypeName())) {
            sqlType = "TINYBLOB";
        } else if (pc == null && (column.getMappedTypeCode() == 1 || column.getMappedTypeCode() == -15) && column.getSizeAsInt() > 255) {
            sqlType = column.getSizeAsInt() <= 8000 ? "VARCHAR(" + column.getSizeAsInt() + ")" : (column.getSizeAsInt() <= 0x1000000 ? "MEDIUMTEXT" : "LONGTEXT");
        }
        PlatformColumn platformColumn2 = pc = column.getPlatformColumns() == null ? null : column.getPlatformColumns().get("oracle");
        if (pc == null) {
            PlatformColumn platformColumn3 = pc = column.getPlatformColumns() == null ? null : column.getPlatformColumns().get("oracle122");
        }
        if (pc != null) {
            if ("NVARCHAR2".equals(pc.getType())) {
                sqlType = "NVARCHAR(" + pc.getSize() + ")";
            } else if ("LONG".equals(pc.getType()) || "CLOB".equals(pc.getType()) || "NCLOB".equals(pc.getType()) || "XMLTYPE".equals(pc.getType())) {
                sqlType = "LONGTEXT";
            } else if ("FLOAT".equals(pc.getType()) && pc.getSize() >= 63) {
                sqlType = "DOUBLE";
            }
        }
        return sqlType;
    }
}

