/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.postgresql;

import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.platform.postgresql.PostgreSqlDmlStatement;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;

public class PostgreSqlDmlStatement95
extends PostgreSqlDmlStatement {
    public static final String ON_CONFLICT_DO_NOTHING = "on conflict do nothing";

    public PostgreSqlDmlStatement95(DmlStatementOptions options) {
        super(options);
    }

    @Override
    public String buildInsertSql(String tableName, Column[] keys, Column[] columns) {
        StringBuilder sql = new StringBuilder("insert into " + tableName + " (");
        this.appendColumns(sql, columns, false);
        sql.append(") values (");
        this.appendColumnParameters(sql, columns);
        sql.append(") ").append(ON_CONFLICT_DO_NOTHING);
        return sql.toString();
    }

    @Override
    public String getSql(boolean allowIgnoreOnConflict) {
        if (allowIgnoreOnConflict) {
            return this.sql;
        }
        return this.sql.replace(ON_CONFLICT_DO_NOTHING, "");
    }

    @Override
    public Column[] getMetaData() {
        if (this.dmlType == DmlStatement.DmlType.INSERT) {
            return this.getColumns();
        }
        return super.getMetaData();
    }

    @Override
    public <T> T[] getValueArray(T[] columnValues, T[] keyValues) {
        if (this.dmlType == DmlStatement.DmlType.INSERT) {
            return columnValues;
        }
        return super.getValueArray(columnValues, keyValues);
    }

    @Override
    public Object[] getValueArray(Map<String, Object> params) {
        if (this.dmlType == DmlStatement.DmlType.INSERT) {
            int index = 0;
            Object[] args = new Object[this.columns.length];
            for (Column column : this.columns) {
                args[index++] = params.get(column.getName());
            }
            return args;
        }
        return super.getValueArray(params);
    }

    @Override
    protected int[] buildTypes(Column[] keys, Column[] columns, boolean isDateOverrideToTimestamp) {
        if (this.dmlType == DmlStatement.DmlType.INSERT) {
            return this.buildTypes(columns, isDateOverrideToTimestamp);
        }
        return super.buildTypes(keys, columns, isDateOverrideToTimestamp);
    }
}

