/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.sql.DataTruncationException;
import org.jumpmind.db.sql.IConnectionHandler;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.LogSqlBuilder;
import org.jumpmind.db.sql.NamedParameterUtils;
import org.jumpmind.db.sql.ParsedSql;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlList;
import org.jumpmind.db.sql.SqlToken;
import org.jumpmind.db.sql.UniqueKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqlTemplate
implements ISqlTemplate {
    protected static final Logger log = LoggerFactory.getLogger((String)AbstractSqlTemplate.class.getPackage().getName());
    protected boolean dateOverrideToTimestamp;
    protected String identifierQuoteString;
    protected LogSqlBuilder logSqlBuilder = new LogSqlBuilder();

    @Override
    public <T> T queryForObject(String sql, ISqlRowMapper<T> mapper, Object ... args) {
        List<T> list = this.query(sql, mapper, args);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public String queryForString(String sql, Object ... args) {
        return this.queryForObject(sql, String.class, args);
    }

    @Override
    public int queryForInt(String sql, Map<String, Object> params) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        String newSql = NamedParameterUtils.substituteNamedParameters(parsedSql, params);
        Object[] args = NamedParameterUtils.buildValueArray(parsedSql, params);
        return this.queryForInt(newSql, args);
    }

    @Override
    public int queryForInt(String sql, Object ... args) {
        Integer number = this.queryForObject(sql, Integer.class, args);
        if (number != null) {
            return number;
        }
        return 0;
    }

    @Override
    public long queryForLong(String sql, Object ... args) {
        Long number = this.queryForObject(sql, Long.class, args);
        if (number != null) {
            return number;
        }
        return 0L;
    }

    public Map<String, Object> queryForMap(String sql, final String keyColumn, final String valueColumn, Object ... args) {
        final HashMap<String, Object> map = new HashMap<String, Object>();
        this.query(sql, new ISqlRowMapper<Object>(){

            @Override
            public Object mapRow(Row rs) {
                map.put(rs.getString(keyColumn), rs.getString(valueColumn));
                return null;
            }
        }, args);
        return map;
    }

    @Override
    public <T> Map<String, T> queryForMap(String sql, final ISqlRowMapper<T> mapper, final String keyColumn, Object ... args) {
        final HashMap result = new HashMap();
        this.query(sql, new ISqlRowMapper<T>(){

            @Override
            public T mapRow(Row row) {
                String keyName = row.getString(keyColumn);
                Object object = mapper.mapRow(row);
                result.put(keyName, object);
                return object;
            }
        }, args);
        return result;
    }

    @Override
    public <T> ISqlReadCursor<T> queryForCursor(String sql, ISqlRowMapper<T> mapper) {
        return this.queryForCursor(sql, mapper, null, null);
    }

    @Override
    public <T> ISqlReadCursor<T> queryForCursor(String sql, ISqlRowMapper<T> mapper, IConnectionHandler connectionHandler, Object[] args, int[] types) {
        return this.queryForCursor(sql, mapper, args, types);
    }

    @Override
    public <T> ISqlReadCursor<T> queryForCursor(String sql, ISqlRowMapper<T> mapper, boolean returnLobObjects) {
        return this.queryForCursor(sql, mapper);
    }

    @Override
    public <T> ISqlReadCursor<T> queryForCursor(String sql, ISqlRowMapper<T> mapper, Map<String, Object> namedParams) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        String newSql = NamedParameterUtils.substituteNamedParameters(parsedSql, namedParams);
        Object[] params = NamedParameterUtils.buildValueArray(parsedSql, namedParams);
        return this.queryForCursor(newSql, mapper, null, params, null);
    }

    @Override
    public List<Row> query(String sql) {
        return this.query(sql, (Object[])null, (int[])null);
    }

    @Override
    public <T> List<T> query(String sql, ISqlRowMapper<T> mapper, Object ... args) {
        return this.query(sql, mapper, args, (int[])null);
    }

    @Override
    public <T> List<T> queryWithHandler(String sql, ISqlRowMapper<T> mapper, IConnectionHandler conHandler, Object ... params) {
        return this.query(sql, mapper, conHandler, params, null);
    }

    @Override
    public Row queryForRow(String sql, Object ... args) {
        return this.queryForObject(sql, new ISqlRowMapper<Row>(){

            @Override
            public Row mapRow(Row row) {
                return row;
            }
        }, args);
    }

    @Override
    public <T, W> Map<T, W> query(String sql, String keyCol, String valueCol, Object[] args, int[] types) {
        List<Row> rows = this.query(sql, args, types);
        HashMap<Object, Object> map = new HashMap<Object, Object>(rows.size());
        for (Row row : rows) {
            map.put(row.get(keyCol), row.get(valueCol));
        }
        return map;
    }

    @Override
    public <T> List<T> query(String sql, int maxRowsToFetch, ISqlRowMapper<T> mapper, Object ... params) {
        return this.query(sql, maxRowsToFetch, mapper, params, (int[])null);
    }

    @Override
    public <T> List<T> query(String sql, int maxRowsToFetch, ISqlRowMapper<T> mapper, Map<String, Object> namedParams) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        String newSql = NamedParameterUtils.substituteNamedParameters(parsedSql, namedParams);
        Object[] params = NamedParameterUtils.buildValueArray(parsedSql, namedParams);
        return this.query(newSql, maxRowsToFetch, mapper, params, (int[])null);
    }

    @Override
    public <T> List<T> query(String sql, ISqlRowMapper<T> mapper, Map<String, ?> namedParams) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        String newSql = NamedParameterUtils.substituteNamedParameters(parsedSql, namedParams);
        Object[] params = NamedParameterUtils.buildValueArray(parsedSql, namedParams);
        return this.query(newSql, mapper, params, (int[])null);
    }

    @Override
    public List<Row> query(String sql, Object[] args, int[] types) {
        return this.query(sql, new ISqlRowMapper<Row>(){

            @Override
            public Row mapRow(Row row) {
                return row;
            }
        }, args, types);
    }

    @Override
    public List<Row> query(String sql, Object[] args) {
        return this.query(sql, new ISqlRowMapper<Row>(){

            @Override
            public Row mapRow(Row row) {
                return row;
            }
        }, args);
    }

    @Override
    public <T> List<T> query(String sql, ISqlRowMapper<T> mapper, Object[] args, int[] types) {
        return this.query(sql, -1, mapper, args, types);
    }

    public <T> List<T> query(String sql, ISqlRowMapper<T> mapper, IConnectionHandler handler, Object[] args, int[] types) {
        return this.query(sql, -1, mapper, handler, args, types);
    }

    @Override
    public <T> List<T> query(String sql, int maxNumberOfRowsToFetch, ISqlRowMapper<T> mapper, Object[] args, int[] types) {
        IConnectionHandler handler = null;
        return this.query(sql, maxNumberOfRowsToFetch, mapper, handler, args, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> query(String sql, int maxNumberOfRowsToFetch, ISqlRowMapper<T> mapper, IConnectionHandler handler, Object[] args, int[] types) {
        try (ISqlReadCursor<T> cursor = this.queryForCursor(sql, mapper, handler, args, types);){
            Object next = null;
            ArrayList<Object> list = new ArrayList<Object>();
            int rowCount = 0;
            do {
                if ((next = (Object)cursor.next()) == null) continue;
                list.add(next);
                ++rowCount;
            } while ((maxNumberOfRowsToFetch <= 0 || rowCount < maxNumberOfRowsToFetch) && next != null);
            ArrayList<Object> arrayList = list;
            return arrayList;
        }
    }

    @Override
    public int update(String sql, Object ... values) {
        return this.update(sql, values, (int[])null);
    }

    protected String expandSql(String sql, Object[] args) {
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                if (arg instanceof SqlList) {
                    SqlList list = (SqlList)arg;
                    StringBuilder sqllist = new StringBuilder();
                    for (int i = 0; i < list.size(); ++i) {
                        sqllist.append("?");
                        if (i >= list.size() - 1) continue;
                        sqllist.append(",");
                    }
                    sql = sql.replaceFirst(list.getReplacementToken(), sqllist.toString());
                    continue;
                }
                if (!(arg instanceof SqlToken)) continue;
                SqlToken token = (SqlToken)arg;
                sql = sql.replaceFirst(token.getReplacementToken(), "?");
            }
        }
        return sql;
    }

    protected Object[] expandArgs(String sql, Object[] args) {
        if (args != null && args.length > 0) {
            ArrayList<Object> argsList = null;
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg instanceof SqlList) {
                    SqlList list;
                    if (argsList == null) {
                        argsList = new ArrayList<Object>();
                        for (int j = 0; j < i; ++j) {
                            argsList.add(args[j]);
                        }
                    }
                    if (!sql.contains((list = (SqlList)arg).getReplacementToken())) continue;
                    for (Object listItem : list) {
                        argsList.add(listItem);
                    }
                    continue;
                }
                if (arg instanceof SqlToken) {
                    SqlToken token;
                    if (argsList == null) {
                        argsList = new ArrayList();
                        for (int j = 0; j < i; ++j) {
                            argsList.add(args[j]);
                        }
                    }
                    if (!sql.contains((token = (SqlToken)arg).getReplacementToken())) continue;
                    argsList.add(token.getValue());
                    continue;
                }
                if (argsList == null) continue;
                argsList.add(arg);
            }
            if (argsList != null) {
                args = argsList.toArray(new Object[argsList.size()]);
            }
        }
        return args;
    }

    @Override
    public SqlException translate(Throwable ex) {
        return this.translate(ex.getMessage(), ex);
    }

    public SqlException translate(String message, Throwable ex) {
        if (this.isUniqueKeyViolation(ex) && !(ex instanceof UniqueKeyException)) {
            return new UniqueKeyException(ex);
        }
        if (this.isDataTruncationViolation(ex)) {
            return new DataTruncationException(ex);
        }
        if (ex instanceof SqlException) {
            return (SqlException)ex;
        }
        return new SqlException(message, ex);
    }

    @Override
    public String getUniqueKeyViolationIndexName(Throwable ex) {
        return null;
    }

    @Override
    public boolean isForeignKeyChildExistsViolation(Throwable ex) {
        return false;
    }

    @Override
    public boolean isDeadlock(Throwable ex) {
        return false;
    }

    @Override
    public boolean doesObjectAlreadyExist(Throwable ex) {
        return false;
    }

    @Override
    public boolean doesObjectNotExist(Throwable ex) {
        return false;
    }
}

