/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.sql.DmlStatement;

public class DmlStatementOptions {
    protected DmlStatement.DmlType dmlType;
    protected String tableName;
    protected Column[] columns;
    protected DatabaseInfo databaseInfo = new DatabaseInfo();
    protected String catalogName;
    protected String schemaName;
    protected Column[] keys;
    protected boolean[] nullKeyValues;
    protected boolean useQuotedIdentifiers;
    protected boolean namedParameters;
    protected String textColumnExpression;

    public DmlStatementOptions(DmlStatement.DmlType dmlType, String tableName) {
        this.dmlType = dmlType;
        this.tableName = tableName;
    }

    public DmlStatementOptions(DmlStatement.DmlType dmlType, Table table) {
        this.dmlType = dmlType;
        this.tableName = table.getName();
        this.catalogName = table.getCatalog();
        this.schemaName = table.getSchema();
        this.columns = table.getColumns();
        this.keys = table.getPrimaryKeyColumns();
    }

    public DmlStatementOptions databaseInfo(DatabaseInfo databaseInfo) {
        this.databaseInfo = databaseInfo;
        return this;
    }

    public DmlStatementOptions catalogName(String catalogName) {
        this.catalogName = catalogName;
        return this;
    }

    public DmlStatementOptions schemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public DmlStatementOptions columns(Column[] columns) {
        this.columns = columns;
        return this;
    }

    public DmlStatementOptions keys(Column[] keys) {
        this.keys = keys;
        return this;
    }

    public DmlStatementOptions nullKeyValues(boolean[] nullKeyValues) {
        this.nullKeyValues = nullKeyValues;
        return this;
    }

    public DmlStatementOptions quotedIdentifiers(boolean useQuotedIdentifiers) {
        this.useQuotedIdentifiers = useQuotedIdentifiers;
        return this;
    }

    public DmlStatementOptions namedParameters(boolean namedParameters) {
        this.namedParameters = namedParameters;
        return this;
    }

    public DmlStatementOptions textColumnExpression(String textColumnExpression) {
        this.textColumnExpression = textColumnExpression;
        return this;
    }

    public DmlStatement.DmlType getDmlType() {
        return this.dmlType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Column[] getKeys() {
        return this.keys;
    }

    public boolean[] getNullKeyValues() {
        return this.nullKeyValues;
    }

    public boolean useQuotedIdentifiers() {
        return this.useQuotedIdentifiers;
    }

    public boolean isNamedParameters() {
        return this.namedParameters;
    }

    public String getTextColumnExpression() {
        return this.textColumnExpression;
    }
}

