/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.db.util.TableRow;
import org.jumpmind.symmetric.io.data.DmlWeight;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbFill {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private String catalog;
    private String schema;
    private IDatabasePlatform platform;
    private boolean ignoreMissingTables;
    private boolean cascading = false;
    private boolean cascadingSelect = false;
    private boolean truncate = false;
    private String[] ignore = null;
    private String[] prefixed = null;
    private int inputLength = 1;
    private int repeat = 1;
    private int maxRowsCommit = 1;
    private int commitDelay = 0;
    private int percentRollback = 0;
    private SecureRandom rand = null;
    private int interval = 0;
    private boolean debug = false;
    private boolean verbose = false;
    private boolean continueOnError = false;
    private boolean print = false;
    private boolean useRandomCount = false;
    private int maxByteSize = 32;
    private int maxTextSize = 32;
    private String textColumnExpression;
    private DmlWeight dmlWeight = new DmlWeight(1, 0, 0);
    private Map<String, Table> allDbTablesCache = null;
    private Map<String, Map<String, Object>> currentRowValues = new HashMap<String, Map<String, Object>>();
    private Map<String, List<ForeignKeyReference>> foreignKeyReferences = new TreeMap<String, List<ForeignKeyReference>>();
    private Map<Table, List<Table>> foreignTables = new HashMap<Table, List<Table>>();
    private Map<Table, List<Table>> foreignTablesReversed = new HashMap<Table, List<Table>>();
    private Map<String, List<Object>> commonDependencyValues = new TreeMap<String, List<Object>>();
    private Set<Table> commonDependencyTables = new HashSet<Table>();
    private Map<Table, HashSet<ForeignKey>> compositeForeignKeys = new HashMap<Table, HashSet<ForeignKey>>();
    private Map<String, Integer> minColumnSizes = new HashMap<String, Integer>();
    private static final int RANDOM_SELECT_SIZE = 100;
    public static final int INSERT = 0;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;

    public DbFill() {
    }

    public DbFill(IDatabasePlatform platform) {
        this.platform = platform;
    }

    public void fillTables(String ... tableNames) {
        this.fillTables(tableNames, (Map<String, DmlWeight>)null);
    }

    public void fillTables(String[] tableNames, Map<String, DmlWeight> tableProperties) {
        ArrayList<Table> tablesToFill = new ArrayList<Table>();
        if (this.verbose) {
            this.log.info("Looking up table definitions from database");
        }
        if (tableNames.length == 0) {
            Map<String, Table> allTables = this.getAllDbTables();
            if (this.ignore != null) {
                block0: for (Table table : allTables.values()) {
                    for (String ignoreName : this.ignore) {
                        if (!table.getName().startsWith(ignoreName)) continue;
                        if (!this.verbose) continue block0;
                        this.log.info("Ignore table " + table.getName());
                        continue block0;
                    }
                    if (this.prefixed != null) {
                        for (String prefixedName : this.prefixed) {
                            if (table.getName().startsWith(prefixedName)) continue;
                            if (!this.verbose) continue block0;
                            this.log.info("Non prefixed table (" + prefixedName + ")" + table.getName());
                            continue block0;
                        }
                    }
                    tablesToFill.add(table);
                }
            }
        } else {
            for (String tableName : tableNames) {
                Table table = this.platform.readTableFromDatabase(this.getCatalogToUse(), this.getSchemaToUse(), tableName);
                if (table != null) {
                    table = this.filterColumns(table);
                    tablesToFill.add(table);
                    continue;
                }
                if (this.ignoreMissingTables) continue;
                throw new RuntimeException("Cannot find table " + (String)tableName + " in catalog " + this.getCatalogToUse() + " and schema " + this.getSchemaToUse());
            }
        }
        if (this.cascading || this.cascadingSelect) {
            this.log.info("Resolving foreign key references");
            this.buildForeignTables(tablesToFill);
        } else {
            this.log.info("Checking for foreign key constraints");
            List<Table> missingTables = this.getForeignKeyTables(tablesToFill, new HashSet<Table>());
            if (missingTables.size() > 0) {
                ArrayList<String> missingTableNames = new ArrayList<String>();
                for (Table missingTable : missingTables) {
                    missingTableNames.add(missingTable.getName());
                }
                this.log.warn("Foreign tables are missing from the list (see --select or --cascade options): " + missingTableNames);
            }
        }
        this.log.info("TABLES TO FILL (" + tablesToFill.size() + "): " + this.toString(tablesToFill));
        List<Table> orderedTables = Database.sortByForeignKeys(tablesToFill, this.getAllDbTables(), null, null);
        orderedTables = this.removeSymTables(orderedTables);
        ArrayList<Table> dependencyTables = new ArrayList<Table>();
        for (Table table : orderedTables) {
            if (tablesToFill.contains(table)) continue;
            dependencyTables.add(table);
        }
        this.log.info("DEPENDENCIES (" + dependencyTables.size() + " tables): " + this.toString(dependencyTables));
        this.buildForeignKeyReferences(orderedTables);
        this.buildDependentColumnValues(orderedTables);
        this.buildMinColumnSizes(orderedTables);
        this.fillTables(tablesToFill, orderedTables, tableProperties);
    }

    protected List<Table> removeSymTables(List<Table> tables) {
        ArrayList<Table> filteredTables = new ArrayList<Table>();
        for (Table table : tables) {
            if (table.getNameLowerCase().startsWith("sym_")) continue;
            filteredTables.add(table);
        }
        return filteredTables;
    }

    protected String toString(List<Table> tables) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Table table : tables) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(table.getName());
        }
        return sb.toString();
    }

    protected void buildForeignTables(List<Table> tables) {
        for (Table table : tables) {
            ArrayList<Table> tableList = new ArrayList<Table>();
            tableList.add(table);
            List<Table> list = this.getForeignKeyTables(tableList, new HashSet<Table>());
            this.foreignTables.put(table, list);
            List<Table> reversedList = this.getForeignKeyTablesReversed(tableList, new HashSet<Table>());
            this.foreignTablesReversed.put(table, reversedList);
        }
    }

    protected void buildForeignKeyReferences(List<Table> tables) {
        for (Table table : tables) {
            for (ForeignKey fk : table.getForeignKeys()) {
                for (Reference ref : fk.getReferences()) {
                    String key = table.getQualifiedTableName() + "." + ref.getLocalColumnName();
                    List<ForeignKeyReference> fkrs = this.foreignKeyReferences.get(key);
                    if (fkrs == null) {
                        fkrs = new ArrayList<ForeignKeyReference>();
                        this.foreignKeyReferences.put(key, fkrs);
                    }
                    fkrs.add(new ForeignKeyReference(fk, ref));
                }
                if (fk.getReferences().length <= 1) continue;
                if (this.compositeForeignKeys.get(table) == null) {
                    this.compositeForeignKeys.put(table, new HashSet());
                }
                this.compositeForeignKeys.get(table).add(fk);
            }
        }
    }

    protected void buildDependentColumnValues(List<Table> tables) {
        for (Table table : tables) {
            HashMap<String, ArrayList<ForeignKeyReference>> columnReferences = new HashMap<String, ArrayList<ForeignKeyReference>>();
            for (ForeignKey fk : table.getForeignKeys()) {
                for (Reference ref : fk.getReferences()) {
                    ArrayList<ForeignKeyReference> references = (ArrayList<ForeignKeyReference>)columnReferences.get(ref.getLocalColumnName());
                    if (references == null) {
                        references = new ArrayList<ForeignKeyReference>();
                        columnReferences.put(ref.getLocalColumnName(), references);
                    }
                    references.add(new ForeignKeyReference(fk, ref));
                }
            }
            for (String columnName : columnReferences.keySet()) {
                List references = (List)columnReferences.get(columnName);
                if (references.size() <= 1) continue;
                ArrayList commonValue = new ArrayList();
                StringBuilder sb = null;
                for (ForeignKeyReference fkr : references) {
                    ForeignKey fk = fkr.getForeignKey();
                    String key = table.getFullyQualifiedTableName() + "." + fkr.getReference().getForeignColumnName();
                    this.commonDependencyValues.put(key, commonValue);
                    this.commonDependencyTables.add(this.getDbTable(fk.getForeignTableCatalog(), fk.getForeignTableSchema(), fk.getForeignTableName()));
                    if (!this.verbose) continue;
                    sb = sb == null ? new StringBuilder() : sb.append(", ");
                    sb.append(fkr.getReference().getLocalColumnName() + " -> " + fkr.getForeignKey().getForeignTableName() + "." + fkr.getReference().getForeignColumnName());
                }
                if (!this.verbose) continue;
                this.log.info("Common dependency for table {}: {}", (Object)table.getName(), sb);
            }
        }
    }

    protected void buildMinColumnSizes(List<Table> tables) {
        for (Table table : tables) {
            HashSet<String> columnNames = new HashSet<String>();
            for (ForeignKey fk : table.getForeignKeys()) {
                for (Reference ref : fk.getReferences()) {
                    columnNames.add(ref.getLocalColumnName());
                }
            }
            for (String columnName : columnNames) {
                Column column = table.findColumn(columnName);
                this.buildMinColumnSize(table, column, new HashSet<String>(), null);
            }
        }
    }

    protected int buildMinColumnSize(Table table, Column column, Set<String> relatedTableColumns, Integer minSize) {
        if (relatedTableColumns.add(table.getQualifiedTableName() + "." + column.getName())) {
            Integer size = column.getSizeAsInt();
            if (minSize != null && minSize < size) {
                size = minSize;
            }
            for (ForeignKey fk : table.getForeignKeys()) {
                for (Reference ref : fk.getReferences()) {
                    if (!ref.getLocalColumnName().equals(column.getName())) continue;
                    Table foreignTable = this.getDbTable(fk.getForeignTableCatalog(), fk.getForeignTableSchema(), fk.getForeignTableName());
                    Column foreignColumn = foreignTable.findColumn(ref.getForeignColumnName());
                    size = this.buildMinColumnSize(foreignTable, foreignColumn, relatedTableColumns, size);
                }
            }
            if (minSize == null) {
                for (String relatedTableColumn : relatedTableColumns) {
                    this.minColumnSizes.put(relatedTableColumn, size);
                }
            }
            minSize = size;
        }
        return minSize;
    }

    protected List<Table> getForeignKeyTables(List<Table> tables, Set<Table> visited) {
        HashSet<Table> fkDepSet = new HashSet<Table>(tables);
        ArrayList<Table> fkDepList = new ArrayList<Table>();
        for (Table table : tables) {
            if (table == null || !visited.add(table)) continue;
            for (ForeignKey fk : table.getForeignKeys()) {
                Table foreignTable = this.getDbTable(fk.getForeignTableCatalog(), fk.getForeignTableSchema(), fk.getForeignTableName());
                if (!fkDepSet.add(foreignTable)) continue;
                fkDepList.add(foreignTable);
            }
        }
        if (fkDepList.size() > 0) {
            fkDepList.addAll(this.getForeignKeyTables(fkDepList, visited));
        }
        Collections.reverse(fkDepList);
        return fkDepList;
    }

    protected List<Table> getForeignKeyTablesReversed(List<Table> tables, Set<Table> visited) {
        ArrayList<Table> fkDepList = new ArrayList<Table>();
        for (Table table : tables) {
            if (table == null || !visited.add(table)) continue;
            String parentTableName = table.getName();
            block1: for (Table child : this.getAllDbTables().values()) {
                for (ForeignKey fk : child.getForeignKeys()) {
                    if (!parentTableName.equalsIgnoreCase(fk.getForeignTableName())) continue;
                    fkDepList.add(child);
                    continue block1;
                }
            }
        }
        if (fkDepList.size() > 0) {
            fkDepList.addAll(this.getForeignKeyTablesReversed(fkDepList, visited));
        }
        return fkDepList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTables(List<Table> tablesToFill, List<Table> orderedTables, Map<String, DmlWeight> tableProperties) {
        if (this.truncate) {
            ListIterator<Table> iterator = tablesToFill.listIterator(tablesToFill.size());
            while (iterator.hasPrevious()) {
                Table table = iterator.previous();
                this.truncateTable(table);
            }
        }
        try (ISqlTransaction tran = this.platform.getSqlTemplate().startSqlTransaction();){
            DatabaseInfo dbInfo = this.platform.getDatabaseInfo();
            String quote = dbInfo.getDelimiterToken();
            String catalogSeparator = dbInfo.getCatalogSeparator();
            String schemaSeparator = dbInfo.getSchemaSeparator();
            int rowsInTransaction = 0;
            int rowsTotal = 0;
            for (int x = 0; x < this.repeat; ++x) {
                int numRowsToGenerate = this.inputLength;
                int numRowsToCommit = this.maxRowsCommit;
                if (this.useRandomCount) {
                    numRowsToGenerate = this.getRand().nextInt(this.inputLength);
                    numRowsToGenerate = numRowsToGenerate > 0 ? numRowsToGenerate : 1;
                    numRowsToCommit = this.getRand().nextInt(this.maxRowsCommit);
                    numRowsToCommit = numRowsToCommit > 0 ? numRowsToCommit : 1;
                }
                for (int i = 0; i < numRowsToGenerate; ++i) {
                    for (Table table : orderedTables) {
                        if (table.hasAutoIncrementColumn()) {
                            this.log.info("Turning on identity insert for table " + table.getName());
                            tran.allowInsertIntoAutoIncrementColumns(true, table, quote, catalogSeparator, schemaSeparator);
                        }
                        int dmlType = 0;
                        if (tableProperties != null && tableProperties.containsKey(table.getName())) {
                            dmlType = this.randomIUD(tableProperties.get(table.getName()));
                        } else if (this.dmlWeight != null) {
                            dmlType = this.randomIUD(this.dmlWeight);
                        }
                        if (this.cascadingSelect && dmlType == 0 && !tablesToFill.contains(table)) {
                            if (this.currentRowValues.get(table.getName()) != null) continue;
                            this.selectRandomRecord(tran, table);
                            continue;
                        }
                        switch (dmlType) {
                            case 0: {
                                if (this.verbose) {
                                    this.log.info("Inserting into table " + table.getName());
                                }
                                this.insertRandomRecord(tran, table);
                                break;
                            }
                            case 1: {
                                if (this.verbose) {
                                    this.log.info("Updating record in table " + table.getName());
                                }
                                this.updateRandomRecord(tran, table);
                                break;
                            }
                            case 2: {
                                if (this.verbose) {
                                    this.log.info("Deleting record in table " + table.getName());
                                }
                                this.deleteRandomRecord(tran, table);
                                this.selectRandomRecord(tran, table);
                            }
                        }
                        if (++rowsInTransaction >= numRowsToCommit) {
                            if (this.commitDelay > 0) {
                                AppUtils.sleep((long)this.commitDelay);
                            }
                            if (this.percentRollback > 0 && this.getRand().nextInt(100) <= this.percentRollback) {
                                this.log.info("Rollback " + rowsInTransaction + " rows");
                                tran.rollback();
                            } else {
                                this.log.info("Commit " + rowsInTransaction + " rows, total " + (rowsTotal += rowsInTransaction) + " rows");
                                tran.commit();
                            }
                            rowsInTransaction = 0;
                            AppUtils.sleep((long)this.interval);
                        }
                        if (!table.hasAutoIncrementColumn()) continue;
                        this.log.info("Turning off identity insert for table " + table.getName());
                        tran.allowInsertIntoAutoIncrementColumns(false, table, quote, catalogSeparator, schemaSeparator);
                    }
                }
                this.clearDependentColumnValues();
                this.currentRowValues.clear();
            }
            if (rowsInTransaction > 0) {
                if (this.commitDelay > 0) {
                    AppUtils.sleep((long)this.commitDelay);
                }
                this.log.info("Commit " + rowsInTransaction + " rows, total " + rowsTotal + " rows");
                tran.commit();
            }
        }
    }

    private void truncateTable(Table table) {
        if (this.verbose) {
            this.log.info("Truncating table " + table.getFullyQualifiedTableName());
        }
        String options = "";
        if (this.platform.getName().startsWith("postgres")) {
            options = " cascade";
        }
        this.platform.getSqlTemplate().update("truncate table " + table.getFullyQualifiedTableName() + options, new Object[0]);
    }

    private int randomIUD(DmlWeight iudWeight) {
        int total = iudWeight.getInsertWeight() + iudWeight.getUpdateWeight() + iudWeight.getDeleteWeight();
        if (total == 0) {
            return 0;
        }
        int rVal = this.getRand().nextInt(total);
        if (rVal < iudWeight.getInsertWeight()) {
            return 0;
        }
        if (rVal < iudWeight.getInsertWeight() + iudWeight.getUpdateWeight()) {
            return 1;
        }
        return 2;
    }

    private Row selectRandomRow(ISqlTransaction tran, Table table) {
        List<Row> rows;
        Row row = null;
        String sql = this.platform.createDmlStatement(DmlStatement.DmlType.SELECT_ALL, table.getCatalog(), table.getSchema(), table.getName(), table.getPrimaryKeyColumns(), table.getColumns(), null, this.textColumnExpression).getSql();
        if (this.verbose) {
            this.log.info("Selecting from " + table.getName());
        }
        if ((rows = this.queryForRows(tran, sql, null, null)).size() != 0) {
            int rowNum = this.getRand().nextInt(rows.size());
            row = rows.get(rowNum);
            if (this.verbose) {
                this.log.info("Row from " + table.getName() + ": " + row);
            }
        } else {
            if (this.cascading) {
                this.insertRandomRecord(tran, table);
                return this.selectRandomRow(tran, table);
            }
            this.log.warn("Unable to find a row in table " + table.getName());
        }
        return row;
    }

    private Row selectSpecificRow(ISqlTransaction tran, Table table, Column[] keyColumns, Object[] values) {
        List<Row> rows;
        Row row = null;
        DmlStatement stmt = this.platform.createDmlStatement(DmlStatement.DmlType.SELECT, table.getCatalog(), table.getSchema(), table.getName(), keyColumns, table.getColumns(), null, this.textColumnExpression);
        if (this.verbose) {
            StringBuilder sb = null;
            for (int i = 0; i < keyColumns.length; ++i) {
                sb = sb == null ? new StringBuilder() : sb.append(", ");
                sb.append(keyColumns[i].getName()).append("=").append(values[i]);
            }
            this.log.info("Selecting from {} where {}", (Object)table.getName(), (Object)sb);
        }
        if ((rows = this.queryForRows(tran, stmt.getSql(), values, stmt.getTypes())).size() != 0) {
            int rowNum = this.getRand().nextInt(rows.size());
            row = rows.get(rowNum);
        } else {
            StringBuilder sb = null;
            for (int i = 0; i < keyColumns.length; ++i) {
                sb = sb == null ? new StringBuilder() : sb.append(", ");
                sb.append(keyColumns[i].getName()).append("=").append(values[i]);
            }
            this.log.warn("Unable to find row from {} where {}", (Object)table.getName(), (Object)sb);
        }
        return row;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Row> queryForRows(ISqlTransaction tran, String sql, Object[] values, int[] types) {
        final ArrayList<Row> rows = new ArrayList<Row>();
        if (tran != null) {
            try {
                tran.query(sql, (ISqlRowMapper)new ISqlRowMapper<Object>(){
                    int count = 1;

                    public Object mapRow(Row row) {
                        rows.add(row);
                        if (this.count++ >= 100) {
                            throw new RuntimeException("MAX");
                        }
                        return Boolean.TRUE;
                    }
                }, values, types);
                return rows;
            }
            catch (RuntimeException e) {
                if (e.getMessage().equals("MAX")) return rows;
                throw e;
            }
        } else {
            this.platform.getSqlTemplate().query(sql, 100, (ISqlRowMapper)new ISqlRowMapper<Object>(){

                public Object mapRow(Row row) {
                    rows.add(row);
                    return Boolean.TRUE;
                }
            }, values, types);
        }
        return rows;
    }

    private void updateRandomRecord(ISqlTransaction tran, Table table) {
        block6: {
            DmlStatement updStatement = this.createUpdateDmlStatement(table);
            Row row = this.createRandomUpdateValues(tran, updStatement, table);
            Object[] values = new Object[table.getColumnCount()];
            int i = 0;
            for (Column column : table.getColumns()) {
                if (column.isPrimaryKey()) continue;
                values[i++] = row.get((Object)column.getName());
            }
            if (i > 0) {
                for (Column column : table.getPrimaryKeyColumns()) {
                    values[i++] = row.get((Object)column.getName());
                }
                try {
                    tran.prepareAndExecute(updStatement.getSql(), values);
                }
                catch (SqlException ex) {
                    this.log.info("Failed to update {}: {}", (Object)table.getName(), (Object)ex.getMessage());
                    if (this.debug) {
                        this.logRow(row);
                        this.log.info("Failed SQL: " + updStatement.getSql(), (Throwable)ex);
                    }
                    if (this.continueOnError) break block6;
                    throw ex;
                }
            }
        }
    }

    private void insertRandomRecord(ISqlTransaction tran, Table table) {
        DmlStatement insertStatement = this.createInsertDmlStatement(table);
        Row row = null;
        try {
            int count = 0;
            for (int i = 0; i < 100 && count == 0; ++i) {
                row = this.createRandomInsertValues(insertStatement, table);
                try {
                    count = tran.prepareAndExecute(insertStatement.getSql(), insertStatement.getValueArray(row.toArray(table.getColumnNames()), row.toArray(table.getPrimaryKeyColumnNames())));
                    continue;
                }
                catch (SqlException e) {
                    this.log.warn(e.getMessage());
                    if (this.platform.getDatabaseInfo().isRequiresSavePointsInTransaction()) {
                        tran.rollback();
                    }
                    count = 0;
                }
            }
            if (count == 0 && this.cascading) {
                this.log.info("Failed to insert non-conflicting row into {}", (Object)table.getName());
                if (this.debug) {
                    this.logRow(row);
                    this.log.info("Failed SQL: " + insertStatement.getSql());
                }
                if (this.continueOnError) {
                    this.selectRandomRecord(tran, table);
                }
            }
        }
        catch (SqlException ex) {
            this.log.info("Failed to insert into {}: {}", (Object)table.getName(), (Object)ex.getMessage());
            if (this.debug) {
                this.logRow(row);
                this.log.info("Failed SQL: " + insertStatement.getSql(), (Throwable)ex);
            }
            if (this.continueOnError) {
                this.selectRandomRecord(tran, table);
            }
            throw ex;
        }
    }

    public String createDynamicRandomInsertSql(Table table) {
        DmlStatement insertStatement = this.createInsertDmlStatement(table);
        Row row = this.createRandomInsertValues(insertStatement, table);
        return insertStatement.buildDynamicSql(BinaryEncoding.HEX, row, false, true);
    }

    public String createDynamicRandomUpdateSql(Table table) {
        DmlStatement updStatement = this.createUpdateDmlStatement(table);
        Row row = this.createRandomUpdateValues(null, updStatement, table);
        return updStatement.buildDynamicSql(BinaryEncoding.HEX, row, false, true);
    }

    public String createDynamicRandomDeleteSql(Table table) {
        DmlStatement deleteStatement = this.createDeleteDmlStatement(table);
        Row row = this.selectRandomRow(null, table);
        return deleteStatement.buildDynamicDeleteSql(BinaryEncoding.HEX, row, false, true);
    }

    private void deleteRandomRecord(ISqlTransaction tran, Table table) {
        block7: {
            DmlStatement deleteStatement = this.createDeleteDmlStatement(table);
            Row row = this.selectRandomRow(tran, table);
            try {
                tran.prepareAndExecute(deleteStatement.getSql(), row.toArray(table.getPrimaryKeyColumnNames()));
            }
            catch (SqlException ex) {
                this.log.info("Failed to delete from {}: {}", (Object)table.getName(), (Object)ex.getMessage());
                if (this.debug) {
                    this.logRow(row);
                    this.log.info("Failed SQL: " + deleteStatement.getSql(), (Throwable)ex);
                }
                if (this.platform.getSqlTemplate().isForeignKeyChildExistsViolation((Throwable)ex)) {
                    try {
                        this.deleteForeignKeyChildren(tran, table, row);
                    }
                    catch (SqlException e) {
                        if (!this.continueOnError) {
                            throw e;
                        }
                        break block7;
                    }
                }
                if (this.continueOnError) break block7;
                throw ex;
            }
        }
    }

    private void deleteForeignKeyChildren(ISqlTransaction tran, Table table, Row row) {
        List tableRows = new ArrayList<TableRow>();
        tableRows.add(new TableRow(table, row, null, null, null));
        tableRows = this.platform.getDdlReader().getExportedForeignTableRows(tran, tableRows, new HashSet(), BinaryEncoding.HEX);
        if (!tableRows.isEmpty()) {
            Collections.reverse(tableRows);
            HashSet<TableRow> visited = new HashSet<TableRow>();
            for (TableRow foreignTableRow : tableRows) {
                if (!visited.add(foreignTableRow)) continue;
                Table foreignTable = foreignTableRow.getTable();
                this.log.info("Remove foreign row catalog '{}' schema '{}' foreign table name '{}' fk name '{}' where sql '{}' to correct table '{}' for column '{}'", new Object[]{foreignTable.getCatalog(), foreignTable.getSchema(), foreignTable.getName(), foreignTableRow.getFkName(), foreignTableRow.getWhereSql(), table.getName(), foreignTableRow.getReferenceColumnName()});
                DatabaseInfo info = this.platform.getDatabaseInfo();
                String tableName = Table.getFullyQualifiedTableName((String)foreignTable.getCatalog(), (String)foreignTable.getSchema(), (String)foreignTable.getName(), (String)info.getDelimiterToken(), (String)info.getCatalogSeparator(), (String)info.getSchemaSeparator());
                String sql = "DELETE FROM " + tableName + " WHERE " + foreignTableRow.getWhereSql();
                tran.prepareAndExecute(sql, new Object[0]);
            }
        }
    }

    private void selectRandomRecord(ISqlTransaction tran, Table table) {
        Row row = null;
        if (this.hasDependentColumns(table)) {
            Map<Column, Object> dependent = this.getDependentColumnValues(table);
            if (dependent.size() > 0) {
                row = this.selectSpecificRow(tran, table, dependent.keySet().toArray(new Column[dependent.size()]), dependent.values().toArray(new Object[dependent.size()]));
                this.saveDependentColumnValues(table, row);
            } else {
                row = this.selectRandomRow(tran, table);
                this.saveDependentColumnValues(table, row);
            }
        } else {
            row = this.selectRandomRow(tran, table);
        }
        this.currentRowValues.put(table.getName(), (Map<String, Object>)row);
    }

    private boolean hasDependentColumns(Table table) {
        return this.commonDependencyTables.contains(table);
    }

    private Map<Column, Object> getDependentColumnValues(Table table) {
        HashMap<Column, Object> columnValues = new HashMap<Column, Object>();
        for (Column column : table.getColumns()) {
            String key = table.getQualifiedColumnName(column);
            List<Object> commonValue = this.commonDependencyValues.get(key);
            if (commonValue == null || commonValue.size() == 0) continue;
            columnValues.put(column, commonValue.get(0));
        }
        return columnValues;
    }

    private void saveDependentColumnValues(Table table, Row row) {
        for (String columnName : row.keySet()) {
            String key = table.getFullyQualifiedTableName() + "." + columnName;
            List<Object> commonValue = this.commonDependencyValues.get(key);
            if (commonValue == null) continue;
            commonValue.clear();
            Object value = row.get((Object)columnName);
            commonValue.add(value);
            if (!this.verbose) continue;
            this.log.info("Setting common value for {}={}", (Object)key, value);
        }
    }

    private void clearDependentColumnValues() {
        for (List<Object> commonValue : this.commonDependencyValues.values()) {
            commonValue.clear();
        }
    }

    private Object generateRandomValueForColumn(Table table, Column column) {
        Object objectValue = null;
        int type = column.getMappedTypeCode();
        if (column.getPlatformColumns() != null && column.getPlatformColumns().get(this.platform.getName()) != null && ((PlatformColumn)column.getPlatformColumns().get(this.platform.getName())).isEnum()) {
            objectValue = ((PlatformColumn)column.getPlatformColumns().get(this.platform.getName())).getEnumValues()[this.getRand().nextInt(((PlatformColumn)column.getPlatformColumns().get(this.platform.getName())).getEnumValues().length)];
        } else if (column.getJdbcTypeName() != null && column.getJdbcTypeName().equals("uniqueidentifier")) {
            objectValue = this.randomUUID();
        } else if (column.isTimestampWithTimezone()) {
            objectValue = String.format("%s %s", FormatUtils.TIMESTAMP_FORMATTER.format(this.randomDate()), AppUtils.getTimezoneOffset());
        } else if (type == 91) {
            objectValue = DateUtils.truncate((Date)this.randomDate(), (int)5);
        } else if (type == 93 || type == 92) {
            objectValue = this.randomTimestamp();
        } else if (type == 4 || type == -5) {
            objectValue = this.randomInt();
        } else if (type == 5) {
            objectValue = this.randomSmallInt(column.getJdbcTypeName().toLowerCase().contains("unsigned"));
        } else if (type == 6) {
            objectValue = this.randomFloat();
        } else if (type == 8) {
            objectValue = this.randomDouble();
            if (StringUtils.containsIgnoreCase((CharSequence)column.getJdbcTypeName(), (CharSequence)"money")) {
                BigDecimal bd = BigDecimal.valueOf((Double)objectValue);
                bd = bd.setScale(2, RoundingMode.HALF_UP);
                objectValue = bd.toString();
            }
        } else if (type == -6) {
            objectValue = this.randomTinyInt();
        } else if (type == 2 || type == 3 || type == 7) {
            int size = column.getSizeAsInt() > 32 ? 32 : column.getSizeAsInt();
            objectValue = this.randomBigDecimal(size, column.getScale());
        } else if (type == 16 || type == -7) {
            objectValue = this.randomBoolean();
        } else if (type == 2004 || type == -4 || type == -2 || type == -3 || type == -10) {
            int size = this.maxByteSize;
            if ((type == -2 || type == -3) && size > column.getSizeAsInt()) {
                size = column.getSizeAsInt();
            }
            objectValue = this.randomBytes(this.randomSize(column, size));
        } else if (type == 2003) {
            objectValue = null;
        } else if (type == 12 || type == -9 || type == -15 || type == -1 || type == 1 || type == 2005) {
            if (column.getJdbcTypeName() != null && (column.getJdbcTypeName().equals("JSON") || column.getJdbcTypeName().equals("jsonb"))) {
                objectValue = "{\"jumpmind\":\"symmetricds\"}";
            } else if ("UUID".equalsIgnoreCase(column.getJdbcTypeName())) {
                objectValue = this.randomUUID();
            } else if ("TIME".equalsIgnoreCase(column.getJdbcTypeName())) {
                objectValue = this.randomTimestamp();
            } else if ("BIT".equalsIgnoreCase(column.getJdbcTypeName())) {
                objectValue = this.randomBoolean() ? "1" : "0";
            } else {
                int size = this.maxTextSize;
                if (column.getSizeAsInt() != 0) {
                    Integer minSize = this.minColumnSizes.get(table.getQualifiedColumnName(column));
                    if (minSize != null) {
                        size = minSize;
                    } else if (size > column.getSizeAsInt()) {
                        size = column.getSizeAsInt();
                    }
                }
                objectValue = this.randomString(this.randomSize(column, size));
            }
        } else if (type == 1111 && "UUID".equalsIgnoreCase(column.getJdbcTypeName())) {
            objectValue = this.randomUUID();
        }
        return objectValue;
    }

    private int randomSize(Column column, int size) {
        if (!column.isPrimaryKey() && (size = this.getRand().nextInt(size)) == 0) {
            size = 1;
        }
        return size;
    }

    private Object randomSmallInt(boolean unsigned) {
        if (unsigned) {
            return this.getRand().nextInt(32768);
        }
        return this.getRand().nextInt(65535) - 32768;
    }

    private Object randomFloat() {
        return Float.valueOf(this.getRand().nextFloat());
    }

    private Object randomDouble() {
        long places = 1000000000L;
        double d = this.getRand().nextDouble() * 1.0E9;
        long l = Math.round(d);
        return (double)l / 1.0E9 + 2.0 + (double)this.randomInt().intValue();
    }

    private Object randomTinyInt() {
        return this.getRand().nextInt(127);
    }

    private String randomString(int maxLength) {
        StringBuilder str = new StringBuilder(maxLength);
        for (int i = 0; i < maxLength; ++i) {
            str.append(this.randomChar());
        }
        return str.toString();
    }

    private byte[] randomBytes(int length) {
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = (byte)this.getRand().nextInt(256);
        }
        return array;
    }

    private boolean randomBoolean() {
        return this.getRand().nextBoolean();
    }

    private BigDecimal randomBigDecimal(int size, int digits) {
        if (size <= 0 && digits <= 0) {
            size = 10;
            digits = 0;
        }
        SecureRandom rnd = this.getRand();
        StringBuilder str = new StringBuilder();
        if (size > 0 && rnd.nextBoolean()) {
            str.append("-");
        }
        for (int i = 0; i < size; ++i) {
            if (i == size - digits) {
                str.append(".");
            }
            str.append(rnd.nextInt(10));
        }
        return new BigDecimal(str.toString());
    }

    private Character randomChar() {
        int rnd = this.getRand().nextInt(52);
        int base = rnd < 26 ? 65 : 97;
        return Character.valueOf((char)(base + rnd % 26));
    }

    private Date randomDate() {
        long l = this.getRand().nextLong();
        if (l < 0L) {
            l *= -1L;
        }
        long ms = 1576800000000L;
        return new Date(l % ms);
    }

    private Timestamp randomTimestamp() {
        return Timestamp.valueOf(FormatUtils.TIMESTAMP_FORMATTER.format(this.randomDate()));
    }

    private Integer randomInt() {
        return this.getRand().nextInt(1000000);
    }

    private String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public String getSchemaToUse() {
        if (StringUtils.isBlank((CharSequence)this.schema)) {
            return this.platform.getDefaultSchema();
        }
        return this.schema;
    }

    public String getCatalogToUse() {
        if (StringUtils.isBlank((CharSequence)this.catalog)) {
            return this.platform.getDefaultCatalog();
        }
        return this.catalog;
    }

    protected List<String> getLocalFkRefColumns(Table table) {
        ArrayList<String> columns = new ArrayList<String>();
        for (ForeignKey fk : table.getForeignKeys()) {
            for (Reference ref : fk.getReferences()) {
                columns.add(ref.getLocalColumnName());
            }
        }
        return columns;
    }

    protected Map<String, Table> getAllDbTables() {
        if (this.allDbTablesCache == null) {
            Table[] allTables;
            this.allDbTablesCache = new TreeMap<String, Table>(String.CASE_INSENSITIVE_ORDER);
            for (Table table : allTables = this.platform.readDatabase(this.getCatalogToUse(), this.getSchemaToUse(), null).getTables()) {
                table = this.filterColumns(table);
                this.allDbTablesCache.put(table.getName(), table);
            }
        }
        return this.allDbTablesCache;
    }

    protected Table getDbTable(String catalogName, String schemaName, String tableName) {
        Table table = this.getAllDbTables().get(tableName);
        if (table == null) {
            table = this.platform.readTableFromDatabase(catalogName, schemaName, tableName);
            table = this.filterColumns(table);
        }
        return table;
    }

    protected Table filterColumns(Table table) {
        if (this.platform.getName().startsWith("mssql")) {
            ArrayList<Column> columnsToRemove = new ArrayList<Column>();
            for (Column column : table.getColumns()) {
                if (!column.getJdbcTypeName().equalsIgnoreCase("timestamp") && !column.getJdbcTypeName().equalsIgnoreCase("rowversion")) continue;
                columnsToRemove.add(column);
            }
            if (columnsToRemove.size() > 0) {
                table = table.copy();
                for (Column column : columnsToRemove) {
                    table.removeColumn(column);
                }
            }
        }
        return table;
    }

    public DmlStatement createInsertDmlStatement(Table table) {
        return this.platform.createDmlStatement(DmlStatement.DmlType.INSERT, table.getCatalog(), table.getSchema(), table.getName(), table.getPrimaryKeyColumns(), table.getColumns(), null, this.textColumnExpression);
    }

    public DmlStatement createUpdateDmlStatement(Table table) {
        return this.platform.createDmlStatement(DmlStatement.DmlType.UPDATE, table.getCatalog(), table.getSchema(), table.getName(), table.getPrimaryKeyColumns(), table.getNonPrimaryKeyColumns(), null, this.textColumnExpression);
    }

    public DmlStatement createDeleteDmlStatement(Table table) {
        return this.platform.createDmlStatement(DmlStatement.DmlType.DELETE, table.getCatalog(), table.getSchema(), table.getName(), table.getPrimaryKeyColumns(), table.getNonPrimaryKeyColumns(), null, this.textColumnExpression);
    }

    private Row createRandomInsertValues(DmlStatement insertStatement, Table table) {
        Set listCompositeForeignKeys;
        Column[] columns = insertStatement.getMetaData();
        Row row = new Row(columns.length);
        for (Column column : columns) {
            Object value = null;
            Reference[] fkrs = this.foreignKeyReferences.get(table.getQualifiedColumnName(column));
            if (fkrs != null) {
                for (ForeignKeyReference foreignKeyReference : fkrs) {
                    Map<String, Object> foreignRowValues;
                    if (foreignKeyReference == null || table.getName().equals(foreignKeyReference.getForeignKey().getForeignTableName()) || (foreignRowValues = this.currentRowValues.get(foreignKeyReference.getForeignKey().getForeignTableName())) == null) continue;
                    value = foreignRowValues.get(foreignKeyReference.getReference().getForeignColumnName());
                    break;
                }
            }
            if (value == null) {
                value = this.generateRandomValueForColumn(table, column);
            }
            row.put(column.getName(), value);
        }
        Map<Column, Object> dependentValues = this.getDependentColumnValues(table);
        if (dependentValues != null) {
            for (Map.Entry<Column, Object> entry : dependentValues.entrySet()) {
                row.put(entry.getKey().getName(), entry.getValue());
            }
        }
        if ((listCompositeForeignKeys = (Set)this.compositeForeignKeys.get(table)) != null) {
            for (ForeignKey fk : listCompositeForeignKeys) {
                Map<String, Object> foreignRowValues;
                if (table.getName().equals(fk.getForeignTableName()) || (foreignRowValues = this.currentRowValues.get(fk.getForeignTableName())) == null) continue;
                for (Reference ref : fk.getReferences()) {
                    row.put(ref.getLocalColumnName(), foreignRowValues.get(ref.getForeignColumnName()));
                }
            }
        }
        for (ForeignKey fk : table.getForeignKeys()) {
            if (!table.getName().equals(fk.getForeignTableName())) continue;
            for (Reference ref : fk.getReferences()) {
                row.put(ref.getLocalColumnName(), row.get((Object)ref.getForeignColumnName()));
            }
        }
        if (this.verbose) {
            this.log.info("Generated row for " + table.getName() + " " + row);
        }
        this.currentRowValues.put(table.getName(), (Map<String, Object>)row);
        return row;
    }

    private Row createRandomUpdateValues(ISqlTransaction tran, DmlStatement updStatement, Table table) {
        Row row = this.selectRandomRow(tran, table);
        if (row == null) {
            this.log.warn("Unable to update a random record in empty table '" + table.getName() + "'.");
            return null;
        }
        Column[] columns = updStatement.getMetaData();
        List<String> localFkRefColumns = this.getLocalFkRefColumns(table);
        int numToUpdate = this.getRand().nextInt(columns.length);
        if (numToUpdate == 0) {
            numToUpdate = 1;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].isPrimaryKey() || localFkRefColumns.contains(columns[i].getName()) || numToUpdate-- <= 0) continue;
            row.put(columns[i].getName(), this.generateRandomValueForColumn(table, columns[i]));
        }
        this.currentRowValues.put(table.getName(), (Map<String, Object>)row);
        return row;
    }

    private void logRow(Row row) {
        StringBuilder sb = null;
        for (String name : row.keySet()) {
            sb = sb == null ? new StringBuilder() : sb.append(",");
            sb.append(name).append("=").append(row.get((Object)name));
        }
        this.log.info("The row data was: {} ", sb);
    }

    public void setPlatform(IDatabasePlatform platform) {
        this.platform = platform;
    }

    public int getRecordCount() {
        return this.inputLength;
    }

    public void setRecordCount(int recordCount) {
        this.inputLength = recordCount;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean isCascading() {
        return this.cascading;
    }

    public void setCascading(boolean cascading) {
        this.cascading = cascading;
    }

    public boolean isCascadingSelect() {
        return this.cascadingSelect;
    }

    public void setCascadingSelect(boolean cascadingSelect) {
        this.cascadingSelect = cascadingSelect;
    }

    public boolean isTruncate() {
        return this.truncate;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public String[] getIgnore() {
        return this.ignore;
    }

    public void setIgnore(String[] ignore) {
        this.ignore = ignore;
    }

    public String[] getPrefixed() {
        return this.prefixed;
    }

    public void setPrefixed(String[] prefixed) {
        this.prefixed = prefixed;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public SecureRandom getRand() {
        if (this.rand == null) {
            this.rand = new SecureRandom();
        }
        return this.rand;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDmlWeight(DmlWeight dmlWeight) {
        this.dmlWeight = dmlWeight;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public boolean getPrint() {
        return this.print;
    }

    public void setUseRandomCount(boolean useRandomCount) {
        this.useRandomCount = useRandomCount;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    public void setMaxRowsCommit(int maxRowsCommit) {
        this.maxRowsCommit = maxRowsCommit;
    }

    public void setCommitDelay(int commitDelay) {
        this.commitDelay = commitDelay;
    }

    public void setPercentRollback(int percentRollback) {
        this.percentRollback = percentRollback;
    }

    public int getInsertWeight() {
        return this.dmlWeight.getInsertWeight();
    }

    public int getUpdateWeight() {
        return this.dmlWeight.getUpdateWeight();
    }

    public int getDeleteWeight() {
        return this.dmlWeight.getDeleteWeight();
    }

    public void setTextColumnExpression(String textColumnExpression) {
        this.textColumnExpression = textColumnExpression;
    }

    public String getTextColumnExpression() {
        return this.textColumnExpression;
    }

    public long getMaxByteSize() {
        return this.maxByteSize;
    }

    public void setMaxByteSize(int maxByteSize) {
        this.maxByteSize = maxByteSize;
    }

    public int getMaxTextSize() {
        return this.maxTextSize;
    }

    public void setMaxTextSize(int maxTextSize) {
        this.maxTextSize = maxTextSize;
    }

    static class ForeignKeyReference {
        ForeignKey fk;
        Reference ref;

        public ForeignKeyReference(ForeignKey fk, Reference ref) {
            this.fk = fk;
            this.ref = ref;
        }

        public ForeignKey getForeignKey() {
            return this.fk;
        }

        public Reference getReference() {
            return this.ref;
        }

        public String toString() {
            return this.fk.getForeignTableName() + "." + this.ref.getForeignColumnName() + "->" + this.ref.getLocalColumnName();
        }

        public int hashCode() {
            return this.fk.hashCode() + this.ref.hashCode();
        }

        public boolean equals(Object o) {
            return o != null && o.hashCode() == this.hashCode();
        }
    }
}

