/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.reader.AbstractTableDataReader;

public class CsvTableDataReader
extends AbstractTableDataReader {
    protected CsvReader csvReader;

    public CsvTableDataReader(BinaryEncoding binaryEncoding, String catalogName, String schemaName, String tableName, InputStream is) {
        super(binaryEncoding, catalogName, schemaName, tableName, is);
    }

    public CsvTableDataReader(BinaryEncoding binaryEncoding, String catalogName, String schemaName, String tableName, Reader reader) {
        super(binaryEncoding, catalogName, schemaName, tableName, reader);
    }

    @Override
    protected void init() {
        try {
            String[] columnNames;
            this.csvReader = CsvUtils.getCsvReader(this.reader);
            this.csvReader.setUseComments(true);
            this.csvReader.readHeaders();
            for (String columnName : columnNames = this.csvReader.getHeaders()) {
                this.table.addColumn(new Column(columnName));
            }
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
    }

    @Override
    protected CsvData readNext() {
        try {
            if (this.csvReader.readRecord()) {
                String[] tokens = this.csvReader.getValues();
                return this.buildCsvData(tokens, DataEventType.INSERT);
            }
            return null;
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
    }

    @Override
    protected void finish() {
        if (this.csvReader != null) {
            this.csvReader.close();
        }
    }
}

