/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.reader;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.IDataReader;
import org.jumpmind.symmetric.io.data.reader.IExtractDataReaderSource;
import org.jumpmind.util.CollectionUtils;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.Statistics;

public class ExtractDataReader
implements IDataReader {
    public static final String DATA_CONTEXT_CURRENT_CSV_DATA = "csvData";
    protected Map<Batch, Statistics> statistics = new HashMap<Batch, Statistics>();
    protected IDatabasePlatform platform;
    protected List<IExtractDataReaderSource> sourcesToUse;
    protected IExtractDataReaderSource currentSource;
    protected Batch batch;
    protected Table table;
    protected CsvData data;
    protected DataContext dataContext;
    protected boolean isSybaseASE;
    protected boolean isUsingUnitypes;

    public ExtractDataReader(IDatabasePlatform platform, IExtractDataReaderSource source) {
        this.sourcesToUse = new ArrayList<IExtractDataReaderSource>();
        this.sourcesToUse.add(source);
        this.platform = platform;
        this.isSybaseASE = platform.getName().equals("ase");
    }

    public ExtractDataReader(IDatabasePlatform platform, IExtractDataReaderSource source, Boolean isUsingUnitypes) {
        this.sourcesToUse = new ArrayList<IExtractDataReaderSource>();
        this.sourcesToUse.add(source);
        this.platform = platform;
        this.isUsingUnitypes = isUsingUnitypes;
        this.isSybaseASE = platform.getName().equals("ase");
    }

    public ExtractDataReader(IDatabasePlatform platform, List<IExtractDataReaderSource> sources) {
        this.sourcesToUse = new ArrayList<IExtractDataReaderSource>(sources);
        this.platform = platform;
        this.isSybaseASE = platform.getName().equals("ase");
    }

    @Override
    public void open(DataContext context) {
        this.dataContext = context;
    }

    @Override
    public Batch nextBatch() {
        this.closeCurrentSource();
        if (this.sourcesToUse.size() > 0) {
            this.currentSource = this.sourcesToUse.remove(0);
            this.batch = this.currentSource.getBatch();
        } else {
            this.batch = null;
        }
        return this.batch;
    }

    @Override
    public Table nextTable() {
        this.table = null;
        if (this.currentSource != null) {
            if (this.data == null) {
                this.data = this.currentSource.next();
            }
            if (this.data != null) {
                this.table = this.currentSource.getTargetTable();
                if (this.table != null) {
                    this.table.setCatalog(this.substituteVariables(this.table.getCatalog()));
                    this.table.setSchema(this.substituteVariables(this.table.getSchema()));
                }
            }
        }
        if (this.table == null && this.batch != null) {
            this.batch.setComplete(true);
        }
        return this.table;
    }

    protected String substituteVariables(String sourceString) {
        if (sourceString != null && sourceString.indexOf("$(") != -1) {
            sourceString = FormatUtils.replace((String)"sourceNodeId", (String)((String)this.dataContext.get("sourceNodeId")), (String)sourceString);
            sourceString = FormatUtils.replace((String)"sourceNodeExternalId", (String)((String)this.dataContext.get("sourceNodeExternalId")), (String)sourceString);
            sourceString = FormatUtils.replace((String)"sourceNodeGroupId", (String)((String)this.dataContext.get("sourceNodeGroupId")), (String)sourceString);
            sourceString = FormatUtils.replace((String)"targetNodeId", (String)((String)this.dataContext.get("targetNodeId")), (String)sourceString);
            sourceString = FormatUtils.replace((String)"targetNodeExternalId", (String)((String)this.dataContext.get("targetNodeExternalId")), (String)sourceString);
            sourceString = FormatUtils.replace((String)"targetNodeGroupId", (String)((String)this.dataContext.get("targetNodeGroupId")), (String)sourceString);
        }
        return sourceString;
    }

    @Override
    public CsvData nextData() {
        if (this.table != null) {
            if (this.data == null) {
                this.data = this.currentSource.next();
            }
            if (this.data == null) {
                this.closeCurrentSource();
            } else {
                Table targetTable = this.currentSource.getTargetTable();
                if (targetTable != null && targetTable.equals((Object)this.table)) {
                    this.data = this.enhanceWithLobsFromSourceIfNeeded(this.currentSource.getSourceTable(), this.data);
                    if (this.isSybaseASE && this.isUsingUnitypes) {
                        this.data = this.convertUtf16toUTF8(this.currentSource.getSourceTable(), this.data);
                    }
                } else {
                    return null;
                }
            }
        }
        CsvData dataToReturn = this.data;
        this.data = null;
        this.dataContext.put(DATA_CONTEXT_CURRENT_CSV_DATA, dataToReturn);
        return dataToReturn;
    }

    @Override
    public void close() {
        this.closeCurrentSource();
        this.batch = null;
    }

    protected void closeCurrentSource() {
        if (this.currentSource != null) {
            this.currentSource.close();
            this.currentSource = null;
        }
        this.table = null;
        this.data = null;
    }

    @Override
    public Map<Batch, Statistics> getStatistics() {
        return this.statistics;
    }

    protected CsvData enhanceWithLobsFromSourceIfNeeded(Table table, CsvData data) {
        List lobColumns;
        if (this.currentSource.requiresLobsSelectedFromSource(data) && (data.getDataEventType() == DataEventType.UPDATE || data.getDataEventType() == DataEventType.INSERT) && (lobColumns = this.platform.getLobColumns(table)).size() > 0) {
            Object[] columnNames = table.getColumnNames();
            String[] rowData = data.getParsedData("rowData");
            Column[] orderedColumns = table.getColumns();
            Object[] objectValues = this.platform.getObjectValues(this.batch.getBinaryEncoding(), rowData, orderedColumns);
            Map columnDataMap = CollectionUtils.toMap((String[])columnNames, (Object[])objectValues);
            Column[] pkColumns = table.getPrimaryKeyColumns();
            ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
            Object[] args = new Object[pkColumns.length];
            for (int i = 0; i < pkColumns.length; ++i) {
                args[i] = columnDataMap.get(pkColumns[i].getName());
            }
            String sql = this.buildSelect(table, lobColumns, pkColumns);
            Row row = sqlTemplate.queryForRow(sql, args);
            if (row == null) {
                row = this.createRowForRequiredLobs(lobColumns);
            }
            if (row != null) {
                for (Column lobColumn : lobColumns) {
                    String valueForCsv = null;
                    if (this.platform.isBlob(lobColumn.getMappedTypeCode())) {
                        byte[] binaryData = row.getBytes(lobColumn.getName());
                        if (binaryData != null) {
                            valueForCsv = this.batch.getBinaryEncoding() == BinaryEncoding.BASE64 ? new String(Base64.encodeBase64((byte[])binaryData), Charset.defaultCharset()) : (this.batch.getBinaryEncoding() == BinaryEncoding.HEX ? new String(Hex.encodeHex((byte[])binaryData)) : new String(binaryData, Charset.defaultCharset()));
                            binaryData = null;
                        }
                    } else {
                        valueForCsv = row.getString(lobColumn.getName());
                    }
                    int index = ArrayUtils.indexOf((Object[])columnNames, (Object)lobColumn.getName());
                    rowData[index] = valueForCsv;
                }
                data.putParsedData("rowData", rowData);
            }
        }
        return data;
    }

    protected CsvData convertUtf16toUTF8(Table table, CsvData data) {
        List<Column> uniColumns;
        if (!(data.getDataEventType() != DataEventType.UPDATE && data.getDataEventType() != DataEventType.INSERT || (uniColumns = this.getUniColumns(table)).isEmpty())) {
            Object[] columnNames = table.getColumnNames();
            String[] rowData = data.getParsedData("rowData");
            Column[] orderedColumns = table.getColumns();
            Object[] objectValues = this.platform.getObjectValues(this.batch.getBinaryEncoding(), rowData, orderedColumns);
            Map columnDataMap = CollectionUtils.toMap((String[])columnNames, (Object[])objectValues);
            Column[] pkColumns = table.getPrimaryKeyColumns();
            ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
            Object[] args = new Object[pkColumns.length];
            for (int i = 0; i < pkColumns.length; ++i) {
                args[i] = columnDataMap.get(pkColumns[i].getName());
            }
            String sql = this.buildSelect(table, uniColumns, pkColumns);
            Row row = sqlTemplate.queryForRow(sql, args);
            if (row != null) {
                for (Column uniColumn : uniColumns) {
                    try {
                        String utf8String;
                        int index = ArrayUtils.indexOf((Object[])columnNames, (Object)uniColumn.getName());
                        if (rowData[index] == null) continue;
                        String utf16String = null;
                        if (this.batch.getChannelId().equalsIgnoreCase("reload")) {
                            utf16String = new String(Hex.decodeHex((String)rowData[index]), "UTF-16");
                        } else {
                            String baseString = rowData[index];
                            baseString = "fffe" + baseString;
                            utf16String = new String(Hex.decodeHex((String)baseString), "UTF-16");
                        }
                        rowData[index] = utf8String = new String(utf16String.getBytes(Charset.defaultCharset()), Charset.defaultCharset());
                    }
                    catch (UnsupportedEncodingException | DecoderException e) {
                        e.printStackTrace();
                    }
                }
                data.putParsedData("rowData", rowData);
            }
        }
        return data;
    }

    public List<Column> getUniColumns(Table table) {
        Column[] allColumns;
        ArrayList<Column> uniColumns = new ArrayList<Column>(1);
        for (Column column : allColumns = table.getColumns()) {
            if (!this.isUniType(column.getJdbcTypeName())) continue;
            uniColumns.add(column);
        }
        return uniColumns;
    }

    public boolean isUniType(String type) {
        return type.equalsIgnoreCase("UNITEXT") || type.equalsIgnoreCase("UNICHAR") || type.equalsIgnoreCase("UNIVARCHAR");
    }

    protected String buildSelect(Table table, List<Column> lobColumns, Column[] pkColumns) {
        StringBuilder sql = new StringBuilder("select ");
        DatabaseInfo dbInfo = this.platform.getDatabaseInfo();
        String quote = this.platform.getDdlBuilder().isDelimitedIdentifierModeOn() ? dbInfo.getDelimiterToken() : "";
        for (Column lobColumn : lobColumns) {
            if ("XMLTYPE".equalsIgnoreCase(lobColumn.getJdbcTypeName()) && 2009 == lobColumn.getJdbcTypeCode()) {
                sql.append("extract(").append(quote).append(lobColumn.getName()).append(quote);
                sql.append(", '/').getClobVal()");
            } else {
                sql.append(quote).append(lobColumn.getName()).append(quote);
            }
            sql.append(",");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(" from ");
        sql.append(table.getQualifiedTableName(quote, dbInfo.getCatalogSeparator(), dbInfo.getSchemaSeparator()));
        sql.append(" where ");
        for (Column col : pkColumns) {
            sql.append(quote).append(col.getName()).append(quote);
            sql.append("=? and ");
        }
        sql.delete(sql.length() - 5, sql.length());
        return sql.toString();
    }

    protected Row createRowForRequiredLobs(List<Column> lobColumns) {
        Row row = null;
        boolean isRequired = false;
        for (Column lobColumn : lobColumns) {
            if (!lobColumn.isRequired()) continue;
            isRequired = true;
            break;
        }
        if (isRequired) {
            row = new Row(lobColumns.size());
            for (Column lobColumn : lobColumns) {
                if (!lobColumn.isRequired()) continue;
                if (this.platform.isBlob(lobColumn.getMappedTypeCode())) {
                    row.put(lobColumn.getName(), (Object)new byte[0]);
                    continue;
                }
                row.put(lobColumn.getName(), (Object)"");
            }
        }
        return row;
    }
}

