/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.IDataReader;
import org.jumpmind.symmetric.io.data.ProtocolException;
import org.jumpmind.symmetric.io.data.reader.AbstractDataReader;
import org.jumpmind.symmetric.io.data.reader.DataReaderStatistics;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.util.CollectionUtils;
import org.jumpmind.util.Statistics;

public class ProtocolDataReader
extends AbstractDataReader
implements IDataReader {
    public static final String CTX_LINE_NUMBER = ProtocolDataReader.class.getSimpleName() + ".lineNumber";
    protected IStagedResource stagedResource;
    protected Reader reader;
    protected Map<Batch, Statistics> statistics = new HashMap<Batch, Statistics>();
    protected CsvReader csvReader;
    protected DataContext context;
    protected Object next;
    protected Batch batch;
    protected String channelId;
    protected String tableName;
    protected String sourceNodeId;
    protected String targetNodeId;
    protected BinaryEncoding binaryEncoding;
    protected boolean noBinaryOldData = false;
    protected Batch.BatchType batchType;
    protected int lineNumber = 0;
    protected String[] tokens;
    protected boolean streamToFile = true;
    protected long baseTime;
    protected Timestamp createTime;

    public ProtocolDataReader(Batch.BatchType batchType, String targetNodeId, StringBuilder input) {
        this(batchType, targetNodeId, new BufferedReader(new StringReader(input.toString())));
    }

    public ProtocolDataReader(Batch.BatchType batchType, String targetNodeId, InputStream is) {
        this(batchType, targetNodeId, ProtocolDataReader.toReader(is));
    }

    public ProtocolDataReader(Batch.BatchType batchType, String targetNodeId, IStagedResource stagedResource) {
        this.stagedResource = stagedResource;
        this.targetNodeId = targetNodeId;
        this.batchType = batchType;
    }

    public ProtocolDataReader(Batch.BatchType batchType, String targetNodeId, String input) {
        this(batchType, targetNodeId, new BufferedReader(new StringReader(input)));
    }

    public ProtocolDataReader(Batch.BatchType batchType, String targetNodeId, Reader reader) {
        this.reader = reader;
        this.targetNodeId = targetNodeId;
        this.batchType = batchType;
    }

    public ProtocolDataReader(Batch.BatchType batchType, String targetNodeId, Reader reader, boolean streamToFile) {
        this.reader = reader;
        this.targetNodeId = targetNodeId;
        this.batchType = batchType;
        this.streamToFile = streamToFile;
    }

    public ProtocolDataReader(Batch.BatchType batchType, String targetNodeId, File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader in = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8.name());
            this.targetNodeId = targetNodeId;
            this.batchType = batchType;
            this.reader = new BufferedReader(in);
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
    }

    public IStagedResource getStagedResource() {
        return this.stagedResource;
    }

    @Override
    public void open(DataContext context) {
        if (this.stagedResource != null && this.reader == null) {
            this.reader = this.stagedResource.getReader();
        }
        this.lineNumber = 0;
        this.context = context;
        this.csvReader = CsvUtils.getCsvReader(this.reader);
        this.next = this.readNext();
    }

    public Object readNext() {
        try {
            HashSet<String> keys = null;
            String schemaName = null;
            String catalogName = null;
            String[] parsedOldData = null;
            long bytesRead = 0L;
            String[] statsColumns = null;
            String[] statsValues = null;
            Table table = null;
            while (this.tokens != null || this.csvReader.readRecord()) {
                ++this.lineNumber;
                this.context.put(CTX_LINE_NUMBER, this.lineNumber);
                if (this.tokens == null) {
                    this.tokens = this.csvReader.getValues();
                }
                bytesRead += this.logDebugAndCountBytes(this.tokens);
                Statistics stats = null;
                if (this.batch != null) {
                    stats = this.statistics.get(this.batch);
                    stats.increment("READ_BYTE_COUNT", bytesRead);
                    bytesRead = 0L;
                }
                if (!(table == null || this.tokens[0].equals("table") || this.tokens[0].equals("keys") || this.tokens[0].equals("columns"))) {
                    return table;
                }
                if (stats != null && (this.tokens[0].equals("insert") || this.tokens[0].equals("update") || this.tokens[0].equals("delete"))) {
                    stats.increment("READ_RECORD_COUNT", 1L);
                }
                if (this.tokens[0].equals("insert")) {
                    CsvData data = new CsvData();
                    data.setNoBinaryOldData(this.noBinaryOldData);
                    data.setDataEventType(DataEventType.INSERT);
                    data.putParsedData("rowData", (String[])CollectionUtils.copyOfRange((Object[])this.tokens, (int)1, (int)this.tokens.length));
                    if (this.createTime != null) {
                        data.putAttribute("createTime", this.createTime);
                    }
                    data.putAttribute("channelId", this.channelId);
                    data.putAttribute("tableName", this.tableName);
                    data.putAttribute("sourceNodeId", this.sourceNodeId);
                    this.tokens = null;
                    return data;
                }
                if (this.tokens[0].equals("old")) {
                    parsedOldData = (String[])CollectionUtils.copyOfRange((Object[])this.tokens, (int)1, (int)this.tokens.length);
                } else {
                    if (this.tokens[0].equals("update")) {
                        CsvData data = new CsvData();
                        data.setNoBinaryOldData(this.noBinaryOldData);
                        data.setDataEventType(DataEventType.UPDATE);
                        int columnCount = this.context.getLastParsedTable().getColumnCount();
                        if (this.tokens.length <= columnCount) {
                            String msg = String.format("Invalid state while parsing csv data.  The number of columns (%d) reported for table '%s' doesn't match up with the token count (%d) data: %s", columnCount, this.context.getLastParsedTable().getFullyQualifiedTableName(), this.tokens.length, ArrayUtils.toString((Object)this.tokens));
                            throw new ProtocolException(msg, new Object[0]);
                        }
                        data.putParsedData("rowData", (String[])CollectionUtils.copyOfRange((Object[])this.tokens, (int)1, (int)(columnCount + 1)));
                        data.putParsedData("pkData", (String[])CollectionUtils.copyOfRange((Object[])this.tokens, (int)(columnCount + 1), (int)this.tokens.length));
                        data.putParsedData("oldData", parsedOldData);
                        if (this.createTime != null) {
                            data.putAttribute("createTime", this.createTime);
                        }
                        data.putAttribute("channelId", this.channelId);
                        data.putAttribute("tableName", this.tableName);
                        data.putAttribute("sourceNodeId", this.sourceNodeId);
                        this.tokens = null;
                        return data;
                    }
                    if (this.tokens[0].equals("delete")) {
                        CsvData data = new CsvData();
                        data.setNoBinaryOldData(this.noBinaryOldData);
                        data.setDataEventType(DataEventType.DELETE);
                        data.putParsedData("pkData", (String[])CollectionUtils.copyOfRange((Object[])this.tokens, (int)1, (int)this.tokens.length));
                        data.putParsedData("oldData", parsedOldData);
                        if (this.createTime != null) {
                            data.putAttribute("createTime", this.createTime);
                        }
                        data.putAttribute("channelId", this.channelId);
                        data.putAttribute("tableName", this.tableName);
                        data.putAttribute("sourceNodeId", this.sourceNodeId);
                        this.tokens = null;
                        return data;
                    }
                    if (this.tokens[0].equals("ts")) {
                        this.createTime = new Timestamp(Long.parseLong(this.tokens[1]) + this.baseTime);
                    } else {
                        int i;
                        if (this.tokens[0].equals("batch") || this.tokens[0].equals("retry")) {
                            Batch batch = new Batch(this.batchType, Long.parseLong(this.tokens[1]), this.channelId, this.binaryEncoding, this.sourceNodeId, this.targetNodeId, false);
                            stats = stats != null ? stats : new DataReaderStatistics();
                            this.statistics.put(batch, stats);
                            if (this.tokens[0].equals("retry") && !this.streamToFile) {
                                batch.setInvalidRetry(true);
                            }
                            this.tokens = null;
                            this.createTime = null;
                            return batch;
                        }
                        if (this.tokens[0].equals("no_binary_old_data")) {
                            if (this.tokens.length > 1) {
                                this.noBinaryOldData = Boolean.parseBoolean(this.tokens[1]);
                            }
                        } else if (this.tokens[0].equals("nodeid")) {
                            this.sourceNodeId = this.tokens[1];
                        } else if (this.tokens[0].equals("binary")) {
                            this.binaryEncoding = BinaryEncoding.valueOf((String)this.tokens[1]);
                        } else if (this.tokens[0].equals("channel")) {
                            this.channelId = this.tokens[1];
                        } else if (this.tokens[0].equals("schema")) {
                            schemaName = this.tokens.length == 1 || StringUtils.isBlank((CharSequence)this.tokens[1]) ? null : this.tokens[1];
                        } else if (this.tokens[0].equals("catalog")) {
                            catalogName = this.tokens.length == 1 || StringUtils.isBlank((CharSequence)this.tokens[1]) ? null : this.tokens[1];
                        } else if (this.tokens[0].equals("table")) {
                            this.tableName = this.tokens[1];
                            table = this.context.getParsedTables().get(Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)this.tableName));
                            if (table != null) {
                                this.context.setLastParsedTable(table);
                            } else {
                                table = new Table(catalogName, schemaName, this.tableName);
                                this.context.setLastParsedTable(table);
                            }
                        } else if (this.tokens[0].equals("keys")) {
                            if (keys == null) {
                                keys = new HashSet<String>(this.tokens.length);
                            }
                            for (i = 1; i < this.tokens.length; ++i) {
                                keys.add(this.tokens[i]);
                            }
                        } else if (this.tokens[0].equals("columns")) {
                            table.removeAllColumns();
                            for (i = 1; i < this.tokens.length; ++i) {
                                Column column = new Column(this.tokens[i], keys != null && keys.contains(this.tokens[i]));
                                table.addColumn(column);
                            }
                            this.context.getParsedTables().put(table.getFullyQualifiedTableName(), table);
                        } else {
                            if (this.tokens[0].equals("commit")) {
                                if (this.batch != null) {
                                    this.batch.setComplete(true);
                                }
                                this.tokens = null;
                                return null;
                            }
                            if (this.tokens[0].equals("sql")) {
                                CsvData data = new CsvData();
                                data.setNoBinaryOldData(this.noBinaryOldData);
                                data.setDataEventType(DataEventType.SQL);
                                data.putParsedData("rowData", new String[]{this.tokens[1], this.tokens.length > 2 ? this.tokens[2] : "0"});
                                this.tokens = null;
                                return data;
                            }
                            if (this.tokens[0].equals("bsh")) {
                                CsvData data = new CsvData();
                                data.setNoBinaryOldData(this.noBinaryOldData);
                                data.setDataEventType(DataEventType.BSH);
                                data.putParsedData("rowData", new String[]{this.tokens[1]});
                                this.tokens = null;
                                return data;
                            }
                            if (this.tokens[0].equals("create")) {
                                CsvData data = new CsvData();
                                data.setNoBinaryOldData(this.noBinaryOldData);
                                data.setDataEventType(DataEventType.CREATE);
                                data.putParsedData("rowData", new String[]{this.tokens[1]});
                                this.tokens = null;
                                return data;
                            }
                            if (this.tokens[0].equals("ignore")) {
                                if (this.batch != null) {
                                    this.batch.setIgnored(true);
                                }
                            } else if (this.tokens[0].equals("stats_columns")) {
                                statsColumns = (String[])CollectionUtils.copyOfRange((Object[])this.tokens, (int)1, (int)this.tokens.length);
                            } else if (this.tokens[0].equals("stats")) {
                                statsValues = (String[])CollectionUtils.copyOfRange((Object[])this.tokens, (int)1, (int)this.tokens.length);
                                stats = stats != null ? stats : new DataReaderStatistics();
                                this.putStats(stats, statsColumns, statsValues);
                            } else if (this.tokens[0].equals("basetime")) {
                                this.baseTime = Long.parseLong(this.tokens[1]);
                                this.createTime = new Timestamp(this.baseTime);
                            } else {
                                this.log.info("Unable to handle unknown csv values: " + Arrays.toString(this.tokens));
                            }
                        }
                    }
                }
                this.tokens = null;
            }
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
        return null;
    }

    @Override
    public Batch nextBatch() {
        if (this.next instanceof Batch) {
            this.batch = (Batch)this.next;
            this.next = null;
            return this.batch;
        }
        do {
            this.next = this.readNext();
            if (!(this.next instanceof Batch)) continue;
            this.batch = (Batch)this.next;
            this.next = null;
            return this.batch;
        } while (this.next != null);
        return null;
    }

    @Override
    public Table nextTable() {
        if (this.next instanceof Table) {
            Table table = (Table)this.next;
            this.context.setLastParsedTable(table);
            this.next = null;
            return table;
        }
        do {
            this.next = this.readNext();
            if (!(this.next instanceof Table)) continue;
            Table table = (Table)this.next;
            this.context.setLastParsedTable(table);
            this.next = null;
            return table;
        } while (this.next != null && !(this.next instanceof Batch));
        return null;
    }

    @Override
    public CsvData nextData() {
        if (this.next instanceof CsvData) {
            CsvData data = (CsvData)this.next;
            this.next = null;
            return data;
        }
        do {
            this.next = this.readNext();
            if (!(this.next instanceof CsvData)) continue;
            CsvData data = (CsvData)this.next;
            this.next = null;
            return data;
        } while (this.next != null && !(this.next instanceof Batch) && !(this.next instanceof Table));
        return null;
    }

    @Override
    public void close() {
        if (this.csvReader != null) {
            this.csvReader.close();
        }
        if (this.stagedResource != null) {
            this.stagedResource.close();
        }
    }

    @Override
    public Map<Batch, Statistics> getStatistics() {
        return this.statistics;
    }

    protected void putStats(Statistics stats, String[] statsColumns, String[] statsValues) {
        if (statsValues != null && statsColumns != null) {
            for (int i = 0; i < statsColumns.length; ++i) {
                String column = statsColumns[i];
                if (i >= statsValues.length) continue;
                long stat = Long.parseLong(statsValues[i]);
                stats.set(column, stat);
            }
        }
    }
}

