/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.Map;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.transform.ISingleValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityColumnTransform
implements ISingleValueColumnTransform,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String NAME = "identity";

    public String getName() {
        return NAME;
    }

    @Override
    public boolean isExtractColumnTransform() {
        return false;
    }

    @Override
    public boolean isLoadColumnTransform() {
        return true;
    }

    @Override
    public String transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("The {} transform requires a generated identity column.  This was configured using the {} target column.", (Object)data.getTransformation().getTransformId(), (Object)column.getTargetColumnName());
        }
        data.setGeneratedIdentityNeeded(true);
        throw new IgnoreColumnException();
    }
}

