/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.AbstractDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.ConflictException;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterConflictResolver;
import org.jumpmind.symmetric.io.data.writer.IgnoreBatchException;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseWriterConflictResolver
implements IDatabaseWriterConflictResolver {
    protected Logger log = LoggerFactory.getLogger(AbstractDatabaseWriterConflictResolver.class);

    @Override
    public void needsResolved(AbstractDatabaseWriter writer, CsvData data, AbstractDatabaseWriter.LoadStatus loadStatus) {
        DataEventType originalEventType = data.getDataEventType();
        DatabaseWriterSettings writerSettings = writer.getWriterSettings();
        Conflict conflict = writerSettings.pickConflict(writer.getTargetTable(), writer.getBatch());
        Statistics statistics = writer.getStatistics().get(writer.getBatch());
        long statementCount = statistics.get("STATEMENTCOUNT");
        long lineNumber = statistics.get("LINENUMBER");
        ResolvedData resolvedData = writerSettings.getResolvedData(statementCount);
        this.logConflictHappened(conflict, data, writer, resolvedData, lineNumber);
        block0 : switch (originalEventType) {
            case INSERT: {
                if (resolvedData != null) {
                    this.attemptToResolve(resolvedData, data, writer, conflict);
                    break;
                }
                switch (conflict.getResolveType()) {
                    case FALLBACK: {
                        this.performChainedFallbackForInsert(writer, data, conflict);
                        break block0;
                    }
                    case NEWER_WINS: {
                        boolean isWinner = false;
                        isWinner = conflict.getDetectType() == Conflict.DetectConflict.USE_TIMESTAMP ? this.isTimestampNewer(conflict, writer, data) : (conflict.getDetectType() == Conflict.DetectConflict.USE_VERSION ? this.isVersionNewer(conflict, writer, data) : this.isCaptureTimeNewer(conflict, writer, data));
                        if (isWinner) {
                            this.performChainedFallbackForInsert(writer, data, conflict);
                            break block0;
                        }
                        if (!conflict.isResolveRowOnly()) {
                            writer.getStatistics().get(writer.getBatch()).increment("CONFLICTLOSECOUNT");
                            throw new IgnoreBatchException();
                        }
                        this.ignoreRow(writer);
                        writer.getStatistics().get(writer.getBatch()).increment("CONFLICTLOSECOUNT");
                        break block0;
                    }
                    case IGNORE: {
                        writer.getStatistics().get(writer.getBatch()).increment("CONFLICTLOSECOUNT");
                        this.ignore(writer, conflict);
                        break block0;
                    }
                }
                this.attemptToResolve(resolvedData, data, writer, conflict);
                break;
            }
            case UPDATE: {
                if (resolvedData != null) {
                    this.attemptToResolve(resolvedData, data, writer, conflict);
                    break;
                }
                switch (conflict.getResolveType()) {
                    case FALLBACK: {
                        this.performChainedFallbackForUpdate(writer, data, conflict);
                        break block0;
                    }
                    case NEWER_WINS: {
                        boolean isWinner = false;
                        isWinner = conflict.getDetectType() == Conflict.DetectConflict.USE_TIMESTAMP ? this.isTimestampNewer(conflict, writer, data) : (conflict.getDetectType() == Conflict.DetectConflict.USE_VERSION ? this.isVersionNewer(conflict, writer, data) : this.isCaptureTimeNewer(conflict, writer, data));
                        if (isWinner) {
                            this.performChainedFallbackForUpdate(writer, data, conflict);
                            break block0;
                        }
                        if (!conflict.isResolveRowOnly()) {
                            writer.getStatistics().get(writer.getBatch()).increment("CONFLICTLOSECOUNT");
                            throw new IgnoreBatchException();
                        }
                        this.ignoreRow(writer);
                        writer.getStatistics().get(writer.getBatch()).increment("CONFLICTLOSECOUNT");
                        break block0;
                    }
                    case IGNORE: {
                        writer.getStatistics().get(writer.getBatch()).increment("CONFLICTLOSECOUNT");
                        this.ignore(writer, conflict);
                        break block0;
                    }
                }
                this.attemptToResolve(resolvedData, data, writer, conflict);
                break;
            }
            case DELETE: {
                switch (conflict.getResolveType()) {
                    case FALLBACK: {
                        AbstractDatabaseWriter.LoadStatus status = AbstractDatabaseWriter.LoadStatus.CONFLICT;
                        if (conflict.getDetectType() == Conflict.DetectConflict.USE_PK_DATA) {
                            status = this.performChainedFallbackForDelete(writer, data, conflict);
                        } else {
                            status = writer.delete(data, false);
                            if (status == AbstractDatabaseWriter.LoadStatus.CONFLICT) {
                                status = this.performChainedFallbackForDelete(writer, data, conflict);
                            }
                        }
                        if (status == AbstractDatabaseWriter.LoadStatus.CONFLICT) {
                            writer.getStatistics().get(writer.getBatch()).increment("MISSINGDELETECOUNT");
                        }
                        writer.getStatistics().get(writer.getBatch()).increment("CONFLICTWINCOUNT");
                        break block0;
                    }
                    case IGNORE: {
                        writer.getStatistics().get(writer.getBatch()).increment("CONFLICTWINCOUNT");
                        this.ignore(writer, conflict);
                        break block0;
                    }
                    case NEWER_WINS: {
                        AbstractDatabaseWriter.LoadStatus status = AbstractDatabaseWriter.LoadStatus.CONFLICT;
                        boolean isWinner = false;
                        isWinner = conflict.getDetectType() == Conflict.DetectConflict.USE_TIMESTAMP || conflict.getDetectType() == Conflict.DetectConflict.USE_VERSION ? true : this.isCaptureTimeNewer(conflict, writer, data);
                        if (isWinner) {
                            if (writer.getContext().getLastError() == null) {
                                status = writer.delete(data, false);
                            }
                            if (status == AbstractDatabaseWriter.LoadStatus.CONFLICT && writer.getContext().getLastError() != null) {
                                status = this.performChainedFallbackForDelete(writer, data, conflict);
                            }
                        } else {
                            this.ignoreRow(writer);
                        }
                        if (status == AbstractDatabaseWriter.LoadStatus.CONFLICT) {
                            writer.getStatistics().get(writer.getBatch()).increment("MISSINGDELETECOUNT");
                        }
                        writer.getStatistics().get(writer.getBatch()).increment("CONFLICTWINCOUNT");
                        break block0;
                    }
                }
                if (resolvedData != null) {
                    writer.getStatistics().get(writer.getBatch()).increment("CONFLICTWINCOUNT");
                    if (!resolvedData.isIgnoreRow()) {
                        writer.delete(data, false);
                        break;
                    }
                    if (conflict.isResolveRowOnly()) break;
                    throw new IgnoreBatchException();
                }
                throw new ConflictException(data, writer.getTargetTable(), false, conflict, (Exception)writer.getContext().get("DatabaseWriter.ConflictError"));
            }
        }
        writer.getContext().setLastError(null);
        this.logConflictResolution(conflict, data, writer, resolvedData, lineNumber);
        this.checkIfTransactionAborted(writer, data, conflict);
    }

    protected void performChainedFallbackForInsert(AbstractDatabaseWriter writer, CsvData data, Conflict conflict) {
        if (this.checkForUniqueKeyViolation(writer, data, conflict, writer.getContext().getLastError(), false)) {
            try {
                this.performFallbackToInsert(writer, data, conflict, true);
            }
            catch (ConflictException e) {
                this.performFallbackToUpdate(writer, data, conflict, true);
            }
        } else {
            try {
                this.performFallbackToUpdate(writer, data, conflict, true);
            }
            catch (ConflictException e) {
                if (this.checkForUniqueKeyViolation(writer, data, conflict, writer.getContext().getLastError(), true)) {
                    this.performFallbackToUpdate(writer, data, conflict, true);
                }
                throw e;
            }
        }
    }

    protected void performChainedFallbackForUpdate(AbstractDatabaseWriter writer, CsvData data, Conflict conflict) {
        block7: {
            if (writer.getContext().getLastError() == null && conflict.getDetectType() != Conflict.DetectConflict.USE_PK_DATA) {
                try {
                    this.performFallbackToUpdate(writer, data, conflict, true);
                }
                catch (ConflictException e) {
                    if (writer.getContext().getLastError() == null) {
                        this.performChainedFallbackForUpdateNoException(writer, data, conflict);
                        break block7;
                    }
                    this.performChainedFallbackForUpdateWithException(writer, data, conflict);
                }
            } else if (writer.getContext().getLastError() == null) {
                this.performChainedFallbackForUpdateNoException(writer, data, conflict);
            } else {
                this.performChainedFallbackForUpdateWithException(writer, data, conflict);
            }
        }
    }

    protected void performChainedFallbackForUpdateWithException(AbstractDatabaseWriter writer, CsvData data, Conflict conflict) {
        if (this.checkForUniqueKeyViolation(writer, data, conflict, writer.getContext().getLastError(), false) || this.checkForForeignKeyChildExistsViolation(writer, data, conflict, writer.getContext().getLastError())) {
            try {
                this.performFallbackToUpdate(writer, data, conflict, true);
            }
            catch (ConflictException e) {
                this.performFallbackToInsert(writer, data, conflict, true);
            }
        } else if (this.checkForUniqueKeyViolation(writer, data, conflict, writer.getContext().getLastError(), true)) {
            this.performFallbackToUpdate(writer, data, conflict, true);
        } else {
            throw new ConflictException(data, writer.getTargetTable(), false, conflict, (Exception)writer.getContext().get("DatabaseWriter.ConflictError"));
        }
    }

    protected void performChainedFallbackForUpdateNoException(AbstractDatabaseWriter writer, CsvData data, Conflict conflict) {
        try {
            this.performFallbackToInsert(writer, data, conflict, true);
        }
        catch (ConflictException e) {
            if (this.checkForUniqueKeyViolation(writer, data, conflict, writer.getContext().getLastError(), true)) {
                this.performFallbackToInsert(writer, data, conflict, true);
            }
            throw e;
        }
    }

    protected AbstractDatabaseWriter.LoadStatus performChainedFallbackForDelete(AbstractDatabaseWriter writer, CsvData data, Conflict conflict) {
        AbstractDatabaseWriter.LoadStatus status = AbstractDatabaseWriter.LoadStatus.CONFLICT;
        if (this.checkForForeignKeyChildExistsViolation(writer, data, conflict, writer.getContext().getLastError())) {
            this.checkIfTransactionAborted(writer, data, conflict);
            status = writer.delete(data, false);
        }
        return status;
    }

    protected void beforeResolutionAttempt(CsvData data, Conflict conflict) {
    }

    protected void afterResolutionAttempt(CsvData data, Conflict conflict) {
    }

    protected void logConflictHappened(Conflict conflict, CsvData data, AbstractDatabaseWriter writer, ResolvedData resolvedData, long lineNumber) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Conflict detected: {} in batch {} at line {} for table {}", new Object[]{conflict.getConflictId() == null ? "default" : conflict.getConflictId(), writer.getBatch().getNodeBatchId(), lineNumber, writer.getTargetTable().getFullyQualifiedTableName()});
            String csvData = data.getCsvData("rowData");
            if (StringUtils.isNotBlank((CharSequence)csvData)) {
                this.log.debug("Row data: {}", (Object)csvData);
            }
            if (StringUtils.isNotBlank((CharSequence)(csvData = data.getCsvData("oldData")))) {
                this.log.debug("Old data: {}", (Object)csvData);
            }
            String string = csvData = resolvedData != null ? resolvedData.getResolvedData() : null;
            if (StringUtils.isNotBlank((CharSequence)csvData)) {
                this.log.debug("Resolve data: {}", (Object)csvData);
            }
        }
    }

    protected void logConflictResolution(Conflict conflict, CsvData data, AbstractDatabaseWriter writer, ResolvedData resolvedData, long lineNumber) {
        if (writer.getWriterSettings().isLogConflictResolution()) {
            this.log.info("Conflict detected: {} in batch {} at line {} for table {}", new Object[]{conflict.getConflictId() == null ? "default" : conflict.getConflictId(), writer.getBatch().getBatchId(), lineNumber, writer.getTargetTable().getFullyQualifiedTableName()});
            String csvData = data.getCsvData("rowData");
            if (StringUtils.isNotBlank((CharSequence)csvData)) {
                this.log.info("Row data: {}", (Object)csvData);
            }
            if (StringUtils.isNotBlank((CharSequence)(csvData = data.getCsvData("oldData")))) {
                this.log.info("Old data: {}", (Object)csvData);
            }
            String string = csvData = resolvedData != null ? resolvedData.getResolvedData() : null;
            if (StringUtils.isNotBlank((CharSequence)csvData)) {
                this.log.info("Resolve data: {}", (Object)csvData);
            }
            this.log.info("Resolve Type: {}", (Object)conflict.getResolveType());
        }
    }

    protected void ignore(AbstractDatabaseWriter writer, Conflict conflict) {
        if (!conflict.isResolveRowOnly()) {
            throw new IgnoreBatchException();
        }
        writer.getStatistics().get(writer.getBatch()).increment("IGNOREROWCOUNT");
    }

    @Override
    public void attemptToResolve(ResolvedData resolvedData, CsvData data, AbstractDatabaseWriter writer, Conflict conflict) {
        if (resolvedData != null) {
            if (!resolvedData.isIgnoreRow()) {
                data.putCsvData("rowData", resolvedData.getResolvedData());
                try {
                    this.performFallbackToUpdate(writer, data, conflict, true);
                }
                catch (ConflictException ex) {
                    this.performFallbackToInsert(writer, data, conflict, true);
                }
            } else {
                writer.getStatistics().get(writer.getBatch()).increment("CONFLICTLOSECOUNT");
            }
        } else {
            throw new ConflictException(data, writer.getTargetTable(), false, conflict, (Exception)writer.getContext().get("DatabaseWriter.ConflictError"));
        }
    }

    protected abstract boolean isTimestampNewer(Conflict var1, AbstractDatabaseWriter var2, CsvData var3);

    protected abstract boolean isCaptureTimeNewer(Conflict var1, AbstractDatabaseWriter var2, CsvData var3);

    protected abstract boolean isVersionNewer(Conflict var1, AbstractDatabaseWriter var2, CsvData var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFallbackToUpdate(AbstractDatabaseWriter writer, CsvData data, Conflict conflict, boolean retransform) {
        try {
            this.beforeResolutionAttempt(data, conflict);
            this.checkIfTransactionAborted(writer, data, conflict);
            AbstractDatabaseWriter.LoadStatus loadStatus = writer.update(data, conflict.isResolveChangesOnly(), false);
            if (loadStatus != AbstractDatabaseWriter.LoadStatus.SUCCESS) {
                throw new ConflictException(data, writer.getTargetTable(), true, conflict, (Exception)writer.getContext().get("DatabaseWriter.ConflictError"));
            }
            writer.getStatistics().get(writer.getBatch()).increment("CONFLICTWINCOUNT");
            writer.getStatistics().get(writer.getBatch()).increment("FALLBACKUPDATECOUNT");
        }
        finally {
            this.afterResolutionAttempt(data, conflict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFallbackToInsert(AbstractDatabaseWriter writer, CsvData csvData, Conflict conflict, boolean retransform) {
        try {
            this.beforeResolutionAttempt(csvData, conflict);
            this.checkIfTransactionAborted(writer, csvData, conflict);
            AbstractDatabaseWriter.LoadStatus loadStatus = writer.insert(csvData);
            if (loadStatus != AbstractDatabaseWriter.LoadStatus.SUCCESS) {
                throw new ConflictException(csvData, writer.getTargetTable(), true, conflict, (Exception)writer.getContext().get("DatabaseWriter.ConflictError"));
            }
            writer.getStatistics().get(writer.getBatch()).increment("CONFLICTWINCOUNT");
            writer.getStatistics().get(writer.getBatch()).increment("FALLBACKINSERTCOUNT");
        }
        finally {
            this.afterResolutionAttempt(csvData, conflict);
        }
    }

    protected void ignoreRow(AbstractDatabaseWriter writer) {
        if (Boolean.TRUE.equals(writer.getContext().get("DatabaseWriter.TransactionAborted"))) {
            writer.getContext().put("DatabaseWriter.ConflictIgnore", true);
        }
    }

    protected void checkIfTransactionAborted(AbstractDatabaseWriter writer, CsvData csvData, Conflict conflict) {
        if (Boolean.TRUE.equals(writer.getContext().get("DatabaseWriter.TransactionAborted"))) {
            throw new ConflictException(csvData, writer.getTargetTable(), false, conflict, (Exception)writer.getContext().get("DatabaseWriter.ConflictError"));
        }
    }

    protected abstract boolean checkForUniqueKeyViolation(AbstractDatabaseWriter var1, CsvData var2, Conflict var3, Throwable var4, boolean var5);

    protected abstract boolean checkForForeignKeyChildExistsViolation(AbstractDatabaseWriter var1, CsvData var2, Conflict var3, Throwable var4);

    protected abstract boolean isConflictingLosingParentRow(AbstractDatabaseWriter var1, CsvData var2);

    @Override
    public boolean isIgnoreRow(AbstractDatabaseWriter writer, CsvData data) {
        Statistics statistics;
        long statementCount;
        DatabaseWriterSettings writerSettings = writer.getWriterSettings();
        ResolvedData resolvedData = writerSettings.getResolvedData(statementCount = (statistics = writer.getStatistics().get(writer.getBatch())).get("STATEMENTCOUNT"));
        if (resolvedData != null) {
            return resolvedData.isIgnoreRow();
        }
        return this.isConflictingLosingParentRow(writer, data);
    }
}

