/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;

public class Conflict
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String conflictId;
    private String targetChannelId;
    private String targetCatalogName;
    private String targetSchemaName;
    private String targetTableName;
    private DetectConflict detectType = DetectConflict.USE_CHANGED_DATA;
    private String detectExpression;
    private ResolveConflict resolveType = ResolveConflict.NEWER_WINS;
    private boolean resolveChangesOnly = false;
    private boolean resolveRowOnly = true;
    private Date createTime = new Date();
    private String lastUpdateBy = "symmetricds";
    private Date lastUpdateTime = new Date();
    private PingBack pingBack = PingBack.OFF;

    public String toQualifiedTableName() {
        if (StringUtils.isNotBlank((CharSequence)this.targetTableName)) {
            return Table.getFullyQualifiedTableName((String)this.targetCatalogName, (String)this.targetSchemaName, (String)this.targetTableName).toLowerCase();
        }
        return null;
    }

    public String getConflictId() {
        return this.conflictId;
    }

    public void setConflictId(String conflictId) {
        this.conflictId = conflictId;
    }

    public String getTargetChannelId() {
        return this.targetChannelId;
    }

    public void setTargetChannelId(String targetChannelId) {
        this.targetChannelId = targetChannelId;
    }

    public String getTargetCatalogName() {
        return this.targetCatalogName;
    }

    public void setTargetCatalogName(String targetCatalogName) {
        this.targetCatalogName = targetCatalogName;
    }

    public String getTargetSchemaName() {
        return this.targetSchemaName;
    }

    public void setTargetSchemaName(String targetSchemaName) {
        this.targetSchemaName = targetSchemaName;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public void setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
    }

    public DetectConflict getDetectType() {
        return this.detectType;
    }

    public void setDetectType(DetectConflict detectUpdateType) {
        this.detectType = detectUpdateType;
    }

    public ResolveConflict getResolveType() {
        return this.resolveType;
    }

    public void setResolveType(ResolveConflict resolveUpdateType) {
        this.resolveType = resolveUpdateType;
    }

    public boolean isResolveChangesOnly() {
        return this.resolveChangesOnly;
    }

    public void setResolveChangesOnly(boolean resolveChangesOnly) {
        this.resolveChangesOnly = resolveChangesOnly;
    }

    public boolean isResolveRowOnly() {
        return this.resolveRowOnly;
    }

    public void setResolveRowOnly(boolean resolveRowOnly) {
        this.resolveRowOnly = resolveRowOnly;
    }

    public String getDetectExpression() {
        return this.detectExpression;
    }

    public String getDetectExpressionValue(DetectExpressionKey key) {
        String value = null;
        if (key != null && this.detectExpression != null) {
            String[] parms;
            for (String parm : parms = this.detectExpression.split(";")) {
                String[] args = parm.split("=");
                if (args.length != 2 || !args[0].trim().equalsIgnoreCase(key.name())) continue;
                value = args[1].trim();
                break;
            }
        }
        return value;
    }

    public void setDetectExpression(String conflictColumnName) {
        this.detectExpression = conflictColumnName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setPingBack(PingBack pingBack) {
        this.pingBack = pingBack;
    }

    public PingBack getPingBack() {
        return this.pingBack;
    }

    public static enum DetectExpressionKey {
        EXCLUDED_COLUMN_NAMES;

    }

    public static enum PingBack {
        OFF,
        SINGLE_ROW,
        REMAINING_ROWS;

    }

    public static enum ResolveConflict {
        NEWER_WINS,
        FALLBACK,
        MANUAL,
        IGNORE;

    }

    public static enum DetectConflict {
        USE_CHANGED_DATA,
        USE_OLD_DATA,
        USE_PK_DATA,
        USE_TIMESTAMP,
        USE_VERSION;

    }
}

