/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.wrapper;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.jumpmind.symmetric.wrapper.Constants;
import org.jumpmind.symmetric.wrapper.MacService;
import org.jumpmind.symmetric.wrapper.UnixService;
import org.jumpmind.symmetric.wrapper.WindowsService;
import org.jumpmind.symmetric.wrapper.WrapperConfig;
import org.jumpmind.symmetric.wrapper.WrapperException;
import org.jumpmind.symmetric.wrapper.WrapperLogFormatter;
import org.jumpmind.symmetric.wrapper.WrapperLogHandler;

public abstract class WrapperService {
    private static final Logger logger = Logger.getLogger(WrapperService.class.getName());
    protected WrapperConfig config;
    protected boolean keepRunning = true;
    protected Process child;
    private static WrapperService instance;

    public static WrapperService getInstance() {
        instance = Platform.isWindows() ? new WindowsService() : (Platform.isMac() ? new MacService() : new UnixService());
        return instance;
    }

    public void loadConfig(String applHomeDir, String configFile, String jarFile) throws IOException {
        this.config = new WrapperConfig(applHomeDir, configFile, jarFile);
        this.setWorkingDirectory(this.config.getWorkingDirectory().getAbsolutePath());
    }

    public WrapperConfig getConfig() {
        return this.config;
    }

    public void start() {
        int rc;
        boolean success;
        Process process;
        ArrayList<String> output;
        ArrayList<String> cmdLine;
        block43: {
            if (this.isRunning()) {
                throw new WrapperException(5, 0, "Server is already running");
            }
            this.stopProcesses(true);
            System.out.println("Waiting for server to start");
            cmdLine = this.getWrapperCommand("exec", false);
            output = new ArrayList<String>();
            process = null;
            success = false;
            rc = 0;
            try {
                ProcessBuilder pb = new ProcessBuilder(cmdLine).redirectErrorStream(true);
                process = pb.start();
                if (!this.config.getApplicationOutputStart().equals("")) {
                    int pid = this.getProcessPid(process);
                    try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        String line = null;
                        block26: for (int seconds = 0; seconds <= 60; ++seconds) {
                            System.out.print(".");
                            if (!this.isPidRunning(pid)) break;
                            while (reader2.ready() && (line = reader2.readLine()) != null) {
                                output.add(line);
                                System.out.print(":");
                                if (!line.equals(this.config.getApplicationOutputStart())) continue;
                                break block26;
                            }
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        System.out.println("");
                    }
                    catch (Exception reader2) {
                        // empty catch block
                    }
                    success = this.isPidRunning(pid);
                    break block43;
                }
                success = this.waitForPid(this.getProcessPid(process));
                if (!success) {
                    rc = process.exitValue();
                }
            }
            catch (IOException e) {
                rc = -1;
                System.out.println(e.getMessage());
            }
        }
        if (!success) {
            System.err.println(this.commandToString(cmdLine));
            if (output.size() > 0) {
                for (String line : output) {
                    System.err.println(line);
                }
            } else {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        System.err.println(line);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new WrapperException(8, rc, "Failed second stage");
        }
        System.out.println("Started");
    }

    public void init() {
        this.execJava(false);
    }

    public void console() {
        if (this.isRunning()) {
            throw new WrapperException(5, 0, "Server is already running");
        }
        this.execJava(true);
    }

    protected void execJava(boolean isConsole) {
        try {
            LogManager.getLogManager().reset();
            WrapperLogHandler handler = new WrapperLogHandler(this.config.getLogFile(), this.config.getLogFileMaxSize(), this.config.getLogFileMaxFiles());
            handler.setFormatter(new WrapperLogFormatter());
            Logger rootLogger = Logger.getLogger("");
            rootLogger.setLevel(Level.parse(this.config.getLogFileLogLevel()));
            rootLogger.addHandler(handler);
        }
        catch (IOException e) {
            throw new WrapperException(7, 0, "Cannot open log file " + this.config.getLogFile(), e);
        }
        try {
            int pid = this.getCurrentPid();
            this.writePidToFile(pid, this.config.getWrapperPidFile());
            logger.log(Level.INFO, "Started wrapper as PID " + pid);
            ArrayList<String> cmd = this.config.getCommand(isConsole);
            String cmdString = this.commandToString(cmd);
            boolean usingHeapDump = cmdString.indexOf("-XX:+HeapDumpOnOutOfMemoryError") != -1;
            logger.log(Level.INFO, "Working directory is " + System.getProperty("user.dir"));
            long startTime = 0L;
            int startCount = 0;
            boolean startProcess = true;
            boolean restartDetected = false;
            int serverPid = 0;
            while (this.keepRunning) {
                if (startProcess) {
                    logger.log(Level.INFO, "Executing " + cmdString);
                    if (startCount == 0) {
                        this.updateStatus(Constants.Status.START_PENDING);
                    }
                    startTime = System.currentTimeMillis();
                    ProcessBuilder pb = new ProcessBuilder(cmd);
                    pb.redirectErrorStream(true);
                    this.initEnvironment(pb);
                    try {
                        this.child = pb.start();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Failed to execute: " + e.getMessage());
                        this.updateStatus(Constants.Status.STOPPED);
                        throw new WrapperException(8, -1, "Failed executing server", e);
                    }
                    serverPid = this.getProcessPid(this.child);
                    logger.log(Level.INFO, "Started server as PID " + serverPid);
                    this.writePidToFile(serverPid, this.config.getServerPidFile());
                    if (startCount == 0) {
                        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
                        if (this.config.getApplicationOutputStart().equals("")) {
                            this.updateStatus(Constants.Status.RUNNING);
                        }
                    }
                    startProcess = false;
                    ++startCount;
                    continue;
                }
                try (BufferedReader childReader = new BufferedReader(new InputStreamReader(this.child.getInputStream()));){
                    logger.log(Level.INFO, "Watching output of java process");
                    String line = null;
                    while ((line = childReader.readLine()) != null) {
                        System.out.println(line);
                        logger.log(Level.INFO, line, "java");
                        if (usingHeapDump && line.matches("Heap dump file created.*") || !usingHeapDump && line.matches("java.lang.OutOfMemoryError.*") || line.matches(".*java.net.BindException.*") || line.matches(".*A fatal error has been detected.*")) {
                            logger.log(Level.SEVERE, "Stopping server because its output matches a failure condition");
                            this.child.destroy();
                            this.stopProcess(serverPid, "server");
                            break;
                        }
                        if (!this.config.getApplicationOutputStart().equals("") && line.equalsIgnoreCase(this.config.getApplicationOutputStart())) {
                            logger.log(Level.INFO, "Setting status to running");
                            this.updateStatus(Constants.Status.RUNNING);
                            continue;
                        }
                        if (this.config.getApplicationOutputRestart().equals("") || !line.equalsIgnoreCase(this.config.getApplicationOutputRestart())) continue;
                        restartDetected = true;
                    }
                    logger.log(Level.INFO, "End of output from java process");
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Error while reading from process");
                }
                if (restartDetected) {
                    logger.log(Level.INFO, "Restart detected");
                    restartDetected = false;
                    startProcess = true;
                    continue;
                }
                if (!this.keepRunning) continue;
                long tenminutesinms = 600000L;
                long twelveminutesinms = 720000L;
                long tensecondsinms = 10000L;
                long now = System.currentTimeMillis();
                while (this.child.isAlive()) {
                    logger.log(Level.WARNING, "Server process has not stopped yet");
                    if (System.currentTimeMillis() - now > twelveminutesinms) {
                        logger.log(Level.SEVERE, "Server process never exited, exiting now");
                        this.child.destroyForcibly();
                        break;
                    }
                    if (System.currentTimeMillis() - now > tenminutesinms) {
                        logger.log(Level.SEVERE, "Server process never exited, trying to force the exit of server process");
                        this.child.destroyForcibly();
                    }
                    try {
                        Thread.sleep(tensecondsinms);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                logger.log(Level.SEVERE, "Unexpected exit from server: " + this.child.exitValue());
                long runTime = System.currentTimeMillis() - startTime;
                if (System.currentTimeMillis() - startTime < 7000L) {
                    logger.log(Level.SEVERE, "Stopping because server exited too quickly after only " + runTime + " milliseconds");
                    this.updateStatus(Constants.Status.STOPPED);
                    this.deletePidFile(this.config.getServerPidFile());
                    throw new WrapperException(16, this.child.exitValue(), "Unexpected exit from server");
                }
                startProcess = true;
            }
        }
        catch (Throwable ex) {
            try {
                logger.log(Level.SEVERE, "Exception caught.\r\n" + WrapperService.getStackTrace(ex));
                this.updateStatus(Constants.Status.STOPPED);
                throw new WrapperException(16, this.child.exitValue(), "Exception caught.", ex);
            }
            catch (Throwable ex2) {
                ex2.printStackTrace();
            }
        }
    }

    protected void initEnvironment(ProcessBuilder pb) {
    }

    public void stop() {
        this.stopProcesses(false);
        this.deletePidFile(this.config.getServerPidFile());
        this.deletePidFile(this.config.getWrapperPidFile());
        System.out.println("Stopped");
    }

    protected void stopProcesses(boolean isStopAbandoned) {
        int serverPid = this.readPidFromFile(this.config.getServerPidFile());
        int wrapperPid = this.readPidFromFile(this.config.getWrapperPidFile());
        boolean isServerRunning = this.isPidRunning(serverPid);
        boolean isWrapperRunning = this.isPidRunning(wrapperPid);
        if (!isStopAbandoned) {
            if (!isServerRunning && !isWrapperRunning) {
                throw new WrapperException(6, 0, "Server is not running");
            }
            System.out.println("Waiting for server to stop");
        }
        if (isWrapperRunning) {
            if (isStopAbandoned) {
                System.out.println("Stopping abandoned wrapper PID " + wrapperPid);
            }
            boolean bl = isWrapperRunning = !this.stopProcess(wrapperPid, "wrapper");
        }
        if (isServerRunning) {
            if (isStopAbandoned) {
                System.out.println("Stopping abandoned server PID " + serverPid);
            }
            boolean bl = isServerRunning = !this.stopProcess(serverPid, "server");
        }
        if (isWrapperRunning || isServerRunning) {
            throw new WrapperException(9, 0, "Server did not stop");
        }
    }

    protected boolean stopProcess(int pid, String name) {
        this.killProcess(pid, false);
        if (this.waitForPid(pid)) {
            this.killProcess(pid, true);
            if (this.waitForPid(pid)) {
                System.out.println("ERROR: '" + name + "' did not stop");
                return false;
            }
        }
        return true;
    }

    protected void shutdown() {
        if (this.keepRunning) {
            this.keepRunning = false;
            new Thread(){

                @Override
                public void run() {
                    logger.log(Level.INFO, "Stopping server");
                    WrapperService.this.child.destroy();
                    logger.log(Level.INFO, "Stopping wrapper");
                    WrapperService.this.deletePidFile(WrapperService.this.config.getWrapperPidFile());
                    WrapperService.this.deletePidFile(WrapperService.this.config.getServerPidFile());
                    WrapperService.this.updateStatus(Constants.Status.STOPPED);
                    System.exit(0);
                }
            }.start();
        }
    }

    public void restart() {
        if (this.isRunning()) {
            this.stop();
        }
        this.start();
    }

    public void relaunchAsPrivileged(String className) {
    }

    public void status() {
        boolean isRunning = this.isRunning();
        int wrapperPid = this.readPidFromFile(this.config.getWrapperPidFile());
        int serverPid = this.readPidFromFile(this.config.getServerPidFile());
        System.out.println("Installed: " + this.isInstalled());
        System.out.println("Running: " + isRunning);
        System.out.println("Wrapper PID: " + wrapperPid);
        System.out.println("Wrapper Running: " + this.isPidRunning(wrapperPid));
        System.out.println("Server PID: " + serverPid);
        System.out.println("Server Running: " + this.isPidRunning(serverPid));
    }

    public boolean isRunning() {
        return this.isPidRunning(this.readPidFromFile(this.config.getWrapperPidFile())) && this.isPidRunning(this.readPidFromFile(this.config.getServerPidFile()));
    }

    public int getWrapperPid() {
        return this.readPidFromFile(this.config.getWrapperPidFile());
    }

    public int getServerPid() {
        return this.readPidFromFile(this.config.getServerPidFile());
    }

    protected String commandToString(ArrayList<String> cmd) {
        StringBuilder sb = new StringBuilder();
        for (String c : cmd) {
            sb.append(c).append(" ");
        }
        return sb.toString();
    }

    protected ArrayList<String> getWrapperCommand(String arg, boolean isQuotedArguments) {
        ArrayList<String> cmd = new ArrayList<String>();
        String quote = isQuotedArguments ? this.getWrapperCommandQuote() : "";
        cmd.add(quote + this.config.getJavaCommand() + quote);
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir != null && tmpDir.endsWith("\\")) {
            tmpDir = tmpDir.substring(0, tmpDir.length() - 1);
        }
        cmd.add("-Djava.io.tmpdir=" + quote + tmpDir + quote);
        cmd.add("-jar");
        cmd.add(quote + this.config.getWrapperJarPath() + quote);
        cmd.add(arg);
        cmd.add(quote + this.config.getConfigFile() + quote);
        return cmd;
    }

    protected ArrayList<String> getPrivilegedCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        String quote = this.getWrapperCommandQuote();
        cmd.add(quote + this.config.getJavaCommand() + quote);
        return cmd;
    }

    protected String getWrapperCommandQuote() {
        return "";
    }

    protected int readPidFromFile(String filename) {
        int pid = 0;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            pid = Integer.parseInt(reader.readLine());
            reader.close();
        }
        catch (FileNotFoundException reader) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pid;
    }

    protected void writePidToFile(int pid, String filename) {
        try {
            FileWriter writer = new FileWriter(filename, false);
            writer.write(String.valueOf(pid));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void deletePidFile(String filename) {
        new File(filename).delete();
    }

    protected boolean waitForPid(int pid) {
        for (int seconds = 0; seconds <= 5; ++seconds) {
            System.out.print(".");
            if (!this.isPidRunning(pid)) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.out.println("");
        return this.isPidRunning(pid);
    }

    protected void updateStatus(Constants.Status status) {
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public abstract void install();

    public abstract void uninstall();

    public abstract boolean isInstalled();

    public abstract boolean isPrivileged();

    protected abstract boolean setWorkingDirectory(String var1);

    protected abstract int getProcessPid(Process var1);

    protected abstract int getCurrentPid();

    protected abstract boolean isPidRunning(int var1);

    protected abstract void killProcess(int var1, boolean var2);

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            WrapperService.this.shutdown();
        }
    }
}

